/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.legacy;

import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.index.lucene.QueryContext;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.ImpermanentDatabaseRule;

public class LegacyIndexRegressionTest {
    @Rule
    public final DatabaseRule graphdb = new ImpermanentDatabaseRule();

    @Test
    public void shouldAccessAndUpdateIndexInSameTransaction() throws Exception {
        try (Transaction tx = this.graphdb.beginTx();){
            Index version = this.graphdb.index().forNodes("version");
            for (int v = 0; v < 10; ++v) {
                this.createNode((Index<Node>)version, v);
            }
            tx.success();
        }
    }

    private void createNode(Index<Node> index, long version) {
        this.highest("version", (IndexHits<Node>)index.query((Object)new QueryContext((Object)"version:*")));
        Node node = this.graphdb.createNode();
        node.setProperty("version", (Object)version);
        index.add((PropertyContainer)node, "version", (Object)version);
        node = (Node)index.get("version", (Object)version).getSingle();
        Node current = this.highest("version", (IndexHits<Node>)index.get("current", (Object)"current"));
        if (current != null) {
            index.remove((PropertyContainer)current, "current");
        }
        index.add((PropertyContainer)node, "current", (Object)"current");
    }

    private Node highest(String key, IndexHits<Node> query) {
        try (IndexHits<Node> hits = query;){
            long highestValue = Long.MIN_VALUE;
            Node highestNode = null;
            while (hits.hasNext()) {
                Node node = (Node)hits.next();
                long value = ((Number)node.getProperty(key)).longValue();
                if (value <= highestValue) continue;
                highestValue = value;
                highestNode = node;
            }
            Node node = highestNode;
            return node;
        }
    }
}

