/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene.legacy;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.RelationshipIndex;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.index.Neo4jTestCase;
import org.neo4j.index.impl.lucene.legacy.LuceneIndexImplementation;
import org.neo4j.kernel.impl.index.IndexConfigStore;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class TestMigration {
    @Rule
    public final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();

    @Test
    public void canReadAndUpgradeOldIndexStoreFormat() throws Exception {
        File path = new File("target/var/old-index-store");
        Neo4jTestCase.deleteFileOrDirectory(path);
        this.startDatabase(path).shutdown();
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream("old-index.db");
        this.writeFile(stream, new File(path, "index.db"));
        GraphDatabaseService db = this.startDatabase(path);
        try (Transaction ignore = db.beginTx();){
            Assert.assertTrue((boolean)db.index().existsForNodes("indexOne"));
            Index indexOne = db.index().forNodes("indexOne");
            this.verifyConfiguration(db, (Index<? extends PropertyContainer>)indexOne, LuceneIndexImplementation.EXACT_CONFIG);
            Assert.assertTrue((boolean)db.index().existsForNodes("indexTwo"));
            Index indexTwo = db.index().forNodes("indexTwo");
            this.verifyConfiguration(db, (Index<? extends PropertyContainer>)indexTwo, LuceneIndexImplementation.FULLTEXT_CONFIG);
            Assert.assertTrue((boolean)db.index().existsForRelationships("indexThree"));
            RelationshipIndex indexThree = db.index().forRelationships("indexThree");
            this.verifyConfiguration(db, (Index<? extends PropertyContainer>)indexThree, LuceneIndexImplementation.EXACT_CONFIG);
        }
        db.shutdown();
    }

    private void verifyConfiguration(GraphDatabaseService db, Index<? extends PropertyContainer> index, Map<String, String> config) {
        Assert.assertEquals(config, (Object)db.index().getConfiguration(index));
    }

    private void writeFile(InputStream stream, File file) throws Exception {
        file.delete();
        FileOutputStream out = new FileOutputStream(file);
        byte[] bytes = new byte[1024];
        int bytesRead = 0;
        while ((bytesRead = stream.read(bytes)) >= 0) {
            ((OutputStream)out).write(bytes, 0, bytesRead);
        }
        ((OutputStream)out).close();
    }

    @Test
    public void providerGetsFilledInAutomatically() {
        Map correctConfig = MapUtil.stringMap((String[])new String[]{"type", "exact", "provider", "lucene"});
        File storeDir = new File("target/var/index");
        Neo4jTestCase.deleteFileOrDirectory(storeDir);
        GraphDatabaseService graphDb = this.startDatabase(storeDir);
        try (Transaction transaction = graphDb.beginTx();){
            Assert.assertEquals((Object)correctConfig, (Object)graphDb.index().getConfiguration(graphDb.index().forNodes("default")));
            Assert.assertEquals((Object)correctConfig, (Object)graphDb.index().getConfiguration(graphDb.index().forNodes("wo-provider", MapUtil.stringMap((String[])new String[]{"type", "exact"}))));
            Assert.assertEquals((Object)correctConfig, (Object)graphDb.index().getConfiguration(graphDb.index().forNodes("w-provider", MapUtil.stringMap((String[])new String[]{"type", "exact", "provider", "lucene"}))));
            Assert.assertEquals((Object)correctConfig, (Object)graphDb.index().getConfiguration((Index)graphDb.index().forRelationships("default")));
            Assert.assertEquals((Object)correctConfig, (Object)graphDb.index().getConfiguration((Index)graphDb.index().forRelationships("wo-provider", MapUtil.stringMap((String[])new String[]{"type", "exact"}))));
            Assert.assertEquals((Object)correctConfig, (Object)graphDb.index().getConfiguration((Index)graphDb.index().forRelationships("w-provider", MapUtil.stringMap((String[])new String[]{"type", "exact", "provider", "lucene"}))));
            transaction.success();
        }
        graphDb.shutdown();
        this.removeProvidersFromIndexDbFile(storeDir);
        graphDb = this.startDatabase(storeDir);
        transaction = graphDb.beginTx();
        var5_5 = null;
        try {
            Assert.assertEquals((Object)correctConfig, (Object)graphDb.index().getConfiguration(graphDb.index().forNodes("default")));
            Assert.assertEquals((Object)correctConfig, (Object)graphDb.index().getConfiguration(graphDb.index().forNodes("wo-provider", MapUtil.stringMap((String[])new String[]{"type", "exact"}))));
            Assert.assertEquals((Object)correctConfig, (Object)graphDb.index().getConfiguration(graphDb.index().forNodes("w-provider", MapUtil.stringMap((String[])new String[]{"type", "exact", "provider", "lucene"}))));
            Assert.assertEquals((Object)correctConfig, (Object)graphDb.index().getConfiguration((Index)graphDb.index().forRelationships("default")));
            Assert.assertEquals((Object)correctConfig, (Object)graphDb.index().getConfiguration((Index)graphDb.index().forRelationships("wo-provider", MapUtil.stringMap((String[])new String[]{"type", "exact"}))));
            Assert.assertEquals((Object)correctConfig, (Object)graphDb.index().getConfiguration((Index)graphDb.index().forRelationships("w-provider", MapUtil.stringMap((String[])new String[]{"type", "exact", "provider", "lucene"}))));
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (transaction != null) {
                if (var5_5 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    transaction.close();
                }
            }
        }
        graphDb.shutdown();
        this.removeProvidersFromIndexDbFile(storeDir);
        graphDb = this.startDatabase(storeDir);
        transaction = graphDb.beginTx();
        var5_5 = null;
        try {
            Assert.assertEquals((Object)correctConfig, (Object)graphDb.index().getConfiguration(graphDb.index().forNodes("default")));
            Assert.assertEquals((Object)correctConfig, (Object)graphDb.index().getConfiguration(graphDb.index().forNodes("wo-provider")));
            Assert.assertEquals((Object)correctConfig, (Object)graphDb.index().getConfiguration(graphDb.index().forNodes("w-provider")));
            Assert.assertEquals((Object)correctConfig, (Object)graphDb.index().getConfiguration((Index)graphDb.index().forRelationships("default")));
            Assert.assertEquals((Object)correctConfig, (Object)graphDb.index().getConfiguration((Index)graphDb.index().forRelationships("wo-provider")));
            Assert.assertEquals((Object)correctConfig, (Object)graphDb.index().getConfiguration((Index)graphDb.index().forRelationships("w-provider")));
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (transaction != null) {
                if (var5_5 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    transaction.close();
                }
            }
        }
        graphDb.shutdown();
    }

    private GraphDatabaseService startDatabase(File storeDir) {
        return new TestGraphDatabaseFactory().newEmbeddedDatabase(storeDir);
    }

    private void removeProvidersFromIndexDbFile(File storeDir) {
        IndexConfigStore indexStore = new IndexConfigStore(storeDir, this.fileSystemRule.get());
        for (Class cls : new Class[]{Node.class, Relationship.class}) {
            for (String name : indexStore.getNames(cls)) {
                HashMap config = indexStore.get(cls, name);
                config = new HashMap(config);
                config.remove("provider");
                indexStore.set(Node.class, name, config);
            }
        }
    }
}

