/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene.legacy;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.LockSupport;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseFactoryState;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.ConfigurationValidator;
import org.neo4j.kernel.impl.factory.CommunityEditionModule;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.impl.factory.PlatformModule;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.logging.NullLogService;
import org.neo4j.kernel.impl.util.Neo4jJobScheduler;
import org.neo4j.logging.LogProvider;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class NonUniqueIndexTest {
    @Rule
    public final TestDirectory directory = TestDirectory.testDirectory(this.getClass());
    @Rule
    public final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();

    @Test
    public void concurrentIndexPopulationAndInsertsShouldNotProduceDuplicates() throws Exception {
        Node node;
        GraphDatabaseService db = this.newEmbeddedGraphDatabaseWithSlowJobScheduler();
        try (Transaction tx = db.beginTx();){
            db.schema().indexFor(Label.label((String)"SomeLabel")).on("key").create();
            tx.success();
        }
        try (Transaction tx = db.beginTx();){
            node = db.createNode(new Label[]{Label.label((String)"SomeLabel")});
            node.setProperty("key", (Object)"value");
            tx.success();
        }
        db.shutdown();
        Assert.assertThat(this.nodeIdsInIndex(1, "value"), (Matcher)CoreMatchers.equalTo(Collections.singletonList(node.getId())));
    }

    private GraphDatabaseService newEmbeddedGraphDatabaseWithSlowJobScheduler() {
        GraphDatabaseFactoryState graphDatabaseFactoryState = new GraphDatabaseFactoryState();
        graphDatabaseFactoryState.setUserLogProvider(NullLogService.getInstance().getUserLogProvider());
        return new GraphDatabaseFacadeFactory(DatabaseInfo.COMMUNITY, CommunityEditionModule::new){

            protected PlatformModule createPlatform(File storeDir, Config config, GraphDatabaseFacadeFactory.Dependencies dependencies, GraphDatabaseFacade graphDatabaseFacade) {
                return new PlatformModule(storeDir, config, this.databaseInfo, dependencies, graphDatabaseFacade){

                    protected Neo4jJobScheduler createJobScheduler() {
                        return NonUniqueIndexTest.newSlowJobScheduler();
                    }

                    protected LogService createLogService(LogProvider userLogProvider) {
                        return NullLogService.getInstance();
                    }
                };
            }
        }.newFacade(this.directory.graphDbDir(), Config.embeddedDefaults((ConfigurationValidator[])new ConfigurationValidator[0]), graphDatabaseFactoryState.databaseDependencies());
    }

    private static Neo4jJobScheduler newSlowJobScheduler() {
        return new Neo4jJobScheduler(){

            public JobScheduler.JobHandle schedule(JobScheduler.Group group, Runnable job) {
                return super.schedule(group, NonUniqueIndexTest.slowRunnable(job));
            }

            public JobScheduler.JobHandle schedule(JobScheduler.Group group, Runnable job, Map<String, String> metadata) {
                return super.schedule(group, NonUniqueIndexTest.slowRunnable(job), metadata);
            }
        };
    }

    private static Runnable slowRunnable(Runnable target) {
        return () -> {
            LockSupport.parkNanos(100000000L);
            target.run();
        };
    }

    /*
     * Exception decompiling
     */
    private List<Long> nodeIdsInIndex(int indexId, String value) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

