/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene.legacy;

import java.util.Iterator;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.graphdb.index.ReadableRelationshipIndex;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.EmbeddedDatabaseRule;

public class AutoIndexOperationsTest {
    @Rule
    public final DatabaseRule db = new EmbeddedDatabaseRule().withSetting(GraphDatabaseSettings.relationship_keys_indexable, "Type").withSetting(GraphDatabaseSettings.relationship_auto_indexing, "true");

    @Test
    public void shouldNotSeeDeletedRelationshipWhenQueryingWithStartAndEndNode() {
        Relationship rel;
        long endId;
        long startId;
        MyRelTypes type = MyRelTypes.TEST;
        try (Transaction tx = this.db.beginTx();){
            Node start = this.db.createNode();
            Node end = this.db.createNode();
            startId = start.getId();
            endId = end.getId();
            rel = start.createRelationshipTo(end, (RelationshipType)type);
            rel.setProperty("Type", (Object)type.name());
            tx.success();
        }
        tx = this.db.beginTx();
        var8_3 = null;
        try {
            ReadableRelationshipIndex autoRelationshipIndex = this.db.index().getRelationshipAutoIndexer().getAutoIndex();
            Node start = this.db.getNodeById(startId);
            Node end = this.db.getNodeById(endId);
            IndexHits hits = autoRelationshipIndex.get("Type", (Object)type.name(), start, end);
            Assert.assertEquals((long)1L, (long)Iterators.count((Iterator)hits));
            Assert.assertEquals((long)1L, (long)hits.size());
            rel.delete();
            autoRelationshipIndex = this.db.index().getRelationshipAutoIndexer().getAutoIndex();
            hits = autoRelationshipIndex.get("Type", (Object)type.name(), start, end);
            Assert.assertEquals((long)0L, (long)Iterators.count((Iterator)hits));
            Assert.assertEquals((long)0L, (long)hits.size());
            tx.success();
        }
        catch (Throwable throwable) {
            var8_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var8_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var8_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }
}

