/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene.legacy;

import java.util.Map;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.RelationshipIndex;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.TestDirectory;

public abstract class AbstractLuceneIndexTest {
    @Rule
    public final TestName testname = new TestName();
    @ClassRule
    public static TestDirectory testDirectory = TestDirectory.testDirectory(AbstractLuceneIndexTest.class);
    protected static GraphDatabaseService graphDb;
    protected Transaction tx;
    private static final RelationshipType TEST_TYPE;
    protected static final EntityCreator<Node> NODE_CREATOR;
    protected static final EntityCreator<Relationship> RELATIONSHIP_CREATOR;

    @BeforeClass
    public static void setUpStuff() {
        graphDb = new TestGraphDatabaseFactory().newEmbeddedDatabase(testDirectory.graphDbDir());
    }

    @AfterClass
    public static void tearDownStuff() {
        graphDb.shutdown();
    }

    @After
    public void commitTx() {
        this.finishTx(true);
    }

    public void rollbackTx() {
        this.finishTx(false);
    }

    public void finishTx(boolean success) {
        if (this.tx != null) {
            if (success) {
                this.tx.success();
            }
            this.tx.close();
            this.tx = null;
        }
    }

    @Before
    public void beginTx() {
        if (this.tx == null) {
            this.tx = graphDb.beginTx();
        }
    }

    void restartTx() {
        this.commitTx();
        this.beginTx();
    }

    private static void setProperties(PropertyContainer entity, Object ... properties) {
        for (Map.Entry entry : MapUtil.map((Object[])properties).entrySet()) {
            entity.setProperty((String)entry.getKey(), entry.getValue());
        }
    }

    protected Index<Node> nodeIndex() {
        return this.nodeIndex(this.currentIndexName(), MapUtil.stringMap((String[])new String[0]));
    }

    protected Index<Node> nodeIndex(Map<String, String> config) {
        return this.nodeIndex(this.currentIndexName(), config);
    }

    protected Index<Node> nodeIndex(String name, Map<String, String> config) {
        return graphDb.index().forNodes(name, config);
    }

    protected RelationshipIndex relationshipIndex(Map<String, String> config) {
        return this.relationshipIndex(this.currentIndexName(), config);
    }

    protected RelationshipIndex relationshipIndex(String name, Map<String, String> config) {
        return graphDb.index().forRelationships(name, config);
    }

    protected String currentIndexName() {
        return this.testname.getMethodName();
    }

    static {
        TEST_TYPE = RelationshipType.withName((String)"TEST_TYPE");
        NODE_CREATOR = new EntityCreator<Node>(){

            @Override
            public Node create(Object ... properties) {
                Node node = graphDb.createNode();
                AbstractLuceneIndexTest.setProperties((PropertyContainer)node, properties);
                return node;
            }

            @Override
            public void delete(Node entity) {
                entity.delete();
            }
        };
        RELATIONSHIP_CREATOR = new EntityCreator<Relationship>(){

            @Override
            public Relationship create(Object ... properties) {
                Relationship rel = graphDb.createNode().createRelationshipTo(graphDb.createNode(), TEST_TYPE);
                AbstractLuceneIndexTest.setProperties((PropertyContainer)rel, properties);
                return rel;
            }

            @Override
            public void delete(Relationship entity) {
                entity.delete();
            }
        };
    }

    protected static interface EntityCreator<T extends PropertyContainer> {
        public T create(Object ... var1);

        public void delete(T var1);
    }
}

