/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.RelationshipIndex;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.ImpermanentDatabaseRule;

public class LegacyIndexTest {
    private static final RelationshipType TYPE = DynamicRelationshipType.withName((String)"TYPE");
    @Rule
    public final DatabaseRule db = new ImpermanentDatabaseRule();

    @Test
    public void removalOfNodeIndexDoesNotInfluenceRelationshipIndexWithSameName() {
        String indexName = "index";
        LegacyIndexTest.createNodeLegacyIndexWithSingleNode((GraphDatabaseService)this.db, indexName);
        LegacyIndexTest.createRelationshipLegacyIndexWithSingleRelationship((GraphDatabaseService)this.db, indexName);
        try (Transaction tx = this.db.beginTx();){
            Relationship relationship = this.db.createNode().createRelationshipTo(this.db.createNode(), TYPE);
            RelationshipIndex relationshipIndex = this.db.index().forRelationships(indexName);
            relationshipIndex.add((PropertyContainer)relationship, "key", (Object)"otherValue");
            Index nodeIndex = this.db.index().forNodes(indexName);
            nodeIndex.delete();
            tx.success();
        }
        tx = this.db.beginTx();
        var3_3 = null;
        try {
            Assert.assertFalse((boolean)this.db.index().existsForNodes(indexName));
            RelationshipIndex relationshipIndex = this.db.index().forRelationships(indexName);
            Assert.assertEquals((long)2L, (long)LegacyIndexTest.sizeOf(relationshipIndex));
            tx.success();
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void removalOfRelationshipIndexDoesNotInfluenceNodeIndexWithSameName() {
        String indexName = "index";
        LegacyIndexTest.createNodeLegacyIndexWithSingleNode((GraphDatabaseService)this.db, indexName);
        LegacyIndexTest.createRelationshipLegacyIndexWithSingleRelationship((GraphDatabaseService)this.db, indexName);
        try (Transaction tx = this.db.beginTx();){
            Node node = this.db.createNode();
            Index nodeIndex = this.db.index().forNodes(indexName);
            nodeIndex.add((PropertyContainer)node, "key", (Object)"otherValue");
            RelationshipIndex relationshipIndex = this.db.index().forRelationships(indexName);
            relationshipIndex.delete();
            tx.success();
        }
        tx = this.db.beginTx();
        var3_3 = null;
        try {
            Assert.assertFalse((boolean)this.db.index().existsForRelationships(indexName));
            Index nodeIndex = this.db.index().forNodes(indexName);
            Assert.assertEquals((long)2L, (long)LegacyIndexTest.sizeOf(nodeIndex));
            tx.success();
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    private static void createNodeLegacyIndexWithSingleNode(GraphDatabaseService db, String indexName) {
        try (Transaction tx = db.beginTx();){
            Node node = db.createNode();
            Index nodeIndex = db.index().forNodes(indexName);
            nodeIndex.add((PropertyContainer)node, "key", (Object)System.currentTimeMillis());
            tx.success();
        }
    }

    private static void createRelationshipLegacyIndexWithSingleRelationship(GraphDatabaseService db, String indexName) {
        try (Transaction tx = db.beginTx();){
            Relationship relationship = db.createNode().createRelationshipTo(db.createNode(), TYPE);
            RelationshipIndex relationshipIndexIndex = db.index().forRelationships(indexName);
            relationshipIndexIndex.add((PropertyContainer)relationship, "key", (Object)System.currentTimeMillis());
            tx.success();
        }
    }

    private static int sizeOf(Index<?> index) {
        return index.query((Object)"_id_:*").size();
    }
}

