/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index;

import java.io.IOException;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Executors;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.test.TestGraphDatabaseFactory;

public class IndexConstraintsTest {
    private static final Label LABEL = Label.label((String)"Label");
    private static final String PROPERTY_KEY = "x";
    private GraphDatabaseService graphDb;

    @Before
    public void setup() throws IOException {
        this.graphDb = new TestGraphDatabaseFactory().newImpermanentDatabase();
    }

    @After
    public void shutdown() throws IOException {
        this.graphDb.shutdown();
    }

    @Test
    public void testMultipleCreate() throws InterruptedException {
        Node commonNode;
        int numThreads = 25;
        String uuid = UUID.randomUUID().toString();
        try (Transaction tx = this.graphDb.beginTx();){
            commonNode = this.graphDb.createNode();
            tx.success();
        }
        ExecutorCompletionService<Node> ecs = new ExecutorCompletionService<Node>(Executors.newFixedThreadPool(25));
        for (int i = 0; i < 25; ++i) {
            ecs.submit(() -> {
                try (Transaction tx = this.graphDb.beginTx();){
                    Node node = this.graphDb.createNode();
                    tx.acquireWriteLock((PropertyContainer)commonNode);
                    Index index = this.graphDb.index().forNodes("uuids");
                    Node existing = (Node)index.get("uuid", (Object)uuid).getSingle();
                    if (existing != null) {
                        throw new RuntimeException("Node already exists");
                    }
                    node.setProperty("uuid", (Object)uuid);
                    index.add((PropertyContainer)node, "uuid", (Object)uuid);
                    tx.success();
                    Node node2 = node;
                    return node2;
                }
            });
        }
        int numSucceeded = 0;
        for (int i = 0; i < 25; ++i) {
            try {
                ecs.take().get();
                ++numSucceeded;
                continue;
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
        Assert.assertEquals((long)1L, (long)numSucceeded);
    }

    @Test
    public void convertIndexToConstraint() {
        try (Transaction tx = this.graphDb.beginTx();){
            this.graphDb.schema().indexFor(LABEL).on(PROPERTY_KEY).create();
            tx.success();
        }
        tx = this.graphDb.beginTx();
        var2_2 = null;
        try {
            IndexDefinition index = (IndexDefinition)Iterables.firstOrNull((Iterable)this.graphDb.schema().getIndexes(LABEL));
            index.drop();
            this.graphDb.schema().constraintFor(LABEL).assertPropertyIsUnique(PROPERTY_KEY).create();
            tx.success();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var2_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void convertIndexToConstraintWithExistingData() {
        try (Transaction tx = this.graphDb.beginTx();){
            for (int i = 0; i < 2000; ++i) {
                Node node = this.graphDb.createNode(new Label[]{LABEL});
                node.setProperty(PROPERTY_KEY, (Object)i);
            }
            tx.success();
        }
        tx = this.graphDb.beginTx();
        var2_2 = null;
        try {
            this.graphDb.schema().indexFor(LABEL).on(PROPERTY_KEY).create();
            tx.success();
        }
        catch (Throwable i) {
            var2_2 = i;
            throw i;
        }
        finally {
            if (tx != null) {
                if (var2_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable i) {
                        var2_2.addSuppressed(i);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = this.graphDb.beginTx();
        var2_2 = null;
        try {
            IndexDefinition index = (IndexDefinition)Iterables.firstOrNull((Iterable)this.graphDb.schema().getIndexes(LABEL));
            index.drop();
            this.graphDb.schema().constraintFor(LABEL).assertPropertyIsUnique(PROPERTY_KEY).create();
            tx.success();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var2_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void convertConstraintToIndex() {
        try (Transaction tx = this.graphDb.beginTx();){
            this.graphDb.schema().constraintFor(LABEL).assertPropertyIsUnique(PROPERTY_KEY).create();
            tx.success();
        }
        tx = this.graphDb.beginTx();
        var2_2 = null;
        try {
            ConstraintDefinition constraint = (ConstraintDefinition)Iterables.firstOrNull((Iterable)this.graphDb.schema().getConstraints(LABEL));
            constraint.drop();
            this.graphDb.schema().indexFor(LABEL).on(PROPERTY_KEY).create();
            tx.success();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var2_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void creatingAndDroppingAndCreatingIndexInSameTransaction() {
        for (int times = 1; times <= 4; ++times) {
            try {
                try (Transaction tx = this.graphDb.beginTx();){
                    this.recreate(this.graphDb.schema().indexFor(LABEL).on(PROPERTY_KEY).create(), times);
                    tx.success();
                }
                Assert.assertNotNull((String)"Index should exist", (Object)this.getIndex(LABEL, PROPERTY_KEY));
                tx = this.graphDb.beginTx();
                var3_4 = null;
                try {
                    this.recreate(this.getIndex(LABEL, PROPERTY_KEY), times);
                    tx.success();
                }
                catch (Throwable throwable) {
                    var3_4 = throwable;
                    throw throwable;
                }
                finally {
                    if (tx != null) {
                        if (var3_4 != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable) {
                                var3_4.addSuppressed(throwable);
                            }
                        } else {
                            tx.close();
                        }
                    }
                }
                Assert.assertNotNull((String)"Index should exist", (Object)this.getIndex(LABEL, PROPERTY_KEY));
                tx = this.graphDb.beginTx();
                var3_4 = null;
                try {
                    this.recreate(this.getIndex(LABEL, PROPERTY_KEY), times).drop();
                    tx.success();
                }
                catch (Throwable throwable) {
                    var3_4 = throwable;
                    throw throwable;
                }
                finally {
                    if (tx != null) {
                        if (var3_4 != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable) {
                                var3_4.addSuppressed(throwable);
                            }
                        } else {
                            tx.close();
                        }
                    }
                }
                Assert.assertNull((String)"Index should be removed", (Object)this.getIndex(LABEL, PROPERTY_KEY));
                continue;
            }
            catch (Throwable e) {
                throw new AssertionError("times=" + times, e);
            }
        }
    }

    private IndexDefinition recreate(IndexDefinition index, int times) {
        for (int i = 0; i < times; ++i) {
            index.drop();
            index = this.graphDb.schema().indexFor(index.getLabel()).on((String)Iterables.single((Iterable)index.getPropertyKeys())).create();
        }
        return index;
    }

    private IndexDefinition getIndex(Label label, String propertyKey) {
        try (Transaction tx = this.graphDb.beginTx();){
            IndexDefinition found = null;
            for (IndexDefinition index : this.graphDb.schema().getIndexes(label)) {
                if (!propertyKey.equals(Iterables.single((Iterable)index.getPropertyKeys()))) continue;
                Assert.assertNull((String)"Found multiple indexes.", found);
                found = index;
            }
            tx.success();
            Iterator iterator = found;
            return iterator;
        }
    }

    @Test
    public void shouldRemoveIndexForConstraintEvenIfDroppedInCreatingTransaction() {
        try (Transaction tx = this.graphDb.beginTx();){
            this.graphDb.schema().constraintFor(LABEL).assertPropertyIsUnique(PROPERTY_KEY).create().drop();
            tx.failure();
        }
        Assert.assertNull((String)"Should not have constraint index", (Object)this.getIndex(LABEL, PROPERTY_KEY));
    }

    @Test
    public void creatingAndDroppingAndCreatingConstraintInSameTransaction() {
        for (int times = 1; times <= 4; ++times) {
            try {
                try (Transaction tx = this.graphDb.beginTx();){
                    this.recreate(this.graphDb.schema().constraintFor(LABEL).assertPropertyIsUnique(PROPERTY_KEY).create(), times);
                    tx.success();
                }
                Assert.assertNotNull((String)"Constraint should exist", (Object)this.getConstraint(LABEL, PROPERTY_KEY));
                Assert.assertNotNull((String)"Should have constraint index", (Object)this.getIndex(LABEL, PROPERTY_KEY));
                tx = this.graphDb.beginTx();
                var3_4 = null;
                try {
                    this.recreate(this.getConstraint(LABEL, PROPERTY_KEY), times);
                    tx.success();
                }
                catch (Throwable throwable) {
                    var3_4 = throwable;
                    throw throwable;
                }
                finally {
                    if (tx != null) {
                        if (var3_4 != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable) {
                                var3_4.addSuppressed(throwable);
                            }
                        } else {
                            tx.close();
                        }
                    }
                }
                Assert.assertNotNull((String)"Constraint should exist", (Object)this.getConstraint(LABEL, PROPERTY_KEY));
                Assert.assertNotNull((String)"Should have constraint index", (Object)this.getIndex(LABEL, PROPERTY_KEY));
                tx = this.graphDb.beginTx();
                var3_4 = null;
                try {
                    this.recreate(this.getConstraint(LABEL, PROPERTY_KEY), times).drop();
                    tx.success();
                }
                catch (Throwable throwable) {
                    var3_4 = throwable;
                    throw throwable;
                }
                finally {
                    if (tx != null) {
                        if (var3_4 != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable) {
                                var3_4.addSuppressed(throwable);
                            }
                        } else {
                            tx.close();
                        }
                    }
                }
                Assert.assertNull((String)"Constraint should be removed", (Object)this.getConstraint(LABEL, PROPERTY_KEY));
                Assert.assertNull((String)"Should not have constraint index", (Object)this.getIndex(LABEL, PROPERTY_KEY));
                continue;
            }
            catch (Throwable e) {
                throw new AssertionError("times=" + times, e);
            }
        }
    }

    private ConstraintDefinition recreate(ConstraintDefinition constraint, int times) {
        for (int i = 0; i < times; ++i) {
            constraint.drop();
            constraint = this.graphDb.schema().constraintFor(constraint.getLabel()).assertPropertyIsUnique((String)Iterables.single((Iterable)constraint.getPropertyKeys())).create();
        }
        return constraint;
    }

    private ConstraintDefinition getConstraint(Label label, String propertyKey) {
        try (Transaction tx = this.graphDb.beginTx();){
            ConstraintDefinition found = null;
            for (ConstraintDefinition constraint : this.graphDb.schema().getConstraints(label)) {
                if (!propertyKey.equals(Iterables.single((Iterable)constraint.getPropertyKeys()))) continue;
                Assert.assertNull((String)"Found multiple constraints.", found);
                found = constraint;
            }
            tx.success();
            Iterator iterator = found;
            return iterator;
        }
    }
}

