/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.concurrencytest;

import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.exceptions.schema.UniquePropertyValueValidationException;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.api.schema.IndexQuery;
import org.neo4j.kernel.api.schema.constaints.ConstraintDescriptorFactory;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptorFactory;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.ImpermanentDatabaseRule;
import org.neo4j.test.rule.concurrent.ThreadingRule;

public class ConstraintIndexConcurrencyTest {
    @Rule
    public final DatabaseRule db = new ImpermanentDatabaseRule();
    @Rule
    public final ThreadingRule threads = new ThreadingRule();

    @Test
    public void shouldNotAllowConcurrentViolationOfConstraint() throws Exception {
        GraphDatabaseAPI graphDb = this.db.getGraphDatabaseAPI();
        Supplier statementSupplier = (Supplier)graphDb.getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class);
        Label label = Label.label((String)"Foo");
        String propertyKey = "bar";
        String conflictingValue = "baz";
        try (Transaction tx = graphDb.beginTx();){
            graphDb.schema().constraintFor(label).assertPropertyIsUnique(propertyKey).create();
            tx.success();
        }
        tx = graphDb.beginTx();
        var7_7 = null;
        try {
            Statement statement = (Statement)statementSupplier.get();
            int labelId = statement.readOperations().labelGetForName(label.name());
            int propertyKeyId = statement.readOperations().propertyKeyGetForName(propertyKey);
            IndexDescriptor index = IndexDescriptorFactory.uniqueForLabel((int)labelId, (int[])new int[]{propertyKeyId});
            statement.readOperations().indexQuery(index, new IndexQuery[]{IndexQuery.exact((int)index.schema().getPropertyId(), (Object)"The value is irrelevant, we just want to perform some sort of lookup against this index")});
            this.threads.execute(db -> {
                try (Transaction transaction = db.beginTx();){
                    db.createNode(new Label[]{label}).setProperty(propertyKey, (Object)conflictingValue);
                    transaction.success();
                }
                return null;
            }, (Object)graphDb).get();
            long node = statement.dataWriteOperations().nodeCreate();
            statement.dataWriteOperations().nodeAddLabel(node, labelId);
            try {
                statement.dataWriteOperations().nodeSetProperty(node, Property.property((int)propertyKeyId, (Object)conflictingValue));
                Assert.fail((String)"exception expected");
            }
            catch (UniquePropertyValueValidationException e) {
                Assert.assertEquals((Object)ConstraintDescriptorFactory.uniqueForLabel((int)labelId, (int[])new int[]{propertyKeyId}), (Object)e.constraint());
                IndexEntryConflictException conflict = (IndexEntryConflictException)((Object)Iterators.single(e.conflicts().iterator()));
                Assert.assertEquals((Object)conflictingValue, (Object)conflict.getSinglePropertyValue());
            }
            tx.success();
        }
        catch (Throwable throwable) {
            var7_7 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var7_7 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var7_7.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }
}

