/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.lang3.RandomUtils;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.index.ConcurrentMergeScheduler;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeTrigger;
import org.apache.lucene.index.PooledConcurrentMergeScheduler;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Version;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.test.ThreadTestUtils;

public class PooledConcurrentMergeSchedulerTest {
    private TestPooledConcurrentMergeScheduler mergeScheduler;
    private IndexWriter indexWriter = (IndexWriter)Mockito.mock(IndexWriter.class);

    @Before
    public void setUp() throws Exception {
        this.mergeScheduler = new TestPooledConcurrentMergeScheduler();
    }

    @After
    public void tearDown() throws Exception {
        this.mergeScheduler.getExecutionLatch().countDown();
    }

    @Test
    public void doNotAddMergeTaskWhenWriterDoesNotHaveMergesToDo() throws Exception {
        IndexWriter indexWriter = (IndexWriter)Mockito.mock(IndexWriter.class);
        this.mergeScheduler.merge(indexWriter, MergeTrigger.EXPLICIT, false);
        Assert.assertEquals((long)0L, (long)this.mergeScheduler.getWriterTaskCount());
    }

    @Test
    public void addMergeTaskWhenWriterHasOneMergeToPerform() throws IOException {
        SegmentCommitInfo segmentCommitInfo = this.getSegmentCommitInfo();
        Mockito.when((Object)this.indexWriter.getNextMerge()).thenReturn((Object)new TestOneMerge(segmentCommitInfo)).thenReturn(null);
        this.mergeScheduler.merge(this.indexWriter, MergeTrigger.EXPLICIT, false);
        Assert.assertEquals((long)1L, (long)this.mergeScheduler.getWriterTaskCount());
    }

    @Test
    public void addTwoMergeTasksWhenWriterHastwoMergeToPerform() throws IOException {
        SegmentCommitInfo segmentCommitInfo = this.getSegmentCommitInfo();
        Mockito.when((Object)this.indexWriter.getNextMerge()).thenReturn((Object)new TestOneMerge(segmentCommitInfo)).thenReturn((Object)new TestOneMerge(segmentCommitInfo)).thenReturn(null);
        this.mergeScheduler.merge(this.indexWriter, MergeTrigger.EXPLICIT, false);
        Assert.assertEquals((long)2L, (long)this.mergeScheduler.getWriterTaskCount());
    }

    @Test(timeout=5000L)
    public void writerCloseWaitForMergesInMergeQueue() throws IOException, InterruptedException {
        this.indexWriter = (IndexWriter)Mockito.mock(IndexWriter.class);
        SegmentCommitInfo segmentCommitInfo = this.getSegmentCommitInfo();
        Mockito.when((Object)this.indexWriter.getNextMerge()).thenReturn((Object)new TestOneMerge(segmentCommitInfo)).thenReturn(null);
        this.mergeScheduler.merge(this.indexWriter, MergeTrigger.EXPLICIT, false);
        Assert.assertEquals((long)1L, (long)this.mergeScheduler.getWriterTaskCount());
        Thread closeSchedulerThread = ThreadTestUtils.fork(() -> this.mergeScheduler.close());
        ThreadTestUtils.awaitThreadState((Thread)closeSchedulerThread, (long)500L, (Thread.State)Thread.State.TIMED_WAITING, (Thread.State[])new Thread.State[0]);
        this.mergeScheduler.getExecutionLatch().countDown();
        closeSchedulerThread.join();
        Assert.assertEquals((long)0L, (long)this.mergeScheduler.getWriterTaskCount());
    }

    private SegmentCommitInfo getSegmentCommitInfo() {
        SegmentInfo segmentInfo = new SegmentInfo((Directory)Mockito.mock(Directory.class), Version.LATEST, "test", Integer.MAX_VALUE, true, (Codec)Mockito.mock(Codec.class), MapUtil.stringMap((String[])new String[0]), RandomUtils.nextBytes((int)16), MapUtil.stringMap((String[])new String[0]));
        return new SegmentCommitInfo(segmentInfo, 1, 1L, 1L, 1L);
    }

    private class TestOneMerge
    extends MergePolicy.OneMerge {
        TestOneMerge(SegmentCommitInfo segmentCommitInfo) {
            super(Collections.singletonList(segmentCommitInfo));
        }
    }

    private class TestPooledConcurrentMergeScheduler
    extends PooledConcurrentMergeScheduler {
        private CountDownLatch executionLatch = new CountDownLatch(1);

        private TestPooledConcurrentMergeScheduler() {
        }

        protected synchronized ConcurrentMergeScheduler.MergeThread getMergeThread(IndexWriter writer, MergePolicy.OneMerge merge) throws IOException {
            return new BlockingMerge(writer, merge, this.executionLatch);
        }

        CountDownLatch getExecutionLatch() {
            return this.executionLatch;
        }

        class BlockingMerge
        extends ConcurrentMergeScheduler.MergeThread {
            private CountDownLatch executionLatch;

            BlockingMerge(IndexWriter writer, MergePolicy.OneMerge merge, CountDownLatch executionLatch) {
                super((ConcurrentMergeScheduler)TestPooledConcurrentMergeScheduler.this, writer, merge);
                this.executionLatch = executionLatch;
            }

            public void run() {
                try {
                    this.executionLatch.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Interrupted while waiting for a latch", e);
                }
            }
        }
    }
}

