/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.populator;

import java.io.IOException;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.impl.schema.LuceneDocumentStructure;
import org.neo4j.kernel.api.impl.schema.SchemaIndex;
import org.neo4j.kernel.api.impl.schema.populator.DirectNonUniqueIndexSampler;
import org.neo4j.kernel.api.impl.schema.populator.LuceneIndexPopulator;
import org.neo4j.kernel.api.impl.schema.populator.NonUniqueLuceneIndexPopulatingUpdater;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.impl.api.index.sampling.DefaultNonUniqueIndexSampler;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.sampling.NonUniqueIndexSampler;
import org.neo4j.storageengine.api.schema.IndexSample;

public class NonUniqueLuceneIndexPopulator
extends LuceneIndexPopulator {
    private final IndexSamplingConfig samplingConfig;
    private NonUniqueIndexSampler sampler;
    private boolean updateSampling;

    public NonUniqueLuceneIndexPopulator(SchemaIndex luceneIndex, IndexSamplingConfig samplingConfig) {
        super(luceneIndex);
        this.samplingConfig = samplingConfig;
    }

    public void configureSampling(boolean onlineSampling) {
        this.updateSampling = onlineSampling;
        this.sampler = onlineSampling ? this.createDefaultSampler() : new DirectNonUniqueIndexSampler(this.luceneIndex);
    }

    public void verifyDeferredConstraints(PropertyAccessor accessor) throws IndexEntryConflictException, IOException {
    }

    public IndexUpdater newPopulatingUpdater(PropertyAccessor propertyAccessor) throws IOException {
        this.checkSampler();
        return new NonUniqueLuceneIndexPopulatingUpdater(this.writer, this.sampler);
    }

    public void includeSample(IndexEntryUpdate update) {
        if (this.updateSampling) {
            this.checkSampler();
            this.sampler.include(LuceneDocumentStructure.encodedStringValuesForSampling(update.values()));
        }
    }

    public IndexSample sampleResult() {
        this.checkSampler();
        return this.sampler.result();
    }

    private DefaultNonUniqueIndexSampler createDefaultSampler() {
        return new DefaultNonUniqueIndexSampler(this.samplingConfig.sampleSizeLimit());
    }

    private void checkSampler() {
        if (this.sampler == null) {
            throw new IllegalStateException("Please configure populator sampler before using it.");
        }
    }
}

