/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import org.apache.lucene.index.IndexWriterConfig;
import org.neo4j.function.Factory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.api.impl.index.IndexWriterConfigs;
import org.neo4j.kernel.api.impl.index.builder.AbstractLuceneIndexBuilder;
import org.neo4j.kernel.api.impl.index.partition.ReadOnlyIndexPartitionFactory;
import org.neo4j.kernel.api.impl.index.partition.WritableIndexPartitionFactory;
import org.neo4j.kernel.api.impl.index.storage.PartitionedIndexStorage;
import org.neo4j.kernel.api.impl.schema.ReadOnlyDatabaseSchemaIndex;
import org.neo4j.kernel.api.impl.schema.SchemaIndex;
import org.neo4j.kernel.api.impl.schema.WritableDatabaseSchemaIndex;
import org.neo4j.kernel.api.schema_new.index.NewIndexDescriptor;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;

public class LuceneSchemaIndexBuilder
extends AbstractLuceneIndexBuilder<LuceneSchemaIndexBuilder> {
    private final NewIndexDescriptor descriptor;
    private IndexSamplingConfig samplingConfig = new IndexSamplingConfig(Config.empty());
    private Factory<IndexWriterConfig> writerConfigFactory = IndexWriterConfigs::standard;

    private LuceneSchemaIndexBuilder(NewIndexDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public static LuceneSchemaIndexBuilder create(NewIndexDescriptor descriptor) {
        return new LuceneSchemaIndexBuilder(descriptor);
    }

    public LuceneSchemaIndexBuilder withSamplingConfig(IndexSamplingConfig samplingConfig) {
        this.samplingConfig = samplingConfig;
        return this;
    }

    public LuceneSchemaIndexBuilder withWriterConfig(Factory<IndexWriterConfig> writerConfigFactory) {
        this.writerConfigFactory = writerConfigFactory;
        return this;
    }

    public SchemaIndex build() {
        if (this.isReadOnly()) {
            return new ReadOnlyDatabaseSchemaIndex(this.storageBuilder.build(), this.descriptor, this.samplingConfig, new ReadOnlyIndexPartitionFactory());
        }
        Boolean archiveFailed = (Boolean)this.getConfig(GraphDatabaseSettings.archive_failed_index);
        PartitionedIndexStorage storage = this.storageBuilder.archivingFailed(archiveFailed).build();
        return new WritableDatabaseSchemaIndex(storage, this.descriptor, this.samplingConfig, new WritableIndexPartitionFactory(this.writerConfigFactory));
    }
}

