/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene.legacy;

import java.io.Closeable;
import java.util.Collection;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.neo4j.index.impl.lucene.legacy.EntityId;
import org.neo4j.index.impl.lucene.legacy.LuceneLegacyIndex;
import org.neo4j.index.impl.lucene.legacy.TxData;
import org.neo4j.index.lucene.QueryContext;

class TxDataHolder
implements Closeable {
    final LuceneLegacyIndex index;
    private TxData data;

    TxDataHolder(LuceneLegacyIndex index, TxData initialData) {
        this.index = index;
        this.data = initialData;
    }

    void add(EntityId entityId, String key, Object value) {
        this.data.add(this, entityId, key, value);
    }

    void remove(EntityId entityId, String key, Object value) {
        this.data.remove(this, entityId, key, value);
    }

    Collection<EntityId> query(Query query, QueryContext contextOrNull) {
        return this.data.query(this, query, contextOrNull);
    }

    Collection<EntityId> get(String key, Object value) {
        return this.data.get(this, key, value);
    }

    Collection<EntityId> getOrphans(String key) {
        return this.data.getOrphans(key);
    }

    @Override
    public void close() {
        this.data.close();
    }

    IndexSearcher asSearcher(QueryContext context) {
        return this.data.asSearcher(this, context);
    }

    void set(TxData newData) {
        this.data = newData;
    }
}

