/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene.legacy;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.index.impl.lucene.legacy.EntityId;
import org.neo4j.index.impl.lucene.legacy.IndexIdentifier;
import org.neo4j.index.impl.lucene.legacy.LuceneBatchInserterIndex;
import org.neo4j.kernel.impl.index.IndexConfigStore;
import org.neo4j.kernel.impl.index.IndexEntityType;
import org.neo4j.unsafe.batchinsert.BatchInserter;
import org.neo4j.unsafe.batchinsert.BatchInserterIndex;
import org.neo4j.unsafe.batchinsert.BatchInserterIndexProvider;
import org.neo4j.unsafe.batchinsert.BatchRelationship;
import org.neo4j.unsafe.batchinsert.internal.IndexConfigStoreProvider;

public class LuceneBatchInserterIndexProviderNewImpl
implements BatchInserterIndexProvider {
    private final BatchInserter inserter;
    private final Map<IndexIdentifier, LuceneBatchInserterIndex> indexes = new HashMap<IndexIdentifier, LuceneBatchInserterIndex>();
    final IndexConfigStore indexStore;
    private LuceneBatchInserterIndex.RelationshipLookup relationshipLookup;

    public LuceneBatchInserterIndexProviderNewImpl(BatchInserter inserter) {
        this.inserter = inserter;
        this.indexStore = ((IndexConfigStoreProvider)inserter).getIndexStore();
        this.relationshipLookup = id -> {
            BatchRelationship rel = inserter.getRelationshipById(id);
            return new EntityId.RelationshipData(id, rel.getStartNode(), rel.getEndNode());
        };
    }

    public BatchInserterIndex nodeIndex(String indexName, Map<String, String> config) {
        this.config(Node.class, indexName, config);
        return this.index(new IndexIdentifier(IndexEntityType.Node, indexName), config);
    }

    private Map<String, String> config(Class<? extends PropertyContainer> cls, String indexName, Map<String, String> config) {
        if (config != null) {
            config = MapUtil.stringMap(new HashMap<String, String>(config), (String[])new String[]{"provider", "lucene"});
            this.indexStore.setIfNecessary(cls, indexName, config);
            return config;
        }
        return this.indexStore.get(cls, indexName);
    }

    public BatchInserterIndex relationshipIndex(String indexName, Map<String, String> config) {
        this.config(Relationship.class, indexName, config);
        return this.index(new IndexIdentifier(IndexEntityType.Relationship, indexName), config);
    }

    private BatchInserterIndex index(IndexIdentifier identifier, Map<String, String> config) {
        return this.indexes.computeIfAbsent(identifier, k -> this.getLuceneBatchInserterIndex(identifier, config));
    }

    private LuceneBatchInserterIndex getLuceneBatchInserterIndex(IndexIdentifier identifier, Map<String, String> config) {
        return new LuceneBatchInserterIndex(new File(this.inserter.getStoreDir()), identifier, config, this.relationshipLookup);
    }

    public void shutdown() {
        for (LuceneBatchInserterIndex index : this.indexes.values()) {
            index.shutdown();
        }
    }
}

