/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.batchinsert;

import java.io.File;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.impl.schema.LuceneSchemaIndexProvider;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.extension.dependency.HighestSelectionStrategy;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;
import org.neo4j.unsafe.batchinsert.BatchInserter;
import org.neo4j.unsafe.batchinsert.BatchInserters;

public class TestLuceneSchemaBatchInsertIT {
    @Rule
    public final TestDirectory testDirectory = TestDirectory.testDirectory();
    @Rule
    public final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    private static final Label LABEL = Label.label((String)"Person");

    @Test
    public void shouldLoadAndUseLuceneProvider() throws Exception {
        File storeDir = this.testDirectory.graphDbDir();
        BatchInserter inserter = BatchInserters.inserter((File)storeDir, (FileSystemAbstraction)this.fileSystemRule.get());
        inserter.createDeferredSchemaIndex(LABEL).on("name").create();
        inserter.createNode(MapUtil.map((Object[])new Object[]{"name", "Mattias"}), new Label[]{LABEL});
        inserter.shutdown();
        TestGraphDatabaseFactory graphDatabaseFactory = new TestGraphDatabaseFactory();
        GraphDatabaseAPI db = (GraphDatabaseAPI)graphDatabaseFactory.newEmbeddedDatabase(storeDir);
        DependencyResolver dependencyResolver = db.getDependencyResolver();
        SchemaIndexProvider schemaIndexProvider = (SchemaIndexProvider)dependencyResolver.resolveDependency(SchemaIndexProvider.class, HighestSelectionStrategy.getInstance());
        try (Transaction ignore = db.beginTx();){
            IndexDefinition indexDefinition = (IndexDefinition)Iterables.single((Iterable)db.schema().getIndexes(LABEL));
            Assert.assertThat((Object)db.schema().getIndexState(indexDefinition), (Matcher)CoreMatchers.is((Object)Schema.IndexState.ONLINE));
            Assert.assertThat((Object)schemaIndexProvider, (Matcher)CoreMatchers.instanceOf(LuceneSchemaIndexProvider.class));
        }
        db.shutdown();
    }
}

