/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.sampler;

import java.util.concurrent.TimeUnit;
import org.apache.lucene.search.IndexSearcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.neo4j.helpers.TaskCoordinator;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.impl.schema.sampler.UniqueLuceneIndexSampler;
import org.neo4j.storageengine.api.schema.IndexSample;

public class UniqueDatabaseIndexSamplerTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private final IndexSearcher indexSearcher = (IndexSearcher)Mockito.mock(IndexSearcher.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    private final TaskCoordinator taskControl = new TaskCoordinator(0L, TimeUnit.MILLISECONDS);

    @Test
    public void uniqueSamplingUseDocumentsNumber() throws IndexNotFoundKernelException {
        Mockito.when((Object)this.indexSearcher.getIndexReader().numDocs()).thenReturn((Object)17);
        UniqueLuceneIndexSampler sampler = new UniqueLuceneIndexSampler(this.indexSearcher, this.taskControl.newInstance());
        IndexSample sample = sampler.sampleIndex();
        Assert.assertEquals((long)17L, (long)sample.indexSize());
    }

    @Test
    public void uniqueSamplingCancel() throws IndexNotFoundKernelException {
        Mockito.when((Object)this.indexSearcher.getIndexReader().numDocs()).thenAnswer(invocation -> {
            this.taskControl.cancel();
            return 17;
        });
        this.expectedException.expect(IndexNotFoundKernelException.class);
        this.expectedException.expectMessage("Index dropped while sampling.");
        UniqueLuceneIndexSampler sampler = new UniqueLuceneIndexSampler(this.indexSearcher, this.taskControl.newInstance());
        sampler.sampleIndex();
    }
}

