/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.populator;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.store.Directory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.mockito.Mockito;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.impl.index.storage.DirectoryFactory;
import org.neo4j.kernel.api.impl.index.storage.PartitionedIndexStorage;
import org.neo4j.kernel.api.impl.schema.AllNodesCollector;
import org.neo4j.kernel.api.impl.schema.LuceneSchemaIndexBuilder;
import org.neo4j.kernel.api.impl.schema.SchemaIndex;
import org.neo4j.kernel.api.impl.schema.populator.UniqueLuceneIndexPopulator;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.api.schema_new.IndexQuery;
import org.neo4j.kernel.api.schema_new.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema_new.LabelSchemaSupplier;
import org.neo4j.kernel.api.schema_new.SchemaDescriptorFactory;
import org.neo4j.kernel.api.schema_new.index.NewIndexDescriptor;
import org.neo4j.kernel.api.schema_new.index.NewIndexDescriptorFactory;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.IndexSample;
import org.neo4j.test.OtherThreadExecutor;
import org.neo4j.test.rule.CleanupRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class UniqueDatabaseIndexPopulatorTest {
    private final CleanupRule cleanup = new CleanupRule();
    private final TestDirectory testDir = TestDirectory.testDirectory();
    private final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    @Rule
    public final RuleChain ruleChain = RuleChain.outerRule((TestRule)this.testDir).around((TestRule)this.cleanup).around((TestRule)this.fileSystemRule);
    private static final int LABEL_ID = 1;
    private static final int PROPERTY_KEY_ID = 2;
    private static final String INDEX_IDENTIFIER = "42";
    private final DirectoryFactory directoryFactory = new DirectoryFactory.InMemoryDirectoryFactory();
    private static final NewIndexDescriptor descriptor = NewIndexDescriptorFactory.forLabel((int)1, (int[])new int[]{2});
    private final PropertyAccessor propertyAccessor = (PropertyAccessor)Mockito.mock(PropertyAccessor.class);
    private PartitionedIndexStorage indexStorage;
    private SchemaIndex index;
    private UniqueLuceneIndexPopulator populator;
    private LabelSchemaDescriptor schemaDescriptor;

    @Before
    public void setUp() throws Exception {
        File folder = this.testDir.directory("folder");
        this.indexStorage = new PartitionedIndexStorage(this.directoryFactory, this.fileSystemRule.get(), folder, INDEX_IDENTIFIER, false);
        this.index = ((LuceneSchemaIndexBuilder)LuceneSchemaIndexBuilder.create((NewIndexDescriptor)descriptor).withIndexStorage(this.indexStorage)).build();
        this.schemaDescriptor = descriptor.schema();
    }

    @After
    public void tearDown() throws Exception {
        if (this.populator != null) {
            this.populator.close(false);
        }
        IOUtils.closeAll((AutoCloseable[])new Closeable[]{this.index, this.directoryFactory});
    }

    @Test
    public void shouldVerifyThatThereAreNoDuplicates() throws Exception {
        this.populator = this.newPopulator();
        UniqueDatabaseIndexPopulatorTest.addUpdate(this.populator, 1L, "value1");
        UniqueDatabaseIndexPopulatorTest.addUpdate(this.populator, 2L, "value2");
        UniqueDatabaseIndexPopulatorTest.addUpdate(this.populator, 3L, "value3");
        this.populator.verifyDeferredConstraints(this.propertyAccessor);
        this.populator.close(true);
        Assert.assertEquals(Arrays.asList(1L), AllNodesCollector.getAllNodes(this.getDirectory(), "value1"));
        Assert.assertEquals(Arrays.asList(2L), AllNodesCollector.getAllNodes(this.getDirectory(), "value2"));
        Assert.assertEquals(Arrays.asList(3L), AllNodesCollector.getAllNodes(this.getDirectory(), "value3"));
    }

    private Directory getDirectory() throws IOException {
        File partitionFolder = this.indexStorage.getPartitionFolder(1);
        return this.indexStorage.openDirectory(partitionFolder);
    }

    @Test
    public void shouldUpdateEntryForNodeThatHasAlreadyBeenIndexed() throws Exception {
        this.populator = this.newPopulator();
        UniqueDatabaseIndexPopulatorTest.addUpdate(this.populator, 1L, "value1");
        IndexUpdater updater = this.populator.newPopulatingUpdater(this.propertyAccessor);
        updater.process(IndexEntryUpdate.change((long)1L, (LabelSchemaSupplier)this.schemaDescriptor, (Object)"value1", (Object)"value2"));
        this.populator.close(true);
        Assert.assertEquals((Object)Collections.EMPTY_LIST, AllNodesCollector.getAllNodes(this.getDirectory(), "value1"));
        Assert.assertEquals(Arrays.asList(1L), AllNodesCollector.getAllNodes(this.getDirectory(), "value2"));
    }

    @Test
    public void shouldUpdateEntryForNodeThatHasPropertyRemovedAndThenAddedAgain() throws Exception {
        this.populator = this.newPopulator();
        UniqueDatabaseIndexPopulatorTest.addUpdate(this.populator, 1L, "value1");
        IndexUpdater updater = this.populator.newPopulatingUpdater(this.propertyAccessor);
        updater.process(IndexEntryUpdate.remove((long)1L, (LabelSchemaSupplier)this.schemaDescriptor, (Object[])new Object[]{"value1"}));
        updater.process(IndexEntryUpdate.add((long)1L, (LabelSchemaSupplier)this.schemaDescriptor, (Object[])new Object[]{"value1"}));
        this.populator.close(true);
        Assert.assertEquals(Arrays.asList(1L), AllNodesCollector.getAllNodes(this.getDirectory(), "value1"));
    }

    @Test
    public void shouldRemoveEntryForNodeThatHasAlreadyBeenIndexed() throws Exception {
        this.populator = this.newPopulator();
        UniqueDatabaseIndexPopulatorTest.addUpdate(this.populator, 1L, "value1");
        IndexUpdater updater = this.populator.newPopulatingUpdater(this.propertyAccessor);
        updater.process(IndexEntryUpdate.remove((long)1L, (LabelSchemaSupplier)this.schemaDescriptor, (Object[])new Object[]{"value1"}));
        this.populator.close(true);
        Assert.assertEquals((Object)Collections.EMPTY_LIST, AllNodesCollector.getAllNodes(this.getDirectory(), "value1"));
    }

    @Test
    public void shouldBeAbleToHandleSwappingOfIndexValues() throws Exception {
        this.populator = this.newPopulator();
        UniqueDatabaseIndexPopulatorTest.addUpdate(this.populator, 1L, "value1");
        UniqueDatabaseIndexPopulatorTest.addUpdate(this.populator, 2L, "value2");
        IndexUpdater updater = this.populator.newPopulatingUpdater(this.propertyAccessor);
        updater.process(IndexEntryUpdate.change((long)1L, (LabelSchemaSupplier)this.schemaDescriptor, (Object)"value1", (Object)"value2"));
        updater.process(IndexEntryUpdate.change((long)2L, (LabelSchemaSupplier)this.schemaDescriptor, (Object)"value2", (Object)"value1"));
        this.populator.close(true);
        Assert.assertEquals(Arrays.asList(2L), AllNodesCollector.getAllNodes(this.getDirectory(), "value1"));
        Assert.assertEquals(Arrays.asList(1L), AllNodesCollector.getAllNodes(this.getDirectory(), "value2"));
    }

    @Test
    public void shouldFailAtVerificationStageWithAlreadyIndexedStringValue() throws Exception {
        this.populator = this.newPopulator();
        String value = "value1";
        UniqueDatabaseIndexPopulatorTest.addUpdate(this.populator, 1L, value);
        UniqueDatabaseIndexPopulatorTest.addUpdate(this.populator, 2L, "value2");
        UniqueDatabaseIndexPopulatorTest.addUpdate(this.populator, 3L, value);
        Mockito.when((Object)this.propertyAccessor.getProperty(1L, 2)).thenReturn((Object)Property.stringProperty((int)2, (String)value));
        Mockito.when((Object)this.propertyAccessor.getProperty(3L, 2)).thenReturn((Object)Property.stringProperty((int)2, (String)value));
        try {
            this.populator.verifyDeferredConstraints(this.propertyAccessor);
            Assert.fail((String)"should have thrown exception");
        }
        catch (IndexEntryConflictException conflict) {
            Assert.assertEquals((long)1L, (long)conflict.getExistingNodeId());
            Assert.assertEquals((Object)value, (Object)conflict.getSinglePropertyValue());
            Assert.assertEquals((long)3L, (long)conflict.getAddedNodeId());
        }
    }

    @Test
    public void shouldFailAtVerificationStageWithAlreadyIndexedNumberValue() throws Exception {
        this.populator = this.newPopulator();
        UniqueDatabaseIndexPopulatorTest.addUpdate(this.populator, 1L, 1);
        UniqueDatabaseIndexPopulatorTest.addUpdate(this.populator, 2L, 2);
        UniqueDatabaseIndexPopulatorTest.addUpdate(this.populator, 3L, 1);
        Mockito.when((Object)this.propertyAccessor.getProperty(1L, 2)).thenReturn((Object)Property.intProperty((int)2, (int)1));
        Mockito.when((Object)this.propertyAccessor.getProperty(3L, 2)).thenReturn((Object)Property.intProperty((int)2, (int)1));
        try {
            this.populator.verifyDeferredConstraints(this.propertyAccessor);
            Assert.fail((String)"should have thrown exception");
        }
        catch (IndexEntryConflictException conflict) {
            Assert.assertEquals((long)1L, (long)conflict.getExistingNodeId());
            Assert.assertEquals((Object)1, (Object)conflict.getSinglePropertyValue());
            Assert.assertEquals((long)3L, (long)conflict.getAddedNodeId());
        }
    }

    @Test
    public void shouldRejectDuplicateEntryWhenUsingPopulatingUpdater() throws Exception {
        this.populator = this.newPopulator();
        UniqueDatabaseIndexPopulatorTest.addUpdate(this.populator, 1L, "value1");
        UniqueDatabaseIndexPopulatorTest.addUpdate(this.populator, 2L, "value2");
        Mockito.when((Object)this.propertyAccessor.getProperty(1L, 2)).thenReturn((Object)Property.stringProperty((int)2, (String)"value1"));
        Mockito.when((Object)this.propertyAccessor.getProperty(3L, 2)).thenReturn((Object)Property.stringProperty((int)2, (String)"value1"));
        try {
            IndexUpdater updater = this.populator.newPopulatingUpdater(this.propertyAccessor);
            updater.process(IndexEntryUpdate.add((long)3L, (LabelSchemaSupplier)this.schemaDescriptor, (Object[])new Object[]{"value1"}));
            updater.close();
            Assert.fail((String)"should have thrown exception");
        }
        catch (IndexEntryConflictException conflict) {
            Assert.assertEquals((long)1L, (long)conflict.getExistingNodeId());
            Assert.assertEquals((Object)"value1", (Object)conflict.getSinglePropertyValue());
            Assert.assertEquals((long)3L, (long)conflict.getAddedNodeId());
        }
    }

    @Test
    public void shouldRejectDuplicateEntryAfterUsingPopulatingUpdater() throws Exception {
        this.populator = this.newPopulator();
        String value = "value1";
        IndexUpdater updater = this.populator.newPopulatingUpdater(this.propertyAccessor);
        updater.process(IndexEntryUpdate.add((long)1L, (LabelSchemaSupplier)this.schemaDescriptor, (Object[])new Object[]{value}));
        UniqueDatabaseIndexPopulatorTest.addUpdate(this.populator, 2L, value);
        Mockito.when((Object)this.propertyAccessor.getProperty(1L, 2)).thenReturn((Object)Property.stringProperty((int)2, (String)value));
        Mockito.when((Object)this.propertyAccessor.getProperty(2L, 2)).thenReturn((Object)Property.stringProperty((int)2, (String)value));
        try {
            this.populator.verifyDeferredConstraints(this.propertyAccessor);
            Assert.fail((String)"should have thrown exception");
        }
        catch (IndexEntryConflictException conflict) {
            Assert.assertEquals((long)1L, (long)conflict.getExistingNodeId());
            Assert.assertEquals((Object)value, (Object)conflict.getSinglePropertyValue());
            Assert.assertEquals((long)2L, (long)conflict.getAddedNodeId());
        }
    }

    @Test
    public void shouldNotRejectDuplicateEntryOnSameNodeIdAfterUsingPopulatingUpdater() throws Exception {
        this.populator = this.newPopulator();
        Mockito.when((Object)this.propertyAccessor.getProperty(1L, 2)).thenReturn((Object)Property.stringProperty((int)2, (String)"value1"));
        IndexUpdater updater = this.populator.newPopulatingUpdater(this.propertyAccessor);
        updater.process(IndexEntryUpdate.add((long)1L, (LabelSchemaSupplier)this.schemaDescriptor, (Object[])new Object[]{"value1"}));
        updater.process(IndexEntryUpdate.change((long)1L, (LabelSchemaSupplier)this.schemaDescriptor, (Object)"value1", (Object)"value1"));
        updater.close();
        UniqueDatabaseIndexPopulatorTest.addUpdate(this.populator, 2L, "value2");
        UniqueDatabaseIndexPopulatorTest.addUpdate(this.populator, 3L, "value3");
        this.populator.verifyDeferredConstraints(this.propertyAccessor);
        this.populator.close(true);
        Assert.assertEquals(Arrays.asList(1L), AllNodesCollector.getAllNodes(this.getDirectory(), "value1"));
        Assert.assertEquals(Arrays.asList(2L), AllNodesCollector.getAllNodes(this.getDirectory(), "value2"));
        Assert.assertEquals(Arrays.asList(3L), AllNodesCollector.getAllNodes(this.getDirectory(), "value3"));
    }

    @Test
    public void shouldNotRejectIndexCollisionsCausedByPrecisionLossAsDuplicates() throws Exception {
        this.populator = this.newPopulator();
        UniqueDatabaseIndexPopulatorTest.addUpdate(this.populator, 1L, 1000000000000000001L);
        UniqueDatabaseIndexPopulatorTest.addUpdate(this.populator, 2L, 2);
        UniqueDatabaseIndexPopulatorTest.addUpdate(this.populator, 3L, 1000000000000000001L);
        Mockito.when((Object)this.propertyAccessor.getProperty(1L, 2)).thenReturn((Object)Property.longProperty((int)2, (long)1000000000000000001L));
        Mockito.when((Object)this.propertyAccessor.getProperty(3L, 2)).thenReturn((Object)Property.longProperty((int)2, (long)1000000000000000002L));
        this.populator.verifyDeferredConstraints(this.propertyAccessor);
    }

    @Test
    public void shouldCheckAllCollisionsFromPopulatorAdd() throws Exception {
        this.populator = this.newPopulator();
        int iterations = 228;
        IndexUpdater updater = this.populator.newPopulatingUpdater(this.propertyAccessor);
        for (int nodeId = 0; nodeId < iterations; ++nodeId) {
            updater.process(IndexEntryUpdate.add((long)nodeId, (LabelSchemaSupplier)this.schemaDescriptor, (Object[])new Object[]{1}));
            Mockito.when((Object)this.propertyAccessor.getProperty((long)nodeId, 2)).thenReturn((Object)Property.intProperty((int)2, (int)nodeId));
        }
        updater.process(IndexEntryUpdate.add((long)iterations, (LabelSchemaSupplier)this.schemaDescriptor, (Object[])new Object[]{1}));
        Mockito.when((Object)this.propertyAccessor.getProperty((long)iterations, 2)).thenReturn((Object)Property.intProperty((int)2, (int)1));
        try {
            updater.close();
            Assert.fail((String)"should have thrown exception");
        }
        catch (IndexEntryConflictException conflict) {
            Assert.assertEquals((long)1L, (long)conflict.getExistingNodeId());
            Assert.assertEquals((Object)1, (Object)conflict.getSinglePropertyValue());
            Assert.assertEquals((long)iterations, (long)conflict.getAddedNodeId());
        }
    }

    @Test
    public void shouldCheckAllCollisionsFromUpdaterClose() throws Exception {
        this.populator = this.newPopulator();
        int iterations = 228;
        for (int nodeId = 0; nodeId < iterations; ++nodeId) {
            UniqueDatabaseIndexPopulatorTest.addUpdate(this.populator, nodeId, 1);
            Mockito.when((Object)this.propertyAccessor.getProperty((long)nodeId, 2)).thenReturn((Object)Property.intProperty((int)2, (int)nodeId));
        }
        UniqueDatabaseIndexPopulatorTest.addUpdate(this.populator, iterations, 1);
        Mockito.when((Object)this.propertyAccessor.getProperty((long)iterations, 2)).thenReturn((Object)Property.intProperty((int)2, (int)1));
        try {
            this.populator.verifyDeferredConstraints(this.propertyAccessor);
            Assert.fail((String)"should have thrown exception");
        }
        catch (IndexEntryConflictException conflict) {
            Assert.assertEquals((long)1L, (long)conflict.getExistingNodeId());
            Assert.assertEquals((Object)1, (Object)conflict.getSinglePropertyValue());
            Assert.assertEquals((long)iterations, (long)conflict.getAddedNodeId());
        }
    }

    @Test
    public void shouldReleaseSearcherProperlyAfterVerifyingDeferredConstraints() throws Exception {
        this.populator = this.newPopulator();
        OtherThreadExecutor executor = (OtherThreadExecutor)this.cleanup.add((AutoCloseable)new OtherThreadExecutor("Deferred", null));
        executor.execute(state -> {
            IndexUpdater updater = this.populator.newPopulatingUpdater(this.propertyAccessor);
            Throwable throwable = null;
            if (updater != null) {
                if (throwable != null) {
                    try {
                        updater.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    updater.close();
                }
            }
            return null;
        });
        executor.execute(state -> {
            this.populator.verifyDeferredConstraints(this.propertyAccessor);
            return null;
        });
        executor.execute(state -> {
            IndexUpdater secondUpdater = this.populator.newPopulatingUpdater(this.propertyAccessor);
            Throwable throwable = null;
            if (secondUpdater != null) {
                if (throwable != null) {
                    try {
                        secondUpdater.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    secondUpdater.close();
                }
            }
            return null;
        }, 5L, TimeUnit.SECONDS);
    }

    @Test
    public void sampleEmptyIndex() throws Exception {
        this.populator = this.newPopulator();
        IndexSample sample = this.populator.sampleResult();
        Assert.assertEquals((Object)new IndexSample(), (Object)sample);
    }

    @Test
    public void sampleIncludedUpdates() throws Exception {
        LabelSchemaDescriptor schemaDescriptor = SchemaDescriptorFactory.forLabel((int)1, (int[])new int[]{1});
        this.populator = this.newPopulator();
        List<IndexEntryUpdate> updates = Arrays.asList(IndexEntryUpdate.add((long)1L, (LabelSchemaSupplier)schemaDescriptor, (Object[])new Object[]{"foo"}), IndexEntryUpdate.add((long)2L, (LabelSchemaSupplier)schemaDescriptor, (Object[])new Object[]{"bar"}), IndexEntryUpdate.add((long)3L, (LabelSchemaSupplier)schemaDescriptor, (Object[])new Object[]{"baz"}), IndexEntryUpdate.add((long)4L, (LabelSchemaSupplier)schemaDescriptor, (Object[])new Object[]{"qux"}));
        updates.forEach(arg_0 -> ((UniqueLuceneIndexPopulator)this.populator).includeSample(arg_0));
        IndexSample sample = this.populator.sampleResult();
        Assert.assertEquals((Object)new IndexSample(4L, 4L, 4L), (Object)sample);
    }

    @Test
    public void addUpdates() throws Exception {
        this.populator = this.newPopulator();
        List<IndexEntryUpdate> updates = Arrays.asList(IndexEntryUpdate.add((long)1L, (LabelSchemaSupplier)this.schemaDescriptor, (Object[])new Object[]{"aaa"}), IndexEntryUpdate.add((long)2L, (LabelSchemaSupplier)this.schemaDescriptor, (Object[])new Object[]{"bbb"}), IndexEntryUpdate.add((long)3L, (LabelSchemaSupplier)this.schemaDescriptor, (Object[])new Object[]{"ccc"}));
        this.populator.add(updates);
        this.index.maybeRefreshBlocking();
        try (IndexReader reader = this.index.getIndexReader();){
            PrimitiveLongIterator allEntities = reader.query(new IndexQuery[]{IndexQuery.exists((int)1)});
            Assert.assertArrayEquals((long[])new long[]{1L, 2L, 3L}, (long[])PrimitiveLongCollections.asArray((PrimitiveLongIterator)allEntities));
        }
    }

    private UniqueLuceneIndexPopulator newPopulator() throws IOException {
        UniqueLuceneIndexPopulator populator = new UniqueLuceneIndexPopulator(this.index, descriptor);
        populator.create();
        return populator;
    }

    private static void addUpdate(UniqueLuceneIndexPopulator populator, long nodeId, Object value) throws IOException, IndexEntryConflictException {
        IndexEntryUpdate update = IndexEntryUpdate.add((long)nodeId, (LabelSchemaSupplier)descriptor.schema(), (Object[])new Object[]{value});
        populator.add(update);
    }
}

