/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.populator;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.impl.index.storage.DirectoryFactory;
import org.neo4j.kernel.api.impl.index.storage.PartitionedIndexStorage;
import org.neo4j.kernel.api.impl.schema.LuceneSchemaIndexBuilder;
import org.neo4j.kernel.api.impl.schema.SchemaIndex;
import org.neo4j.kernel.api.impl.schema.populator.NonUniqueLuceneIndexPopulator;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.schema_new.IndexQuery;
import org.neo4j.kernel.api.schema_new.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema_new.LabelSchemaSupplier;
import org.neo4j.kernel.api.schema_new.SchemaDescriptorFactory;
import org.neo4j.kernel.api.schema_new.index.NewIndexDescriptor;
import org.neo4j.kernel.api.schema_new.index.NewIndexDescriptorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.IndexSample;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class NonUniqueDatabaseIndexPopulatorTest {
    @Rule
    public final TestDirectory testDir = TestDirectory.testDirectory();
    @Rule
    public final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    private final DirectoryFactory dirFactory = new DirectoryFactory.InMemoryDirectoryFactory();
    private SchemaIndex index;
    private NonUniqueLuceneIndexPopulator populator;
    private LabelSchemaDescriptor labelSchemaDescriptor = SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{0});

    @Before
    public void setUp() throws Exception {
        File folder = this.testDir.directory("folder");
        PartitionedIndexStorage indexStorage = new PartitionedIndexStorage(this.dirFactory, this.fileSystemRule.get(), folder, "testIndex", false);
        this.index = ((LuceneSchemaIndexBuilder)LuceneSchemaIndexBuilder.create((NewIndexDescriptor)NewIndexDescriptorFactory.forSchema((LabelSchemaDescriptor)this.labelSchemaDescriptor)).withIndexStorage(indexStorage)).build();
    }

    @After
    public void tearDown() throws Exception {
        if (this.populator != null) {
            this.populator.close(false);
        }
        IOUtils.closeAll((AutoCloseable[])new Closeable[]{this.index, this.dirFactory});
    }

    @Test
    public void sampleEmptyIndex() throws IOException {
        this.populator = this.newPopulator();
        IndexSample sample = this.populator.sampleResult();
        Assert.assertEquals((Object)new IndexSample(), (Object)sample);
    }

    @Test
    public void sampleIncludedUpdates() throws Exception {
        this.populator = this.newPopulator();
        List<IndexEntryUpdate> updates = Arrays.asList(IndexEntryUpdate.add((long)1L, (LabelSchemaSupplier)this.labelSchemaDescriptor, (Object[])new Object[]{"aaa"}), IndexEntryUpdate.add((long)2L, (LabelSchemaSupplier)this.labelSchemaDescriptor, (Object[])new Object[]{"bbb"}), IndexEntryUpdate.add((long)3L, (LabelSchemaSupplier)this.labelSchemaDescriptor, (Object[])new Object[]{"ccc"}));
        updates.forEach(arg_0 -> ((NonUniqueLuceneIndexPopulator)this.populator).includeSample(arg_0));
        IndexSample sample = this.populator.sampleResult();
        Assert.assertEquals((Object)new IndexSample(3L, 3L, 3L), (Object)sample);
    }

    @Test
    public void sampleIncludedUpdatesWithDuplicates() throws Exception {
        this.populator = this.newPopulator();
        List<IndexEntryUpdate> updates = Arrays.asList(IndexEntryUpdate.add((long)1L, (LabelSchemaSupplier)this.labelSchemaDescriptor, (Object[])new Object[]{"foo"}), IndexEntryUpdate.add((long)2L, (LabelSchemaSupplier)this.labelSchemaDescriptor, (Object[])new Object[]{"bar"}), IndexEntryUpdate.add((long)3L, (LabelSchemaSupplier)this.labelSchemaDescriptor, (Object[])new Object[]{"foo"}));
        updates.forEach(arg_0 -> ((NonUniqueLuceneIndexPopulator)this.populator).includeSample(arg_0));
        IndexSample sample = this.populator.sampleResult();
        Assert.assertEquals((Object)new IndexSample(3L, 2L, 3L), (Object)sample);
    }

    @Test
    public void addUpdates() throws Exception {
        this.populator = this.newPopulator();
        List<IndexEntryUpdate> updates = Arrays.asList(IndexEntryUpdate.add((long)1L, (LabelSchemaSupplier)this.labelSchemaDescriptor, (Object[])new Object[]{"foo"}), IndexEntryUpdate.add((long)2L, (LabelSchemaSupplier)this.labelSchemaDescriptor, (Object[])new Object[]{"bar"}), IndexEntryUpdate.add((long)42L, (LabelSchemaSupplier)this.labelSchemaDescriptor, (Object[])new Object[]{"bar"}));
        this.populator.add(updates);
        this.index.maybeRefreshBlocking();
        try (IndexReader reader = this.index.getIndexReader();){
            int propertyKeyId = this.labelSchemaDescriptor.getPropertyId();
            PrimitiveLongIterator allEntities = reader.query(new IndexQuery[]{IndexQuery.exists((int)propertyKeyId)});
            Assert.assertArrayEquals((long[])new long[]{1L, 2L, 42L}, (long[])PrimitiveLongCollections.asArray((PrimitiveLongIterator)allEntities));
        }
    }

    private NonUniqueLuceneIndexPopulator newPopulator() throws IOException {
        IndexSamplingConfig samplingConfig = new IndexSamplingConfig(Config.empty());
        NonUniqueLuceneIndexPopulator populator = new NonUniqueLuceneIndexPopulator(this.index, samplingConfig);
        populator.create();
        populator.configureSampling(true);
        return populator;
    }
}

