/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.populator;

import java.io.IOException;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.kernel.api.impl.schema.LuceneDocumentStructure;
import org.neo4j.kernel.api.impl.schema.populator.NonUniqueLuceneIndexPopulatingUpdater;
import org.neo4j.kernel.api.impl.schema.writer.LuceneIndexWriter;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.schema_new.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema_new.LabelSchemaSupplier;
import org.neo4j.kernel.api.schema_new.SchemaDescriptorFactory;
import org.neo4j.kernel.impl.api.index.sampling.DefaultNonUniqueIndexSampler;
import org.neo4j.kernel.impl.api.index.sampling.NonUniqueIndexSampler;
import org.neo4j.storageengine.api.schema.IndexSample;

public class NonUniqueDatabaseIndexPopulatingUpdaterTest {
    private static final LabelSchemaDescriptor SCHEMA_DESCRIPTOR = SchemaDescriptorFactory.forLabel((int)1, (int[])new int[]{42});
    private static final int SAMPLING_BUFFER_SIZE_LIMIT = 100;
    private static final LabelSchemaDescriptor COMPOSITE_SCHEMA_DESCRIPTOR = SchemaDescriptorFactory.forLabel((int)1, (int[])new int[]{42, 43});

    @Test
    public void removeNotSupported() {
        NonUniqueLuceneIndexPopulatingUpdater updater = NonUniqueDatabaseIndexPopulatingUpdaterTest.newUpdater();
        try {
            updater.remove(PrimitiveLongCollections.setOf((long[])new long[]{1L, 2L, 3L}));
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(UnsupportedOperationException.class));
        }
    }

    @Test
    public void addedNodePropertiesIncludedInSample() throws Exception {
        NonUniqueIndexSampler sampler = NonUniqueDatabaseIndexPopulatingUpdaterTest.newSampler();
        NonUniqueLuceneIndexPopulatingUpdater updater = NonUniqueDatabaseIndexPopulatingUpdaterTest.newUpdater(sampler);
        updater.process(IndexEntryUpdate.add((long)1L, (LabelSchemaSupplier)SCHEMA_DESCRIPTOR, (Object[])new Object[]{"foo"}));
        updater.process(IndexEntryUpdate.add((long)2L, (LabelSchemaSupplier)SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bar"}));
        updater.process(IndexEntryUpdate.add((long)3L, (LabelSchemaSupplier)SCHEMA_DESCRIPTOR, (Object[])new Object[]{"baz"}));
        updater.process(IndexEntryUpdate.add((long)4L, (LabelSchemaSupplier)SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bar"}));
        NonUniqueDatabaseIndexPopulatingUpdaterTest.verifySamplingResult(sampler, 4L, 3L, 4L);
    }

    @Test
    public void addedNodeCompositePropertiesIncludedInSample() throws Exception {
        NonUniqueIndexSampler sampler = NonUniqueDatabaseIndexPopulatingUpdaterTest.newSampler();
        NonUniqueLuceneIndexPopulatingUpdater updater = NonUniqueDatabaseIndexPopulatingUpdaterTest.newUpdater(sampler);
        updater.process(IndexEntryUpdate.add((long)1L, (LabelSchemaSupplier)COMPOSITE_SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bit", "foo"}));
        updater.process(IndexEntryUpdate.add((long)2L, (LabelSchemaSupplier)COMPOSITE_SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bit", "bar"}));
        updater.process(IndexEntryUpdate.add((long)3L, (LabelSchemaSupplier)COMPOSITE_SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bit", "baz"}));
        updater.process(IndexEntryUpdate.add((long)4L, (LabelSchemaSupplier)COMPOSITE_SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bit", "bar"}));
        NonUniqueDatabaseIndexPopulatingUpdaterTest.verifySamplingResult(sampler, 4L, 3L, 4L);
    }

    @Test
    public void changedNodePropertiesIncludedInSample() throws Exception {
        NonUniqueIndexSampler sampler = NonUniqueDatabaseIndexPopulatingUpdaterTest.newSampler();
        NonUniqueLuceneIndexPopulatingUpdater updater = NonUniqueDatabaseIndexPopulatingUpdaterTest.newUpdater(sampler);
        updater.process(IndexEntryUpdate.add((long)1L, (LabelSchemaSupplier)SCHEMA_DESCRIPTOR, (Object[])new Object[]{"initial1"}));
        updater.process(IndexEntryUpdate.add((long)2L, (LabelSchemaSupplier)SCHEMA_DESCRIPTOR, (Object[])new Object[]{"initial2"}));
        updater.process(IndexEntryUpdate.add((long)3L, (LabelSchemaSupplier)SCHEMA_DESCRIPTOR, (Object[])new Object[]{"new2"}));
        updater.process(IndexEntryUpdate.change((long)1L, (LabelSchemaSupplier)SCHEMA_DESCRIPTOR, (Object)"initial1", (Object)"new1"));
        updater.process(IndexEntryUpdate.change((long)1L, (LabelSchemaSupplier)SCHEMA_DESCRIPTOR, (Object)"initial2", (Object)"new2"));
        NonUniqueDatabaseIndexPopulatingUpdaterTest.verifySamplingResult(sampler, 3L, 2L, 3L);
    }

    @Test
    public void changedNodeCompositePropertiesIncludedInSample() throws Exception {
        NonUniqueIndexSampler sampler = NonUniqueDatabaseIndexPopulatingUpdaterTest.newSampler();
        NonUniqueLuceneIndexPopulatingUpdater updater = NonUniqueDatabaseIndexPopulatingUpdaterTest.newUpdater(sampler);
        updater.process(IndexEntryUpdate.add((long)1L, (LabelSchemaSupplier)COMPOSITE_SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bit", "initial1"}));
        updater.process(IndexEntryUpdate.add((long)2L, (LabelSchemaSupplier)COMPOSITE_SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bit", "initial2"}));
        updater.process(IndexEntryUpdate.add((long)3L, (LabelSchemaSupplier)COMPOSITE_SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bit", "new2"}));
        updater.process(IndexEntryUpdate.change((long)1L, (LabelSchemaSupplier)COMPOSITE_SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bit", "initial1"}, (Object[])new Object[]{"bit", "new1"}));
        updater.process(IndexEntryUpdate.change((long)1L, (LabelSchemaSupplier)COMPOSITE_SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bit", "initial2"}, (Object[])new Object[]{"bit", "new2"}));
        NonUniqueDatabaseIndexPopulatingUpdaterTest.verifySamplingResult(sampler, 3L, 2L, 3L);
    }

    @Test
    public void removedNodePropertyIncludedInSample() throws Exception {
        NonUniqueIndexSampler sampler = NonUniqueDatabaseIndexPopulatingUpdaterTest.newSampler();
        NonUniqueLuceneIndexPopulatingUpdater updater = NonUniqueDatabaseIndexPopulatingUpdaterTest.newUpdater(sampler);
        updater.process(IndexEntryUpdate.add((long)1L, (LabelSchemaSupplier)SCHEMA_DESCRIPTOR, (Object[])new Object[]{"foo"}));
        updater.process(IndexEntryUpdate.add((long)2L, (LabelSchemaSupplier)SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bar"}));
        updater.process(IndexEntryUpdate.add((long)3L, (LabelSchemaSupplier)SCHEMA_DESCRIPTOR, (Object[])new Object[]{"baz"}));
        updater.process(IndexEntryUpdate.add((long)4L, (LabelSchemaSupplier)SCHEMA_DESCRIPTOR, (Object[])new Object[]{"qux"}));
        updater.process(IndexEntryUpdate.remove((long)1L, (LabelSchemaSupplier)SCHEMA_DESCRIPTOR, (Object[])new Object[]{"foo"}));
        updater.process(IndexEntryUpdate.remove((long)2L, (LabelSchemaSupplier)SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bar"}));
        updater.process(IndexEntryUpdate.remove((long)4L, (LabelSchemaSupplier)SCHEMA_DESCRIPTOR, (Object[])new Object[]{"qux"}));
        NonUniqueDatabaseIndexPopulatingUpdaterTest.verifySamplingResult(sampler, 1L, 1L, 1L);
    }

    @Test
    public void removedNodeCompositePropertyIncludedInSample() throws Exception {
        NonUniqueIndexSampler sampler = NonUniqueDatabaseIndexPopulatingUpdaterTest.newSampler();
        NonUniqueLuceneIndexPopulatingUpdater updater = NonUniqueDatabaseIndexPopulatingUpdaterTest.newUpdater(sampler);
        updater.process(IndexEntryUpdate.add((long)1L, (LabelSchemaSupplier)COMPOSITE_SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bit", "foo"}));
        updater.process(IndexEntryUpdate.add((long)2L, (LabelSchemaSupplier)COMPOSITE_SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bit", "bar"}));
        updater.process(IndexEntryUpdate.add((long)3L, (LabelSchemaSupplier)COMPOSITE_SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bit", "baz"}));
        updater.process(IndexEntryUpdate.add((long)4L, (LabelSchemaSupplier)COMPOSITE_SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bit", "qux"}));
        updater.process(IndexEntryUpdate.remove((long)1L, (LabelSchemaSupplier)COMPOSITE_SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bit", "foo"}));
        updater.process(IndexEntryUpdate.remove((long)2L, (LabelSchemaSupplier)COMPOSITE_SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bit", "bar"}));
        updater.process(IndexEntryUpdate.remove((long)4L, (LabelSchemaSupplier)COMPOSITE_SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bit", "qux"}));
        NonUniqueDatabaseIndexPopulatingUpdaterTest.verifySamplingResult(sampler, 1L, 1L, 1L);
    }

    @Test
    public void nodePropertyUpdatesIncludedInSample() throws Exception {
        NonUniqueIndexSampler sampler = NonUniqueDatabaseIndexPopulatingUpdaterTest.newSampler();
        NonUniqueLuceneIndexPopulatingUpdater updater = NonUniqueDatabaseIndexPopulatingUpdaterTest.newUpdater(sampler);
        updater.process(IndexEntryUpdate.add((long)1L, (LabelSchemaSupplier)SCHEMA_DESCRIPTOR, (Object[])new Object[]{"foo"}));
        updater.process(IndexEntryUpdate.change((long)1L, (LabelSchemaSupplier)SCHEMA_DESCRIPTOR, (Object)"foo", (Object)"newFoo1"));
        updater.process(IndexEntryUpdate.add((long)2L, (LabelSchemaSupplier)SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bar"}));
        updater.process(IndexEntryUpdate.remove((long)2L, (LabelSchemaSupplier)SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bar"}));
        updater.process(IndexEntryUpdate.change((long)1L, (LabelSchemaSupplier)SCHEMA_DESCRIPTOR, (Object)"newFoo1", (Object)"newFoo2"));
        updater.process(IndexEntryUpdate.add((long)42L, (LabelSchemaSupplier)SCHEMA_DESCRIPTOR, (Object[])new Object[]{"qux"}));
        updater.process(IndexEntryUpdate.add((long)3L, (LabelSchemaSupplier)SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bar"}));
        updater.process(IndexEntryUpdate.add((long)4L, (LabelSchemaSupplier)SCHEMA_DESCRIPTOR, (Object[])new Object[]{"baz"}));
        updater.process(IndexEntryUpdate.add((long)5L, (LabelSchemaSupplier)SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bar"}));
        updater.process(IndexEntryUpdate.remove((long)42L, (LabelSchemaSupplier)SCHEMA_DESCRIPTOR, (Object[])new Object[]{"qux"}));
        NonUniqueDatabaseIndexPopulatingUpdaterTest.verifySamplingResult(sampler, 4L, 3L, 4L);
    }

    @Test
    public void nodeCompositePropertyUpdatesIncludedInSample() throws Exception {
        NonUniqueIndexSampler sampler = NonUniqueDatabaseIndexPopulatingUpdaterTest.newSampler();
        NonUniqueLuceneIndexPopulatingUpdater updater = NonUniqueDatabaseIndexPopulatingUpdaterTest.newUpdater(sampler);
        updater.process(IndexEntryUpdate.add((long)1L, (LabelSchemaSupplier)COMPOSITE_SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bit", "foo"}));
        updater.process(IndexEntryUpdate.change((long)1L, (LabelSchemaSupplier)COMPOSITE_SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bit", "foo"}, (Object[])new Object[]{"bit", "newFoo1"}));
        updater.process(IndexEntryUpdate.add((long)2L, (LabelSchemaSupplier)COMPOSITE_SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bit", "bar"}));
        updater.process(IndexEntryUpdate.remove((long)2L, (LabelSchemaSupplier)COMPOSITE_SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bit", "bar"}));
        updater.process(IndexEntryUpdate.change((long)1L, (LabelSchemaSupplier)COMPOSITE_SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bit", "newFoo1"}, (Object[])new Object[]{"bit", "newFoo2"}));
        updater.process(IndexEntryUpdate.add((long)42L, (LabelSchemaSupplier)COMPOSITE_SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bit", "qux"}));
        updater.process(IndexEntryUpdate.add((long)3L, (LabelSchemaSupplier)COMPOSITE_SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bit", "bar"}));
        updater.process(IndexEntryUpdate.add((long)4L, (LabelSchemaSupplier)COMPOSITE_SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bit", "baz"}));
        updater.process(IndexEntryUpdate.add((long)5L, (LabelSchemaSupplier)COMPOSITE_SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bit", "bar"}));
        updater.process(IndexEntryUpdate.remove((long)42L, (LabelSchemaSupplier)COMPOSITE_SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bit", "qux"}));
        NonUniqueDatabaseIndexPopulatingUpdaterTest.verifySamplingResult(sampler, 4L, 3L, 4L);
    }

    @Test
    public void additionsDeliveredToIndexWriter() throws Exception {
        LuceneIndexWriter writer = (LuceneIndexWriter)Mockito.mock(LuceneIndexWriter.class);
        NonUniqueLuceneIndexPopulatingUpdater updater = NonUniqueDatabaseIndexPopulatingUpdaterTest.newUpdater(writer);
        String expectedString1 = LuceneDocumentStructure.documentRepresentingProperties((long)1L, (Object[])new Object[]{"foo"}).toString();
        String expectedString2 = LuceneDocumentStructure.documentRepresentingProperties((long)2L, (Object[])new Object[]{"bar"}).toString();
        String expectedString3 = LuceneDocumentStructure.documentRepresentingProperties((long)3L, (Object[])new Object[]{"qux"}).toString();
        String expectedString4 = LuceneDocumentStructure.documentRepresentingProperties((long)4L, (Object[])new Object[]{"git", "bit"}).toString();
        updater.process(IndexEntryUpdate.add((long)1L, (LabelSchemaSupplier)SCHEMA_DESCRIPTOR, (Object[])new Object[]{"foo"}));
        this.verifydocument(writer, LuceneDocumentStructure.newTermForChangeOrRemove((long)1L), expectedString1);
        updater.process(IndexEntryUpdate.add((long)2L, (LabelSchemaSupplier)SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bar"}));
        this.verifydocument(writer, LuceneDocumentStructure.newTermForChangeOrRemove((long)2L), expectedString2);
        updater.process(IndexEntryUpdate.add((long)3L, (LabelSchemaSupplier)SCHEMA_DESCRIPTOR, (Object[])new Object[]{"qux"}));
        this.verifydocument(writer, LuceneDocumentStructure.newTermForChangeOrRemove((long)3L), expectedString3);
        updater.process(IndexEntryUpdate.add((long)4L, (LabelSchemaSupplier)COMPOSITE_SCHEMA_DESCRIPTOR, (Object[])new Object[]{"git", "bit"}));
        this.verifydocument(writer, LuceneDocumentStructure.newTermForChangeOrRemove((long)4L), expectedString4);
    }

    @Test
    public void changesDeliveredToIndexWriter() throws Exception {
        LuceneIndexWriter writer = (LuceneIndexWriter)Mockito.mock(LuceneIndexWriter.class);
        NonUniqueLuceneIndexPopulatingUpdater updater = NonUniqueDatabaseIndexPopulatingUpdaterTest.newUpdater(writer);
        String expectedString1 = LuceneDocumentStructure.documentRepresentingProperties((long)1L, (Object[])new Object[]{"after1"}).toString();
        String expectedString2 = LuceneDocumentStructure.documentRepresentingProperties((long)2L, (Object[])new Object[]{"after2"}).toString();
        String expectedString3 = LuceneDocumentStructure.documentRepresentingProperties((long)3L, (Object[])new Object[]{"bit", "after2"}).toString();
        updater.process(IndexEntryUpdate.change((long)1L, (LabelSchemaSupplier)SCHEMA_DESCRIPTOR, (Object)"before1", (Object)"after1"));
        this.verifydocument(writer, LuceneDocumentStructure.newTermForChangeOrRemove((long)1L), expectedString1);
        updater.process(IndexEntryUpdate.change((long)2L, (LabelSchemaSupplier)SCHEMA_DESCRIPTOR, (Object)"before2", (Object)"after2"));
        this.verifydocument(writer, LuceneDocumentStructure.newTermForChangeOrRemove((long)2L), expectedString2);
        updater.process(IndexEntryUpdate.change((long)3L, (LabelSchemaSupplier)COMPOSITE_SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bit", "before2"}, (Object[])new Object[]{"bit", "after2"}));
        this.verifydocument(writer, LuceneDocumentStructure.newTermForChangeOrRemove((long)3L), expectedString3);
    }

    private void verifydocument(LuceneIndexWriter writer, Term eq, String documentString) throws IOException {
        ((LuceneIndexWriter)Mockito.verify((Object)writer)).updateDocument((Term)org.mockito.Matchers.eq((Object)eq), (Document)org.mockito.Matchers.argThat((Matcher)Matchers.hasToString((String)documentString)));
    }

    @Test
    public void removalsDeliveredToIndexWriter() throws Exception {
        LuceneIndexWriter writer = (LuceneIndexWriter)Mockito.mock(LuceneIndexWriter.class);
        NonUniqueLuceneIndexPopulatingUpdater updater = NonUniqueDatabaseIndexPopulatingUpdaterTest.newUpdater(writer);
        updater.process(IndexEntryUpdate.remove((long)1L, (LabelSchemaSupplier)SCHEMA_DESCRIPTOR, (Object[])new Object[]{"foo"}));
        ((LuceneIndexWriter)Mockito.verify((Object)writer)).deleteDocuments(LuceneDocumentStructure.newTermForChangeOrRemove((long)1L));
        updater.process(IndexEntryUpdate.remove((long)2L, (LabelSchemaSupplier)SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bar"}));
        ((LuceneIndexWriter)Mockito.verify((Object)writer)).deleteDocuments(LuceneDocumentStructure.newTermForChangeOrRemove((long)2L));
        updater.process(IndexEntryUpdate.remove((long)3L, (LabelSchemaSupplier)SCHEMA_DESCRIPTOR, (Object[])new Object[]{"baz"}));
        ((LuceneIndexWriter)Mockito.verify((Object)writer)).deleteDocuments(LuceneDocumentStructure.newTermForChangeOrRemove((long)3L));
        updater.process(IndexEntryUpdate.remove((long)4L, (LabelSchemaSupplier)COMPOSITE_SCHEMA_DESCRIPTOR, (Object[])new Object[]{"bit", "baz"}));
        ((LuceneIndexWriter)Mockito.verify((Object)writer)).deleteDocuments(LuceneDocumentStructure.newTermForChangeOrRemove((long)4L));
    }

    private static void verifySamplingResult(NonUniqueIndexSampler sampler, long expectedIndexSize, long expectedUniqueValues, long expectedSampleSize) {
        IndexSample sample = sampler.result();
        Assert.assertEquals((long)expectedIndexSize, (long)sample.indexSize());
        Assert.assertEquals((long)expectedUniqueValues, (long)sample.uniqueValues());
        Assert.assertEquals((long)expectedSampleSize, (long)sample.sampleSize());
    }

    private static NonUniqueLuceneIndexPopulatingUpdater newUpdater() {
        return NonUniqueDatabaseIndexPopulatingUpdaterTest.newUpdater(NonUniqueDatabaseIndexPopulatingUpdaterTest.newSampler());
    }

    private static NonUniqueLuceneIndexPopulatingUpdater newUpdater(NonUniqueIndexSampler sampler) {
        return NonUniqueDatabaseIndexPopulatingUpdaterTest.newUpdater((LuceneIndexWriter)Mockito.mock(LuceneIndexWriter.class), sampler);
    }

    private static NonUniqueLuceneIndexPopulatingUpdater newUpdater(LuceneIndexWriter writer) {
        return NonUniqueDatabaseIndexPopulatingUpdaterTest.newUpdater(writer, NonUniqueDatabaseIndexPopulatingUpdaterTest.newSampler());
    }

    private static NonUniqueLuceneIndexPopulatingUpdater newUpdater(LuceneIndexWriter writer, NonUniqueIndexSampler sampler) {
        return new NonUniqueLuceneIndexPopulatingUpdater(writer, sampler);
    }

    private static NonUniqueIndexSampler newSampler() {
        return new DefaultNonUniqueIndexSampler(100);
    }
}

