/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.test.DatabaseFunctions;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.ImpermanentDatabaseRule;

@RunWith(value=Parameterized.class)
public class UniqueIndexApplicationIT {
    @Rule
    public final DatabaseRule db = new ImpermanentDatabaseRule();
    private final Function<GraphDatabaseService, ?> createIndex;

    @Parameterized.Parameters(name="{0}")
    public static List<Object[]> indexTypes() {
        return Arrays.asList(UniqueIndexApplicationIT.createIndex(DatabaseFunctions.index((Label)Label.label((String)"Label1"), (String)"key1")), UniqueIndexApplicationIT.createIndex(DatabaseFunctions.uniquenessConstraint((Label)Label.label((String)"Label1"), (String)"key1")));
    }

    @After
    public void then() throws Exception {
        Assert.assertThat((String)"Matching nodes from index lookup", (Object)this.db.when(this.db.tx(this.listNodeIdsFromIndexLookup(Label.label((String)"Label1"), "key1", "value1"))), UniqueIndexApplicationIT.hasSize(1));
    }

    @Before
    public void given() throws Exception {
        this.db.executeAndCommit(this.createIndex);
        this.db.executeAndCommit(DatabaseFunctions.awaitIndexesOnline((long)5L, (TimeUnit)TimeUnit.SECONDS));
    }

    @Test
    public void tx_createNode_addLabel_setProperty() throws Exception {
        this.db.when(this.db.tx(DatabaseFunctions.createNode().andThen(DatabaseFunctions.addLabel((Label)Label.label((String)"Label1")).andThen(DatabaseFunctions.setProperty((String)"key1", (Object)"value1")))));
    }

    @Test
    public void tx_createNode_tx_addLabel_setProperty() throws Exception {
        this.db.when(this.db.tx(DatabaseFunctions.createNode()).andThen(this.db.tx(DatabaseFunctions.addLabel((Label)Label.label((String)"Label1")).andThen(DatabaseFunctions.setProperty((String)"key1", (Object)"value1")))));
    }

    @Test
    public void tx_createNode_addLabel_tx_setProperty() throws Exception {
        this.db.when(this.db.tx(DatabaseFunctions.createNode().andThen(DatabaseFunctions.addLabel((Label)Label.label((String)"Label1")))).andThen(this.db.tx(DatabaseFunctions.setProperty((String)"key1", (Object)"value1"))));
    }

    @Test
    public void tx_createNode_setProperty_tx_addLabel() throws Exception {
        this.db.when(this.db.tx(DatabaseFunctions.createNode().andThen(DatabaseFunctions.setProperty((String)"key1", (Object)"value1"))).andThen(this.db.tx(DatabaseFunctions.addLabel((Label)Label.label((String)"Label1")))));
    }

    @Test
    public void tx_createNode_tx_addLabel_tx_setProperty() throws Exception {
        this.db.when(this.db.tx(DatabaseFunctions.createNode()).andThen(this.db.tx(DatabaseFunctions.addLabel((Label)Label.label((String)"Label1"))).andThen(this.db.tx(DatabaseFunctions.setProperty((String)"key1", (Object)"value1")))));
    }

    @Test
    public void tx_createNode_tx_setProperty_tx_addLabel() throws Exception {
        this.db.when(this.db.tx(DatabaseFunctions.createNode()).andThen(this.db.tx(DatabaseFunctions.setProperty((String)"key1", (Object)"value1")).andThen(this.db.tx(DatabaseFunctions.addLabel((Label)Label.label((String)"Label1"))))));
    }

    private static Matcher<List<?>> hasSize(final int size) {
        return new TypeSafeMatcher<List<?>>(){

            protected boolean matchesSafely(List<?> item) {
                return item.size() == size;
            }

            public void describeTo(Description description) {
                description.appendText("List with size=").appendValue((Object)size);
            }
        };
    }

    private Function<GraphDatabaseService, List<Long>> listNodeIdsFromIndexLookup(Label label, String propertyKey, Object value) {
        return graphDb -> {
            ArrayList<Long> ids = new ArrayList<Long>();
            for (Node node : Iterators.loop((Iterator)graphDb.findNodes(label, propertyKey, value))) {
                ids.add(node.getId());
            }
            return ids;
        };
    }

    public UniqueIndexApplicationIT(Function<GraphDatabaseService, ?> createIndex) {
        this.createIndex = createIndex;
    }

    private static Object[] createIndex(Function<GraphDatabaseService, Void> createIndex) {
        return new Object[]{createIndex};
    }
}

