/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import java.io.Closeable;
import java.io.IOException;
import java.util.UUID;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.impl.index.storage.DirectoryFactory;
import org.neo4j.kernel.api.impl.schema.LuceneSchemaIndexBuilder;
import org.neo4j.kernel.api.impl.schema.SchemaIndex;
import org.neo4j.kernel.api.schema_new.index.NewIndexDescriptor;
import org.neo4j.kernel.api.schema_new.index.NewIndexDescriptorFactory;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class LuceneSchemaIndexTest {
    @Rule
    public final DefaultFileSystemRule fs = new DefaultFileSystemRule();
    @Rule
    public TestDirectory testDir = TestDirectory.testDirectory();
    private final DirectoryFactory dirFactory = new DirectoryFactory.InMemoryDirectoryFactory();
    private SchemaIndex index;
    private final NewIndexDescriptor descriptor = NewIndexDescriptorFactory.forLabel((int)3, (int[])new int[]{5});

    @After
    public void closeIndex() throws Exception {
        IOUtils.closeAll((AutoCloseable[])new Closeable[]{this.index, this.dirFactory});
    }

    @Test
    public void markAsOnline() throws IOException {
        this.index = this.createIndex();
        this.index.getIndexWriter().addDocument(LuceneSchemaIndexTest.newDocument());
        this.index.markAsOnline();
        Assert.assertTrue((String)"Should have had online status set", (boolean)this.index.isOnline());
    }

    @Test
    public void markAsOnlineAndClose() throws IOException {
        this.index = this.createIndex();
        this.index.getIndexWriter().addDocument(LuceneSchemaIndexTest.newDocument());
        this.index.markAsOnline();
        this.index.close();
        this.index = this.openIndex();
        Assert.assertTrue((String)"Should have had online status set", (boolean)this.index.isOnline());
    }

    @Test
    public void markAsOnlineTwice() throws IOException {
        this.index = this.createIndex();
        this.index.markAsOnline();
        this.index.getIndexWriter().addDocument(LuceneSchemaIndexTest.newDocument());
        this.index.markAsOnline();
        Assert.assertTrue((String)"Should have had online status set", (boolean)this.index.isOnline());
    }

    @Test
    public void markAsOnlineTwiceAndClose() throws IOException {
        this.index = this.createIndex();
        this.index.markAsOnline();
        this.index.getIndexWriter().addDocument(LuceneSchemaIndexTest.newDocument());
        this.index.markAsOnline();
        this.index.close();
        this.index = this.openIndex();
        Assert.assertTrue((String)"Should have had online status set", (boolean)this.index.isOnline());
    }

    @Test
    public void markAsOnlineIsRespectedByOtherWriter() throws IOException {
        this.index = this.createIndex();
        this.index.markAsOnline();
        this.index.close();
        this.index = this.openIndex();
        this.index.getIndexWriter().addDocument(LuceneSchemaIndexTest.newDocument());
        this.index.close();
        this.index = this.openIndex();
        Assert.assertTrue((String)"Should have had online status set", (boolean)this.index.isOnline());
    }

    private SchemaIndex createIndex() throws IOException {
        SchemaIndex schemaIndex = this.newSchemaIndex();
        schemaIndex.create();
        schemaIndex.open();
        return schemaIndex;
    }

    private SchemaIndex openIndex() throws IOException {
        SchemaIndex schemaIndex = this.newSchemaIndex();
        schemaIndex.open();
        return schemaIndex;
    }

    private SchemaIndex newSchemaIndex() {
        LuceneSchemaIndexBuilder builder = LuceneSchemaIndexBuilder.create((NewIndexDescriptor)this.descriptor);
        return ((LuceneSchemaIndexBuilder)((LuceneSchemaIndexBuilder)((LuceneSchemaIndexBuilder)((LuceneSchemaIndexBuilder)builder.withIndexRootFolder(this.testDir.directory("index"))).withDirectoryFactory(this.dirFactory)).withFileSystem(this.fs.get())).withIndexIdentifier("testIndex")).build();
    }

    private static Document newDocument() {
        Document doc = new Document();
        doc.add((IndexableField)new StringField("test", UUID.randomUUID().toString(), Field.Store.YES));
        return doc;
    }
}

