/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.impl.index.storage.DirectoryFactory;
import org.neo4j.kernel.api.impl.schema.LuceneSchemaIndexProvider;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.schema_new.index.NewIndexDescriptor;
import org.neo4j.kernel.api.schema_new.index.NewIndexDescriptorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.factory.OperationalMode;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class LuceneSchemaIndexProviderTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Rule
    public final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    @Rule
    public final TestDirectory testDir = TestDirectory.testDirectory(this.getClass());
    private File graphDbDir;
    private FileSystemAbstraction fs;
    private static final NewIndexDescriptor descriptor = NewIndexDescriptorFactory.forLabel((int)1, (int[])new int[]{1});

    @Before
    public void setup() {
        this.fs = this.fileSystemRule.get();
        this.graphDbDir = this.testDir.graphDbDir();
    }

    @Test
    public void shouldFailToInvokePopulatorInReadOnlyMode() throws Exception {
        Config readOnlyConfig = Config.embeddedDefaults((Map)MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.read_only.name(), "true"}));
        LuceneSchemaIndexProvider readOnlyIndexProvider = this.getLuceneSchemaIndexProvider(readOnlyConfig, (DirectoryFactory)new DirectoryFactory.InMemoryDirectoryFactory(), this.fs, this.graphDbDir);
        this.expectedException.expect(UnsupportedOperationException.class);
        readOnlyIndexProvider.getPopulator(1L, descriptor, new IndexSamplingConfig(readOnlyConfig));
    }

    @Test
    public void shouldCreateReadOnlyAccessorInReadOnlyMode() throws Exception {
        DirectoryFactory directoryFactory = DirectoryFactory.PERSISTENT;
        this.createEmptySchemaIndex(directoryFactory);
        Config readOnlyConfig = Config.embeddedDefaults((Map)MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.read_only.name(), "true"}));
        LuceneSchemaIndexProvider readOnlyIndexProvider = this.getLuceneSchemaIndexProvider(readOnlyConfig, directoryFactory, this.fs, this.graphDbDir);
        IndexAccessor onlineAccessor = this.getIndexAccessor(readOnlyConfig, readOnlyIndexProvider);
        this.expectedException.expect(UnsupportedOperationException.class);
        onlineAccessor.drop();
    }

    @Test
    public void indexUpdateNotAllowedInReadOnlyMode() throws Exception {
        Config readOnlyConfig = Config.embeddedDefaults((Map)MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.read_only.name(), "true"}));
        LuceneSchemaIndexProvider readOnlyIndexProvider = this.getLuceneSchemaIndexProvider(readOnlyConfig, (DirectoryFactory)new DirectoryFactory.InMemoryDirectoryFactory(), this.fs, this.graphDbDir);
        this.expectedException.expect(UnsupportedOperationException.class);
        this.getIndexAccessor(readOnlyConfig, readOnlyIndexProvider).newUpdater(IndexUpdateMode.ONLINE);
    }

    private void createEmptySchemaIndex(DirectoryFactory directoryFactory) throws IOException {
        Config config = Config.defaults();
        LuceneSchemaIndexProvider indexProvider = this.getLuceneSchemaIndexProvider(config, directoryFactory, this.fs, this.graphDbDir);
        IndexAccessor onlineAccessor = this.getIndexAccessor(config, indexProvider);
        onlineAccessor.flush();
        onlineAccessor.close();
    }

    private IndexAccessor getIndexAccessor(Config readOnlyConfig, LuceneSchemaIndexProvider indexProvider) throws IOException {
        return indexProvider.getOnlineAccessor(1L, descriptor, new IndexSamplingConfig(readOnlyConfig));
    }

    private LuceneSchemaIndexProvider getLuceneSchemaIndexProvider(Config config, DirectoryFactory directoryFactory, FileSystemAbstraction fs, File graphDbDir) {
        return new LuceneSchemaIndexProvider(fs, directoryFactory, graphDbDir, (LogProvider)NullLogProvider.getInstance(), config, OperationalMode.single);
    }
}

