/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.impl.index.LuceneAllDocumentsReader;
import org.neo4j.kernel.api.impl.schema.LuceneDocumentStructure;
import org.neo4j.kernel.api.impl.schema.LuceneIndexAccessor;
import org.neo4j.kernel.api.impl.schema.LuceneSchemaIndexBuilder;
import org.neo4j.kernel.api.impl.schema.SchemaIndex;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.schema_new.LabelSchemaSupplier;
import org.neo4j.kernel.api.schema_new.index.NewIndexDescriptor;
import org.neo4j.kernel.api.schema_new.index.NewIndexDescriptorFactory;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class LuceneSchemaIndexIT {
    @Rule
    public TestDirectory testDir = TestDirectory.testDirectory();
    @Rule
    public final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    private NewIndexDescriptor descriptor = NewIndexDescriptorFactory.forLabel((int)0, (int[])new int[]{0});

    @Before
    public void before() throws Exception {
        System.setProperty("luceneSchemaIndex.maxPartitionSize", "10");
    }

    @After
    public void after() throws IOException {
        System.setProperty("luceneSchemaIndex.maxPartitionSize", "");
    }

    @Test
    public void snapshotForPartitionedIndex() throws Exception {
        try (LuceneIndexAccessor indexAccessor = this.createDefaultIndexAccessor();){
            this.generateUpdates(indexAccessor, 32);
            indexAccessor.force();
            List<String> singlePartitionFileTemplates = Arrays.asList(".cfe", ".cfs", ".si", "segments_1");
            try (ResourceIterator snapshotIterator = indexAccessor.snapshotFiles();){
                List<String> indexFileNames = this.asFileInsidePartitionNames((ResourceIterator<File>)snapshotIterator);
                Assert.assertTrue((String)"Expect files from 4 partitions", (indexFileNames.size() >= singlePartitionFileTemplates.size() * 4 ? 1 : 0) != 0);
                Map<String, Integer> templateMatches = this.countTemplateMatches(singlePartitionFileTemplates, indexFileNames);
                for (String fileTemplate : singlePartitionFileTemplates) {
                    Integer matches = templateMatches.get(fileTemplate);
                    Assert.assertTrue((String)("Expect to see at least 4 matches for template: " + fileTemplate), (matches >= 4 ? 1 : 0) != 0);
                }
            }
        }
    }

    @Test
    public void snapshotForIndexWithNoCommits() throws Exception {
        try (LuceneIndexAccessor indexAccessor = this.createDefaultIndexAccessor();
             ResourceIterator snapshotIterator = indexAccessor.snapshotFiles();){
            Assert.assertThat(this.asUniqueSetOfNames((ResourceIterator<File>)snapshotIterator), (Matcher)IsEqual.equalTo((Object)Iterators.emptySetOf(String.class)));
        }
    }

    @Test
    public void updateMultiplePartitionedIndex() throws IOException, IndexEntryConflictException {
        try (SchemaIndex index = ((LuceneSchemaIndexBuilder)((LuceneSchemaIndexBuilder)((LuceneSchemaIndexBuilder)LuceneSchemaIndexBuilder.create((NewIndexDescriptor)this.descriptor).withFileSystem(this.fileSystemRule.get())).withIndexRootFolder(this.testDir.directory())).withIndexIdentifier("partitionedIndexForUpdates")).build();){
            index.create();
            index.open();
            this.addDocumentToIndex(index, 45);
            index.getIndexWriter().updateDocument(LuceneDocumentStructure.newTermForChangeOrRemove((long)100L), LuceneDocumentStructure.documentRepresentingProperties((long)100L, (Object[])new Object[]{100}));
            index.maybeRefreshBlocking();
            long documentsInIndex = Iterators.count((Iterator)index.allDocumentsReader().iterator());
            Assert.assertEquals((String)"Index should contain 45 added and 1 updated document.", (long)46L, (long)documentsInIndex);
        }
    }

    @Test
    public void createPopulateDropIndex() throws Exception {
        File crudOperation = this.testDir.directory("indexCRUDOperation");
        try (SchemaIndex crudIndex = ((LuceneSchemaIndexBuilder)((LuceneSchemaIndexBuilder)((LuceneSchemaIndexBuilder)LuceneSchemaIndexBuilder.create((NewIndexDescriptor)this.descriptor).withFileSystem(this.fileSystemRule.get())).withIndexRootFolder(crudOperation)).withIndexIdentifier("crudIndex")).build();){
            crudIndex.open();
            this.addDocumentToIndex(crudIndex, 1);
            Assert.assertEquals((long)1L, (long)crudIndex.getPartitions().size());
            this.addDocumentToIndex(crudIndex, 21);
            Assert.assertEquals((long)3L, (long)crudIndex.getPartitions().size());
            crudIndex.drop();
            Assert.assertFalse((boolean)crudIndex.isOpen());
            Assert.assertEquals((long)0L, (long)crudOperation.list().length);
        }
    }

    @Test
    public void createFailPartitionedIndex() throws Exception {
        try (SchemaIndex failedIndex = ((LuceneSchemaIndexBuilder)((LuceneSchemaIndexBuilder)((LuceneSchemaIndexBuilder)LuceneSchemaIndexBuilder.create((NewIndexDescriptor)this.descriptor).withFileSystem(this.fileSystemRule.get())).withIndexRootFolder(this.testDir.directory("failedIndexFolder"))).withIndexIdentifier("failedIndex")).build();){
            failedIndex.open();
            this.addDocumentToIndex(failedIndex, 35);
            Assert.assertEquals((long)4L, (long)failedIndex.getPartitions().size());
            failedIndex.markAsFailed("Some failure");
            failedIndex.flush();
            Assert.assertTrue((boolean)failedIndex.isOpen());
            Assert.assertFalse((boolean)failedIndex.isOnline());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void openClosePartitionedIndex() throws IOException {
        try (SchemaIndex reopenIndex = null;){
            reopenIndex = ((LuceneSchemaIndexBuilder)((LuceneSchemaIndexBuilder)((LuceneSchemaIndexBuilder)LuceneSchemaIndexBuilder.create((NewIndexDescriptor)this.descriptor).withFileSystem(this.fileSystemRule.get())).withIndexRootFolder(this.testDir.directory("reopenIndexFolder"))).withIndexIdentifier("reopenIndex")).build();
            reopenIndex.open();
            this.addDocumentToIndex(reopenIndex, 1);
            reopenIndex.close();
            Assert.assertFalse((boolean)reopenIndex.isOpen());
            reopenIndex.open();
            Assert.assertTrue((boolean)reopenIndex.isOpen());
            this.addDocumentToIndex(reopenIndex, 10);
            reopenIndex.close();
            Assert.assertFalse((boolean)reopenIndex.isOpen());
            reopenIndex.open();
            Assert.assertTrue((boolean)reopenIndex.isOpen());
            reopenIndex.close();
            reopenIndex.open();
            this.addDocumentToIndex(reopenIndex, 100);
            reopenIndex.maybeRefreshBlocking();
            try (LuceneAllDocumentsReader allDocumentsReader = reopenIndex.allDocumentsReader();){
                Assert.assertEquals((String)"All documents should be visible", (long)111L, (long)allDocumentsReader.maxCount());
            }
        }
    }

    private void addDocumentToIndex(SchemaIndex index, int documents) throws IOException {
        for (int i = 0; i < documents; ++i) {
            index.getIndexWriter().addDocument(LuceneDocumentStructure.documentRepresentingProperties((long)i, (Object[])new Object[]{i}));
        }
    }

    private LuceneIndexAccessor createDefaultIndexAccessor() throws IOException {
        SchemaIndex index = ((LuceneSchemaIndexBuilder)((LuceneSchemaIndexBuilder)((LuceneSchemaIndexBuilder)LuceneSchemaIndexBuilder.create((NewIndexDescriptor)this.descriptor).withFileSystem(this.fileSystemRule.get())).withIndexRootFolder(this.testDir.directory())).withIndexIdentifier("testIndex")).build();
        index.create();
        index.open();
        return new LuceneIndexAccessor(index, this.descriptor);
    }

    private Map<String, Integer> countTemplateMatches(List<String> nameTemplates, List<String> fileNames) {
        HashMap<String, Integer> templateMatches = new HashMap<String, Integer>();
        for (String indexFileName : fileNames) {
            for (String template : nameTemplates) {
                if (!indexFileName.endsWith(template)) continue;
                templateMatches.put(template, templateMatches.getOrDefault(template, 0) + 1);
            }
        }
        return templateMatches;
    }

    private List<String> asFileInsidePartitionNames(ResourceIterator<File> resources) {
        int testDirectoryPathLength = this.testDir.directory().getAbsolutePath().length();
        return Iterators.asList(resources).stream().map(file -> file.getAbsolutePath().substring(testDirectoryPathLength)).collect(Collectors.toList());
    }

    private Set<String> asUniqueSetOfNames(ResourceIterator<File> files) {
        ArrayList<String> out = new ArrayList<String>();
        while (files.hasNext()) {
            String name = ((File)files.next()).getName();
            out.add(name);
        }
        return Iterables.asUniqueSet(out);
    }

    private void generateUpdates(LuceneIndexAccessor indexAccessor, int nodesToUpdate) throws IOException, IndexEntryConflictException {
        try (IndexUpdater updater = indexAccessor.newUpdater(IndexUpdateMode.ONLINE);){
            for (int nodeId = 0; nodeId < nodesToUpdate; ++nodeId) {
                updater.process(this.add(nodeId, nodeId));
            }
        }
    }

    private IndexEntryUpdate add(long nodeId, Object value) {
        return IndexEntryUpdate.add((long)nodeId, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{value});
    }
}

