/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import org.apache.lucene.index.CorruptIndexException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.impl.index.storage.DirectoryFactory;
import org.neo4j.kernel.api.impl.index.storage.IndexStorageFactory;
import org.neo4j.kernel.api.impl.index.storage.PartitionedIndexStorage;
import org.neo4j.kernel.api.impl.schema.LuceneSchemaIndexProvider;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.schema_new.index.NewIndexDescriptor;
import org.neo4j.kernel.api.schema_new.index.NewIndexDescriptorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.OperationalMode;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class LuceneSchemaIndexCorruptionTest {
    @Rule
    public final TestDirectory testDirectory = TestDirectory.testDirectory();
    @Rule
    public final EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    private final AssertableLogProvider logProvider = new AssertableLogProvider();

    @Test
    public void shouldRequestIndexPopulationIfTheIndexIsCorrupt() throws Exception {
        long faultyIndexId = 1L;
        CorruptIndexException error = new CorruptIndexException("It's broken.", "");
        LuceneSchemaIndexProvider provider = this.newFaultySchemaIndexProvider(faultyIndexId, (Exception)error);
        NewIndexDescriptor descriptor = NewIndexDescriptorFactory.forLabel((int)1, (int[])new int[]{1});
        InternalIndexState initialState = provider.getInitialState(faultyIndexId, descriptor);
        Assert.assertThat((Object)initialState, (Matcher)CoreMatchers.equalTo((Object)InternalIndexState.POPULATING));
        this.logProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{LuceneSchemaIndexCorruptionTest.loggedException((Throwable)error)});
    }

    @Test
    public void shouldRequestIndexPopulationFailingWithFileNotFoundException() throws Exception {
        long faultyIndexId = 1L;
        FileNotFoundException error = new FileNotFoundException("/some/path/somewhere");
        LuceneSchemaIndexProvider provider = this.newFaultySchemaIndexProvider(faultyIndexId, error);
        NewIndexDescriptor descriptor = NewIndexDescriptorFactory.forLabel((int)1, (int[])new int[]{1});
        InternalIndexState initialState = provider.getInitialState(faultyIndexId, descriptor);
        Assert.assertThat((Object)initialState, (Matcher)CoreMatchers.equalTo((Object)InternalIndexState.POPULATING));
        this.logProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{LuceneSchemaIndexCorruptionTest.loggedException(error)});
    }

    @Test
    public void shouldRequestIndexPopulationWhenFailingWithEOFException() throws Exception {
        long faultyIndexId = 1L;
        EOFException error = new EOFException("/some/path/somewhere");
        LuceneSchemaIndexProvider provider = this.newFaultySchemaIndexProvider(faultyIndexId, error);
        NewIndexDescriptor descriptor = NewIndexDescriptorFactory.forLabel((int)1, (int[])new int[]{1});
        InternalIndexState initialState = provider.getInitialState(faultyIndexId, descriptor);
        Assert.assertThat((Object)initialState, (Matcher)CoreMatchers.equalTo((Object)InternalIndexState.POPULATING));
        this.logProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{LuceneSchemaIndexCorruptionTest.loggedException(error)});
    }

    private LuceneSchemaIndexProvider newFaultySchemaIndexProvider(long faultyIndexId, Exception error) {
        DirectoryFactory directoryFactory = (DirectoryFactory)Mockito.mock(DirectoryFactory.class);
        File indexRootFolder = this.testDirectory.graphDbDir();
        final FaultyIndexStorageFactory storageFactory = new FaultyIndexStorageFactory(faultyIndexId, error, directoryFactory, indexRootFolder);
        return new LuceneSchemaIndexProvider(this.fs.get(), directoryFactory, indexRootFolder, (LogProvider)this.logProvider, Config.defaults(), OperationalMode.single){

            protected IndexStorageFactory buildIndexStorageFactory(FileSystemAbstraction fileSystem, DirectoryFactory directoryFactory, File schemaIndexStoreFolder) {
                return storageFactory;
            }
        };
    }

    private static AssertableLogProvider.LogMatcher loggedException(Throwable exception) {
        return AssertableLogProvider.inLog((Matcher)CoreMatchers.any(String.class)).error(CoreMatchers.any(String.class), CoreMatchers.sameInstance((Object)exception));
    }

    private class FaultyIndexStorageFactory
    extends IndexStorageFactory {
        final long faultyIndexId;
        final Exception error;

        FaultyIndexStorageFactory(long faultyIndexId, Exception error, DirectoryFactory directoryFactory, File indexRootFolder) {
            super(directoryFactory, LuceneSchemaIndexCorruptionTest.this.fs.get(), indexRootFolder);
            this.faultyIndexId = faultyIndexId;
            this.error = error;
        }

        public PartitionedIndexStorage indexStorageOf(long indexId, boolean archiveFailed) {
            return indexId == this.faultyIndexId ? this.newFaultyPartitionedIndexStorage() : super.indexStorageOf(indexId, archiveFailed);
        }

        PartitionedIndexStorage newFaultyPartitionedIndexStorage() {
            try {
                PartitionedIndexStorage storage = (PartitionedIndexStorage)Mockito.mock(PartitionedIndexStorage.class);
                Mockito.when((Object)storage.listFolders()).thenReturn(Collections.singletonList(new File("/some/path/somewhere/1")));
                Mockito.when((Object)storage.openDirectory((File)Matchers.any())).thenThrow(new Throwable[]{this.error});
                return storage;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

