/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.api.impl.schema.LuceneSchemaIndexBuilder;
import org.neo4j.kernel.api.impl.schema.SchemaIndex;
import org.neo4j.kernel.api.schema_new.index.NewIndexDescriptor;
import org.neo4j.kernel.api.schema_new.index.NewIndexDescriptorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.OperationalMode;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class LuceneSchemaIndexBuilderTest {
    @Rule
    public final TestDirectory testDir = TestDirectory.testDirectory();
    @Rule
    public final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    private final NewIndexDescriptor descriptor = NewIndexDescriptorFactory.forLabel((int)0, (int[])new int[]{0});

    @Test
    public void readOnlyIndexCreation() throws Exception {
        try (SchemaIndex schemaIndex = ((LuceneSchemaIndexBuilder)((LuceneSchemaIndexBuilder)((LuceneSchemaIndexBuilder)((LuceneSchemaIndexBuilder)((LuceneSchemaIndexBuilder)LuceneSchemaIndexBuilder.create((NewIndexDescriptor)this.descriptor).withFileSystem(this.fileSystemRule.get())).withConfig(this.getReadOnlyConfig())).withOperationalMode(OperationalMode.single)).withIndexRootFolder(this.testDir.graphDbDir())).withIndexIdentifier("a")).build();){
            Assert.assertTrue((String)"Builder should construct read only index.", (boolean)schemaIndex.isReadOnly());
        }
    }

    @Test
    public void writableIndexCreation() throws Exception {
        try (SchemaIndex schemaIndex = ((LuceneSchemaIndexBuilder)((LuceneSchemaIndexBuilder)((LuceneSchemaIndexBuilder)((LuceneSchemaIndexBuilder)((LuceneSchemaIndexBuilder)LuceneSchemaIndexBuilder.create((NewIndexDescriptor)this.descriptor).withConfig(this.getDefaultConfig())).withFileSystem(this.fileSystemRule.get())).withOperationalMode(OperationalMode.single)).withIndexRootFolder(this.testDir.graphDbDir())).withIndexIdentifier("b")).build();){
            Assert.assertFalse((String)"Builder should construct writable index.", (boolean)schemaIndex.isReadOnly());
        }
    }

    private Config getDefaultConfig() {
        return Config.empty();
    }

    private Config getReadOnlyConfig() {
        return this.getDefaultConfig().with(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.read_only.name(), "true"}));
    }
}

