/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.labelscan.reader;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.kernel.api.impl.index.partition.PartitionSearcher;
import org.neo4j.kernel.api.impl.labelscan.reader.PartitionedLuceneLabelScanStoreReader;
import org.neo4j.kernel.api.impl.labelscan.storestrategy.LabelScanStorageStrategy;
import org.neo4j.storageengine.api.schema.LabelScanReader;

@RunWith(value=MockitoJUnitRunner.class)
public class PartitionedLuceneLabelScanStoreReaderTest {
    @Mock
    private LabelScanStorageStrategy scanStorageStrategy;
    @Mock
    private PartitionSearcher partitionSearcher1;
    @Mock
    private PartitionSearcher partitionSearcher2;
    @Mock
    private PartitionSearcher partitionSearcher3;
    @Mock
    private LabelScanReader indexReader1;
    @Mock
    private LabelScanReader indexReader2;
    @Mock
    private LabelScanReader indexReader3;

    @Test
    public void partitionedReaderCloseAllSearchers() throws IOException {
        PartitionedLuceneLabelScanStoreReader partitionedIndexReader = this.createPartitionedReader();
        partitionedIndexReader.close();
        ((PartitionSearcher)Mockito.verify((Object)this.partitionSearcher1)).close();
        ((PartitionSearcher)Mockito.verify((Object)this.partitionSearcher2)).close();
        ((PartitionSearcher)Mockito.verify((Object)this.partitionSearcher3)).close();
    }

    @Test
    public void nodesWithLabelOverPartitions() {
        PartitionedLuceneLabelScanStoreReader storeReader = this.createPartitionedReaderWithReaders();
        Mockito.when((Object)this.indexReader1.nodesWithLabel(1)).thenReturn((Object)PrimitiveLongCollections.iterator((long[])new long[]{1L}));
        Mockito.when((Object)this.indexReader2.nodesWithLabel(1)).thenReturn((Object)PrimitiveLongCollections.iterator((long[])new long[]{2L}));
        Mockito.when((Object)this.indexReader3.nodesWithLabel(1)).thenReturn((Object)PrimitiveLongCollections.iterator((long[])new long[]{3L}));
        PrimitiveLongSet result = PrimitiveLongCollections.asSet((PrimitiveLongIterator)storeReader.nodesWithLabel(1));
        this.verifyResult(result);
    }

    private void verifyResult(PrimitiveLongSet results) {
        Assert.assertEquals((long)3L, (long)results.size());
        Assert.assertTrue((boolean)results.contains(1L));
        Assert.assertTrue((boolean)results.contains(2L));
        Assert.assertTrue((boolean)results.contains(3L));
    }

    private PartitionedLuceneLabelScanStoreReader createPartitionedReaderWithReaders() {
        return new PartitionedLuceneLabelScanStoreReader(this.getLabelScanReaders());
    }

    private List<LabelScanReader> getLabelScanReaders() {
        return Arrays.asList(this.indexReader1, this.indexReader2, this.indexReader3);
    }

    private PartitionedLuceneLabelScanStoreReader createPartitionedReader() {
        return new PartitionedLuceneLabelScanStoreReader(this.getPartitionSearchers(), this.scanStorageStrategy);
    }

    private List<PartitionSearcher> getPartitionSearchers() {
        return Arrays.asList(this.partitionSearcher1, this.partitionSearcher2, this.partitionSearcher3);
    }
}

