/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.labelscan.bitmaps;

import java.util.Arrays;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.api.impl.labelscan.bitmaps.LongPageIterator;

public class LongPageIteratorTest {
    @Test
    public void shouldIterateThroughEachLongInEachPage() throws Exception {
        LongPageIterator iterator = new LongPageIterator(Arrays.asList({1L, 2L, 3L}, {4L, 5L}).iterator());
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((long)1L, (long)iterator.next());
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((long)2L, (long)iterator.next());
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((long)3L, (long)iterator.next());
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((long)4L, (long)iterator.next());
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((long)5L, (long)iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void shouldNotGetAnythingFromEmptySourceIterator() throws Exception {
        LongPageIterator iterator = new LongPageIterator(Collections.emptyList().iterator());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void shouldNotGetAnythingFromSourceIteratorOfEmptyLongArrays() throws Exception {
        LongPageIterator iterator = new LongPageIterator(Arrays.asList(new long[0], new long[0]).iterator());
        Assert.assertFalse((boolean)iterator.hasNext());
    }
}

