/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.labelscan.bitmaps;

import java.util.HashSet;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.api.impl.labelscan.bitmaps.Bitmap;
import org.neo4j.kernel.api.impl.labelscan.bitmaps.BitmapFormat;

public class BitmapFormatTest {
    @Test
    public void shouldConvertRangeAndBitmapToArray_32() throws Exception {
        for (int i = 0; i < 32; ++i) {
            long[] longs = BitmapFormat._32.convertRangeAndBitmapToArray(16L, 1L << i);
            Assert.assertArrayEquals((long[])new long[]{512 + i}, (long[])longs);
        }
        long[] longs = BitmapFormat._32.convertRangeAndBitmapToArray(13L, -1L);
        long[] expected = new long[32];
        for (int i = 0; i < expected.length; ++i) {
            expected[i] = 416 + i;
        }
        Assert.assertArrayEquals((long[])expected, (long[])longs);
    }

    @Test
    public void shouldConvertRangeAndBitmapToArray_64() throws Exception {
        for (int i = 0; i < 64; ++i) {
            long[] longs = BitmapFormat._64.convertRangeAndBitmapToArray(11L, 1L << i);
            Assert.assertArrayEquals((long[])new long[]{704 + i}, (long[])longs);
        }
        long[] longs = BitmapFormat._64.convertRangeAndBitmapToArray(19L, -1L);
        long[] expected = new long[64];
        for (int i = 0; i < expected.length; ++i) {
            expected[i] = 1216 + i;
        }
        Assert.assertArrayEquals((long[])expected, (long[])longs);
    }

    @Test
    public void shouldSetBitmap_32() throws Exception {
        HashSet<Long> bitmaps = new HashSet<Long>();
        for (int i = 0; i < 32; ++i) {
            Bitmap bitmap = new Bitmap();
            BitmapFormat._32.set(bitmap, (long)i, true);
            Assert.assertEquals((String)("set i=" + i), (long)1L, (long)Long.bitCount(bitmap.bitmap()));
            bitmaps.add(bitmap.bitmap());
            BitmapFormat._32.set(bitmap, (long)i, false);
            Assert.assertEquals((String)("unset i=" + i), (long)0L, (long)bitmap.bitmap());
        }
        Assert.assertEquals((String)"each value is unique", (long)32L, (long)bitmaps.size());
    }

    @Test
    public void shouldSetBitmap_64() throws Exception {
        HashSet<Long> bitmaps = new HashSet<Long>();
        for (int i = 0; i < 64; ++i) {
            Bitmap bitmap = new Bitmap();
            BitmapFormat._64.set(bitmap, (long)i, true);
            Assert.assertEquals((String)("set i=" + i), (long)1L, (long)Long.bitCount(bitmap.bitmap()));
            bitmaps.add(bitmap.bitmap());
            BitmapFormat._64.set(bitmap, (long)i, false);
            Assert.assertEquals((String)("unset i=" + i), (long)0L, (long)bitmap.bitmap());
        }
        Assert.assertEquals((String)"each value is unique", (long)64L, (long)bitmaps.size());
    }

    @Test
    public void shouldBeAbleToCheckIfASingleNodeIdIsSet_32() throws Exception {
        for (int input = 0; input < 32; ++input) {
            Bitmap bitmap = new Bitmap();
            BitmapFormat._32.set(bitmap, (long)input, true);
            Assert.assertThat((Object)BitmapFormat._32.hasLabel(bitmap.bitmap(), (long)input), (Matcher)Is.is((Object)true));
            for (int check = 0; check < 32; ++check) {
                Assert.assertThat((Object)BitmapFormat._32.hasLabel(bitmap.bitmap(), (long)check), (Matcher)Is.is((Object)(input == check ? 1 : 0)));
            }
        }
    }

    @Test
    public void shouldBeAbleToCheckIfASingleNodeIdIsSet_64() throws Exception {
        for (int input = 0; input < 64; ++input) {
            Bitmap bitmap = new Bitmap();
            BitmapFormat._64.set(bitmap, (long)input, true);
            Assert.assertThat((Object)BitmapFormat._64.hasLabel(bitmap.bitmap(), (long)input), (Matcher)Is.is((Object)true));
            for (int check = 0; check < 64; ++check) {
                Assert.assertThat((Object)BitmapFormat._64.hasLabel(bitmap.bitmap(), (long)check), (Matcher)Is.is((Object)(input == check ? 1 : 0)));
            }
        }
    }
}

