/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.labelscan.bitmaps;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.api.impl.labelscan.bitmaps.BitmapExtractor;
import org.neo4j.kernel.api.impl.labelscan.bitmaps.BitmapFormat;

public class BitmapExtractorTest {
    @Test
    public void shouldIterateOverAllIdsInPage() throws Exception {
        int i;
        BitmapExtractor pages = new BitmapExtractor(BitmapFormat._64, new long[]{0L, -1L, 2L, -1L});
        long[] expected = new long[64];
        for (i = 0; i < expected.length; ++i) {
            expected[i] = i;
        }
        Assert.assertTrue((boolean)pages.hasNext());
        Assert.assertArrayEquals((long[])expected, (long[])((long[])pages.next()));
        for (i = 0; i < expected.length; ++i) {
            expected[i] = 128 + i;
        }
        Assert.assertTrue((boolean)pages.hasNext());
        Assert.assertArrayEquals((long[])expected, (long[])((long[])pages.next()));
        Assert.assertFalse((boolean)pages.hasNext());
    }

    @Test
    public void shouldYieldNothingForEmptyPages() throws Exception {
        BitmapExtractor pages = new BitmapExtractor(BitmapFormat._64, new long[]{0L, 0L, 1L, 0L, 2L, 0L, 3L, 0L, 4L, 0L, 5L, 0L, 6L, 0L, 7L, 0L});
        Assert.assertFalse((boolean)pages.hasNext());
    }

    @Test
    public void shouldYieldCorrectBitFromEachPage() throws Exception {
        long[] rangeBitmap = new long[128];
        for (int i = 0; i < 64; ++i) {
            rangeBitmap[i * 2] = i;
            rangeBitmap[i * 2 + 1] = 1L << i;
        }
        BitmapExtractor pages = new BitmapExtractor(BitmapFormat._64, rangeBitmap);
        for (int i = 0; i < 64; ++i) {
            Assert.assertArrayEquals((String)("page:" + i), (long[])new long[]{64 * i + i}, (long[])((long[])pages.next()));
        }
        Assert.assertFalse((boolean)pages.hasNext());
    }

    @Test
    public void shouldHandle32BitBitmaps() throws Exception {
        BitmapExtractor pages = new BitmapExtractor(BitmapFormat._32, new long[]{255L, 0x180000000L});
        Assert.assertArrayEquals((long[])new long[]{8191L}, (long[])((long[])pages.next()));
        Assert.assertFalse((boolean)pages.hasNext());
    }
}

