/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.labelscan;

import java.io.IOException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.kernel.api.impl.index.storage.DirectoryFactory;
import org.neo4j.kernel.api.impl.index.storage.PartitionedIndexStorage;
import org.neo4j.kernel.api.impl.labelscan.ReadOnlyDatabaseLabelScanIndex;
import org.neo4j.kernel.api.impl.labelscan.storestrategy.BitmapDocumentFormat;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class ReadOnlyLuceneLabelScanIndexTest {
    private final TestDirectory testDirectory = TestDirectory.testDirectory();
    private final ExpectedException expectedException = ExpectedException.none();
    private final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    @Rule
    public final RuleChain ruleChain = RuleChain.outerRule((TestRule)this.testDirectory).around((TestRule)this.expectedException).around((TestRule)this.fileSystemRule);
    private ReadOnlyDatabaseLabelScanIndex luceneLabelScanIndex;

    @Before
    public void setUp() {
        PartitionedIndexStorage indexStorage = new PartitionedIndexStorage(DirectoryFactory.PERSISTENT, this.fileSystemRule.get(), this.testDirectory.directory(), "1", false);
        this.luceneLabelScanIndex = new ReadOnlyDatabaseLabelScanIndex(BitmapDocumentFormat._32, indexStorage);
    }

    @After
    public void tearDown() throws IOException {
        this.luceneLabelScanIndex.close();
    }

    @Test
    public void readOnlyIndexMode() throws Exception {
        Assert.assertTrue((boolean)this.luceneLabelScanIndex.isReadOnly());
    }

    @Test
    public void writerIsNotAccessibleInReadOnlyMode() throws Exception {
        this.expectedException.expect(UnsupportedOperationException.class);
        this.luceneLabelScanIndex.getLabelScanWriter();
    }

    @Test
    public void indexCreationInReadOnlyModeIsNotSupported() throws Exception {
        this.expectedException.expect(UnsupportedOperationException.class);
        this.luceneLabelScanIndex.create();
    }

    @Test
    public void indexDeletionInReadOnlyModeIsNotSupported() throws Exception {
        this.expectedException.expect(UnsupportedOperationException.class);
        this.luceneLabelScanIndex.drop();
    }
}

