/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.labelscan;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Stream;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.kernel.api.impl.index.IndexReaderStub;
import org.neo4j.kernel.api.impl.index.IndexWriterConfigs;
import org.neo4j.kernel.api.impl.index.partition.AbstractIndexPartition;
import org.neo4j.kernel.api.impl.index.partition.PartitionSearcher;
import org.neo4j.kernel.api.impl.index.partition.WritableIndexPartition;
import org.neo4j.kernel.api.impl.index.storage.DirectoryFactory;
import org.neo4j.kernel.api.impl.labelscan.WritableDatabaseLabelScanIndex;
import org.neo4j.kernel.api.impl.labelscan.storestrategy.BitmapDocumentFormat;
import org.neo4j.kernel.api.impl.labelscan.writer.PartitionedLuceneLabelScanWriter;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.test.rule.TestDirectory;

@RunWith(value=Parameterized.class)
public class LuceneLabelScanStoreWriterTest {
    @Parameterized.Parameter
    public BitmapDocumentFormat format;
    @Rule
    public final TestDirectory testDir = TestDirectory.testDirectory();
    private final DirectoryFactory dirFactory = new DirectoryFactory.InMemoryDirectoryFactory();

    /*
     * Exception decompiling
     */
    @Parameterized.Parameters(name="{0} bits")
    public static List<Object[]> formats() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @After
    public void closeDirFactory() throws Exception {
        System.setProperty("labelScanStore.maxPartitionSize", "");
        this.dirFactory.close();
    }

    @Test
    public void shouldComplainIfNodesSuppliedOutOfRangeOrder() throws Exception {
        int nodeId1 = 1;
        int nodeId2 = 65;
        StubIndexPartition partition = this.newStubIndexPartition();
        WritableDatabaseLabelScanIndex index = this.prepareIndex(Collections.singletonList(partition));
        long node1Range = this.format.bitmapFormat().rangeOf((long)nodeId1);
        long node2Range = this.format.bitmapFormat().rangeOf((long)nodeId2);
        Assert.assertNotEquals((long)node1Range, (long)node2Range);
        PartitionedLuceneLabelScanWriter writer = this.createWriter(index);
        writer.write(NodeLabelUpdate.labelChanges((long)nodeId2, (long[])new long[0], (long[])new long[0]));
        try {
            writer.write(NodeLabelUpdate.labelChanges((long)nodeId1, (long[])new long[0], (long[])new long[0]));
            Assert.fail((String)"Should have thrown exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void shouldStoreDocumentWithNodeIdsAndLabelsInIt() throws Exception {
        int nodeId = 1;
        int label1 = 201;
        int label2 = 202;
        StubIndexPartition partition = this.newStubIndexPartition();
        WritableDatabaseLabelScanIndex index = this.buildLabelScanIndex(partition);
        PartitionedLuceneLabelScanWriter writer = this.createWriter(index);
        writer.write(NodeLabelUpdate.labelChanges((long)nodeId, (long[])new long[0], (long[])new long[]{label1, label2}));
        writer.close();
        long range = this.format.bitmapFormat().rangeOf((long)nodeId);
        Document document = partition.documentFor(new Term("range", String.valueOf(range)));
        Assert.assertTrue((boolean)this.format.bitmapFormat().hasLabel(Long.parseLong(document.get(String.valueOf(label1))), (long)nodeId));
        Assert.assertTrue((boolean)this.format.bitmapFormat().hasLabel(Long.parseLong(document.get(String.valueOf(label2))), (long)nodeId));
    }

    @Test
    public void shouldStoreDocumentWithNodeIdsInTheSameRange() throws Exception {
        int nodeId1 = 1;
        int nodeId2 = 3;
        int label1 = 201;
        int label2 = 202;
        StubIndexPartition partition = this.newStubIndexPartition();
        long range = this.format.bitmapFormat().rangeOf((long)nodeId1);
        Assert.assertEquals((long)range, (long)this.format.bitmapFormat().rangeOf((long)nodeId2));
        WritableDatabaseLabelScanIndex index = this.buildLabelScanIndex(partition);
        PartitionedLuceneLabelScanWriter writer = this.createWriter(index);
        writer.write(NodeLabelUpdate.labelChanges((long)nodeId1, (long[])new long[0], (long[])new long[]{label1}));
        writer.write(NodeLabelUpdate.labelChanges((long)nodeId2, (long[])new long[0], (long[])new long[]{label2}));
        writer.close();
        Document document = partition.documentFor(new Term("range", String.valueOf(range)));
        Assert.assertTrue((boolean)this.format.bitmapFormat().hasLabel(Long.parseLong(document.get(String.valueOf(label1))), (long)nodeId1));
        Assert.assertTrue((boolean)this.format.bitmapFormat().hasLabel(Long.parseLong(document.get(String.valueOf(label2))), (long)nodeId2));
    }

    @Test
    public void shouldStoreDocumentWithNodeIdsInADifferentRange() throws Exception {
        int nodeId1 = 1;
        int nodeId2 = 65;
        int label1 = 201;
        int label2 = 202;
        StubIndexPartition partition = this.newStubIndexPartition();
        long node1Range = this.format.bitmapFormat().rangeOf((long)nodeId1);
        long node2Range = this.format.bitmapFormat().rangeOf((long)nodeId2);
        Assert.assertNotEquals((long)node1Range, (long)node2Range);
        WritableDatabaseLabelScanIndex index = this.buildLabelScanIndex(partition);
        PartitionedLuceneLabelScanWriter writer = this.createWriter(index);
        writer.write(NodeLabelUpdate.labelChanges((long)nodeId1, (long[])new long[0], (long[])new long[]{label1}));
        writer.write(NodeLabelUpdate.labelChanges((long)nodeId2, (long[])new long[0], (long[])new long[]{label2}));
        writer.close();
        Document document1 = partition.documentFor(new Term("range", String.valueOf(node1Range)));
        Assert.assertTrue((boolean)this.format.bitmapFormat().hasLabel(Long.parseLong(document1.get(String.valueOf(label1))), (long)nodeId1));
        Document document2 = partition.documentFor(new Term("range", String.valueOf(node2Range)));
        Assert.assertTrue((boolean)this.format.bitmapFormat().hasLabel(Long.parseLong(document2.get(String.valueOf(label2))), (long)nodeId2));
    }

    @Test
    public void shouldUpdateExistingDocumentWithNodesInTheSameRange() throws Exception {
        int nodeId1 = 1;
        int nodeId2 = 3;
        int label1 = 201;
        int label2 = 202;
        StubIndexPartition partition = this.newStubIndexPartition();
        long range = this.format.bitmapFormat().rangeOf((long)nodeId1);
        Assert.assertEquals((long)range, (long)this.format.bitmapFormat().rangeOf((long)nodeId2));
        WritableDatabaseLabelScanIndex index = this.buildLabelScanIndex(partition);
        PartitionedLuceneLabelScanWriter writer = this.createWriter(index);
        writer.write(NodeLabelUpdate.labelChanges((long)nodeId1, (long[])new long[0], (long[])new long[]{label1}));
        writer.close();
        writer = this.createWriter(index);
        writer.write(NodeLabelUpdate.labelChanges((long)nodeId2, (long[])new long[0], (long[])new long[]{label2}));
        writer.close();
        Document document = partition.documentFor(new Term("range", String.valueOf(range)));
        Assert.assertTrue((boolean)this.format.bitmapFormat().hasLabel(Long.parseLong(document.get(String.valueOf(label1))), (long)nodeId1));
        Assert.assertTrue((boolean)this.format.bitmapFormat().hasLabel(Long.parseLong(document.get(String.valueOf(label2))), (long)nodeId2));
    }

    @Test
    public void automaticPartitionCreation() throws IOException {
        int nodeForPartition1 = 1;
        int nodeForPartition2 = this.format.bitmapFormat().rangeSize() * 2 + 1;
        int labelNode1 = 201;
        int labelNode2 = 202;
        System.setProperty("labelScanStore.maxPartitionSize", "2");
        StubIndexPartition partition = this.newStubIndexPartition();
        WritableDatabaseLabelScanIndex index = this.buildLabelScanIndex(partition);
        PartitionedLuceneLabelScanWriter writer = this.createWriter(index);
        writer.write(NodeLabelUpdate.labelChanges((long)nodeForPartition1, (long[])new long[0], (long[])new long[]{labelNode1}));
        writer.write(NodeLabelUpdate.labelChanges((long)nodeForPartition2, (long[])new long[0], (long[])new long[]{labelNode2}));
        writer.close();
        Assert.assertEquals((String)"We should have 2 index partitions", (long)2L, (long)index.getPartitions().size());
    }

    private PartitionedLuceneLabelScanWriter createWriter(WritableDatabaseLabelScanIndex index) {
        return new PartitionedLuceneLabelScanWriter(index, this.format);
    }

    private StubIndexPartition newStubIndexPartition(File folder) {
        try {
            Directory directory = this.dirFactory.open(folder);
            return new StubIndexPartition(folder, directory);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private StubIndexPartition newStubIndexPartition() {
        File folder = this.testDir.directory();
        return this.newStubIndexPartition(folder);
    }

    private static PartitionSearcher newStubPartitionSearcher(Map<Term, Document> storage) {
        PartitionSearcher partitionSearcher = (PartitionSearcher)Mockito.mock(PartitionSearcher.class);
        Mockito.when((Object)partitionSearcher.getIndexSearcher()).thenReturn((Object)new StubIndexSearcher(storage));
        return partitionSearcher;
    }

    private static IndexWriter newStubIndexWriter(Map<Term, Document> storage) {
        IndexWriter writer = (IndexWriter)Mockito.mock(IndexWriter.class);
        try {
            ((IndexWriter)Mockito.doAnswer(invocation -> {
                Object[] args = invocation.getArguments();
                Term term = (Term)args[0];
                Iterable fields = (Iterable)args[1];
                Document document = new Document();
                fields.forEach(arg_0 -> ((Document)document).add(arg_0));
                storage.put(term, document);
                return null;
            }).when((Object)writer)).updateDocument((Term)Matchers.any(), (Iterable)Matchers.any());
            ((IndexWriter)Mockito.doAnswer(invocation -> {
                Term[] terms = (Term[])invocation.getArguments()[0];
                Stream.of(terms).forEach(storage::remove);
                return null;
            }).when((Object)writer)).deleteDocuments(new Term[]{(Term)Mockito.anyVararg()});
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return writer;
    }

    private WritableDatabaseLabelScanIndex buildLabelScanIndex(StubIndexPartition partition) throws IOException {
        ArrayList<AbstractIndexPartition> partitions = new ArrayList<AbstractIndexPartition>();
        partitions.add((AbstractIndexPartition)partition);
        WritableDatabaseLabelScanIndex index = this.prepareIndex(partitions);
        Mockito.when((Object)index.addNewPartition()).then(invocation -> {
            StubIndexPartition newPartition = this.newStubIndexPartition(this.testDir.directory(String.valueOf(partitions.size())));
            partitions.add((AbstractIndexPartition)newPartition);
            return newPartition;
        });
        return index;
    }

    private WritableDatabaseLabelScanIndex prepareIndex(List<AbstractIndexPartition> partitions) {
        WritableDatabaseLabelScanIndex index = (WritableDatabaseLabelScanIndex)Mockito.mock(WritableDatabaseLabelScanIndex.class);
        Mockito.when((Object)index.getPartitions()).thenReturn(partitions);
        return index;
    }

    private static class OneDocIdIterator
    extends DocIdSetIterator {
        final int target;
        int currentDoc = -1;
        boolean exhausted;

        OneDocIdIterator(int docId) {
            this.target = docId;
        }

        public int docID() {
            return this.currentDoc;
        }

        public int nextDoc() throws IOException {
            return this.advance(this.currentDoc + 1);
        }

        public int advance(int target) throws IOException {
            if (this.exhausted || target > this.target) {
                this.currentDoc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            this.exhausted = true;
            this.currentDoc = this.target;
            return this.currentDoc;
        }

        public long cost() {
            return 1L;
        }
    }

    private static class StubIndexSearcher
    extends IndexSearcher {
        final Map<Term, Document> storage;
        final Map<Integer, Document> docIds;

        StubIndexSearcher(Map<Term, Document> storage) {
            super((IndexReader)new IndexReaderStub(false, new String[0]));
            this.storage = storage;
            this.docIds = new HashMap<Integer, Document>();
        }

        public void search(Query query, Collector results) throws IOException {
            Document document = this.storage.get(((TermQuery)query).getTerm());
            if (document == null) {
                return;
            }
            int docId = ThreadLocalRandom.current().nextInt();
            this.docIds.put(docId, document);
            try {
                LeafCollector leafCollector = results.getLeafCollector((LeafReaderContext)this.leafContexts.get(0));
                ConstantScoreScorer scorer = new ConstantScoreScorer(null, 10.0f, (DocIdSetIterator)new OneDocIdIterator(docId));
                leafCollector.setScorer((Scorer)scorer);
                leafCollector.collect(docId);
            }
            catch (CollectionTerminatedException collectionTerminatedException) {
                // empty catch block
            }
        }

        public TopDocs search(Query query, int n) {
            Document document = this.storage.get(((TermQuery)query).getTerm());
            if (document == null) {
                return new TopDocs(0, new ScoreDoc[0], 0.0f);
            }
            int docId = ThreadLocalRandom.current().nextInt();
            this.docIds.put(docId, document);
            int score = 10;
            return new TopDocs(1, new ScoreDoc[]{new ScoreDoc(docId, (float)score)}, (float)score);
        }

        public Document doc(int docID) {
            return this.docIds.get(docID);
        }
    }

    private static class StubIndexPartition
    extends WritableIndexPartition {
        final Directory directory;
        final Map<Term, Document> storage = new HashMap<Term, Document>();

        StubIndexPartition(File folder, Directory directory) throws IOException {
            super(folder, directory, IndexWriterConfigs.standard());
            this.directory = directory;
        }

        public PartitionSearcher acquireSearcher() throws IOException {
            return LuceneLabelScanStoreWriterTest.newStubPartitionSearcher(this.storage);
        }

        public IndexWriter getIndexWriter() {
            return LuceneLabelScanStoreWriterTest.newStubIndexWriter(this.storage);
        }

        Document documentFor(Term term) {
            return this.storage.get(term);
        }
    }
}

