/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.labelscan;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.api.impl.labelscan.LabelScanIndex;
import org.neo4j.kernel.api.impl.labelscan.LuceneLabelScanIndexBuilder;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.OperationalMode;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class LuceneLabelScanIndexBuilderTest {
    @Rule
    public final TestDirectory testDir = TestDirectory.testDirectory(this.getClass());
    @Rule
    public final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();

    @Test
    public void readOnlyIndexCreation() throws Exception {
        try (LabelScanIndex index = ((LuceneLabelScanIndexBuilder)((LuceneLabelScanIndexBuilder)((LuceneLabelScanIndexBuilder)((LuceneLabelScanIndexBuilder)LuceneLabelScanIndexBuilder.create().withFileSystem(this.fileSystemRule.get())).withIndexRootFolder(this.testDir.graphDbDir())).withConfig(this.getReadOnlyConfig())).withOperationalMode(OperationalMode.single)).build();){
            Assert.assertTrue((String)"Builder should construct read only index.", (boolean)index.isReadOnly());
        }
    }

    @Test
    public void writableIndexCreation() throws Exception {
        try (LabelScanIndex index = ((LuceneLabelScanIndexBuilder)((LuceneLabelScanIndexBuilder)((LuceneLabelScanIndexBuilder)((LuceneLabelScanIndexBuilder)LuceneLabelScanIndexBuilder.create().withFileSystem(this.fileSystemRule.get())).withIndexRootFolder(this.testDir.graphDbDir())).withConfig(this.getDefaultConfig())).withOperationalMode(OperationalMode.single)).build();){
            Assert.assertFalse((String)"Builder should construct writable index.", (boolean)index.isReadOnly());
        }
    }

    private Config getDefaultConfig() {
        return Config.empty();
    }

    private Config getReadOnlyConfig() {
        return this.getDefaultConfig().with(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.read_only.name(), "true"}));
    }
}

