/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.verification;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ReferenceManager;
import org.apache.lucene.search.SearcherFactory;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.store.Directory;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.impl.index.IndexWriterConfigs;
import org.neo4j.kernel.api.impl.index.TestPropertyAccessor;
import org.neo4j.kernel.api.impl.index.partition.PartitionSearcher;
import org.neo4j.kernel.api.impl.index.storage.DirectoryFactory;
import org.neo4j.kernel.api.impl.schema.LuceneDocumentStructure;
import org.neo4j.kernel.api.impl.schema.verification.SimpleUniquenessVerifier;
import org.neo4j.kernel.api.impl.schema.verification.UniquenessVerifier;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.test.rule.TestDirectory;

public class SimpleUniquenessVerifierTest {
    private static final int[] PROPERTY_KEY_IDS = new int[]{42};
    @Rule
    public TestDirectory testDir = TestDirectory.testDirectory();
    private DirectoryFactory dirFactory;
    private IndexWriter writer;
    private SearcherManager searcherManager;

    @Before
    public void initLuceneResources() throws Exception {
        this.dirFactory = new DirectoryFactory.InMemoryDirectoryFactory();
        Directory dir = this.dirFactory.open(this.testDir.directory("test"));
        this.writer = new IndexWriter(dir, IndexWriterConfigs.standard());
        this.searcherManager = new SearcherManager(this.writer, true, new SearcherFactory());
    }

    @After
    public void closeLuceneResources() throws Exception {
        IOUtils.closeAll((AutoCloseable[])new Closeable[]{this.searcherManager, this.writer, this.dirFactory});
    }

    @Test
    public void partitionSearcherIsClosed() throws IOException {
        PartitionSearcher partitionSearcher = (PartitionSearcher)Mockito.mock(PartitionSearcher.class);
        SimpleUniquenessVerifier verifier = new SimpleUniquenessVerifier(partitionSearcher);
        verifier.close();
        ((PartitionSearcher)Mockito.verify((Object)partitionSearcher)).close();
    }

    @Test
    public void populationVerificationNoDuplicates() throws Exception {
        List<Object> data = Arrays.asList("string1", 42, 43, 44, 45L, (byte)46, 47.0, Float.valueOf(48.1f), "string2");
        PropertyAccessor propertyAccessor = this.newPropertyAccessor(data);
        this.insert(data);
        this.assertNoDuplicates(propertyAccessor);
    }

    @Test
    public void populationVerificationOneDuplicate() throws IOException {
        List<Object> data = Arrays.asList("cat", 21, 22, 23, 24L, (byte)25, 26.0, Float.valueOf(22.0f), "dog");
        PropertyAccessor propertyAccessor = this.newPropertyAccessor(data);
        this.insert(data);
        this.assertHasDuplicates(propertyAccessor);
    }

    @Test
    public void populationVerificationManyDuplicate() throws IOException {
        List<Object> data = Arrays.asList("dog", "cat", "dog", "dog", "dog", "dog");
        PropertyAccessor propertyAccessor = this.newPropertyAccessor(data);
        this.insert(data);
        this.assertHasDuplicates(propertyAccessor);
    }

    @Test
    public void updatesVerificationNoDuplicates() throws Exception {
        List<Object> data = Arrays.asList("lucene", 1337975550, 43.1, Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c'), (byte)12);
        PropertyAccessor propertyAccessor = this.newPropertyAccessor(data);
        this.insert(data);
        this.assertNoDuplicatesCreated(propertyAccessor, Arrays.asList(1337975550, Character.valueOf('c'), (byte)12));
    }

    @Test
    public void updatesVerificationOneDuplicate() throws IOException {
        List<Object> data = Arrays.asList("foo", "bar", "baz", 100, 200, Character.valueOf('q'), Character.valueOf('u'), Character.valueOf('x'), "aa", 300, Character.valueOf('u'), -100);
        PropertyAccessor propertyAccessor = this.newPropertyAccessor(data);
        this.insert(data);
        this.assertDuplicatesCreated(propertyAccessor, Arrays.asList("aa", Character.valueOf('u'), -100));
    }

    @Test
    public void updatesVerificationManyDuplicate() throws IOException {
        List<Object> data = Arrays.asList(-99, Character.valueOf('a'), -10.0, -99.99999, "apa", Float.valueOf(-99.99999f), "mod", "div", "div", -10);
        PropertyAccessor propertyAccessor = this.newPropertyAccessor(data);
        this.insert(data);
        this.assertDuplicatesCreated(propertyAccessor, Arrays.asList(Float.valueOf(-99.99999f), Character.valueOf('a'), -10, "div"));
    }

    @Test
    public void numericIndexVerificationNoDuplicates() throws Exception {
        List<Object> data = Arrays.asList(0x7FFFFFFD, 0x7FFFFFFE, Integer.MAX_VALUE);
        PropertyAccessor propertyAccessor = this.newPropertyAccessor(data);
        this.insert(data);
        IndexSearcher indexSearcher = (IndexSearcher)Mockito.spy((Object)this.searcherManager.acquire());
        this.runUniquenessVerification(propertyAccessor, indexSearcher);
        ((IndexSearcher)Mockito.verify((Object)indexSearcher, (VerificationMode)Mockito.never())).search((Query)org.mockito.Matchers.any(Query.class), (Collector)org.mockito.Matchers.any(Collector.class));
    }

    @Test
    public void numericIndexVerificationSomePossibleDuplicates() throws Exception {
        List<Object> data = Arrays.asList(42, 0x7FFFFFFFFFFFFFFEL, Long.MAX_VALUE);
        PropertyAccessor propertyAccessor = this.newPropertyAccessor(data);
        this.insert(data);
        IndexSearcher indexSearcher = (IndexSearcher)Mockito.spy((Object)this.searcherManager.acquire());
        this.runUniquenessVerification(propertyAccessor, indexSearcher);
        ((IndexSearcher)Mockito.verify((Object)indexSearcher)).search((Query)org.mockito.Matchers.any(Query.class), (Collector)org.mockito.Matchers.any(Collector.class));
    }

    @Test
    public void numericIndexVerificationSomeWithDuplicates() throws Exception {
        List<Object> data = Arrays.asList(Integer.MAX_VALUE, Long.MAX_VALUE, 42, Long.MAX_VALUE);
        PropertyAccessor propertyAccessor = this.newPropertyAccessor(data);
        this.insert(data);
        IndexSearcher indexSearcher = (IndexSearcher)Mockito.spy((Object)this.searcherManager.acquire());
        try {
            this.runUniquenessVerification(propertyAccessor, indexSearcher);
            Assert.fail((String)"Exception expected");
        }
        catch (Throwable t) {
            Assert.assertThat((Object)t, (Matcher)Matchers.instanceOf(IndexEntryConflictException.class));
        }
        ((IndexSearcher)Mockito.verify((Object)indexSearcher)).search((Query)org.mockito.Matchers.any(Query.class), (Collector)org.mockito.Matchers.any(Collector.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runUniquenessVerification(PropertyAccessor propertyAccessor, IndexSearcher indexSearcher) throws IOException, IndexEntryConflictException {
        try {
            PartitionSearcher partitionSearcher = (PartitionSearcher)Mockito.mock(PartitionSearcher.class);
            Mockito.when((Object)partitionSearcher.getIndexSearcher()).thenReturn((Object)indexSearcher);
            try (SimpleUniquenessVerifier verifier = new SimpleUniquenessVerifier(partitionSearcher);){
                verifier.verify(propertyAccessor, PROPERTY_KEY_IDS);
            }
        }
        finally {
            this.searcherManager.release((Object)indexSearcher);
        }
    }

    private void assertNoDuplicates(PropertyAccessor propertyAccessor) throws Exception {
        try (UniquenessVerifier verifier = this.newSimpleUniquenessVerifier();){
            verifier.verify(propertyAccessor, PROPERTY_KEY_IDS);
        }
    }

    private void assertNoDuplicatesCreated(PropertyAccessor propertyAccessor, List<Object> updatedPropertyValues) throws Exception {
        try (UniquenessVerifier verifier = this.newSimpleUniquenessVerifier();){
            verifier.verify(propertyAccessor, PROPERTY_KEY_IDS, updatedPropertyValues);
        }
    }

    private void assertHasDuplicates(PropertyAccessor propertyAccessor) {
        try (UniquenessVerifier verifier = this.newSimpleUniquenessVerifier();){
            verifier.verify(propertyAccessor, PROPERTY_KEY_IDS);
            Assert.fail((String)"Uniqueness verification was successful. This is not expected...");
        }
        catch (Throwable t) {
            Assert.assertThat((Object)t, (Matcher)Matchers.instanceOf(IndexEntryConflictException.class));
        }
    }

    private void assertDuplicatesCreated(PropertyAccessor propertyAccessor, List<Object> updatedPropertyValues) {
        try (UniquenessVerifier verifier = this.newSimpleUniquenessVerifier();){
            verifier.verify(propertyAccessor, PROPERTY_KEY_IDS, updatedPropertyValues);
            Assert.fail((String)"Uniqueness verification was successful. This is not expected...");
        }
        catch (Throwable t) {
            Assert.assertThat((Object)t, (Matcher)Matchers.instanceOf(IndexEntryConflictException.class));
        }
    }

    private void insert(List<Object> data) throws IOException {
        for (int i = 0; i < data.size(); ++i) {
            Document doc = LuceneDocumentStructure.documentRepresentingProperties((long)i, (Object[])new Object[]{data.get(i)});
            this.writer.addDocument((Iterable)doc);
        }
        this.searcherManager.maybeRefreshBlocking();
    }

    private PropertyAccessor newPropertyAccessor(List<Object> propertyValues) {
        return new TestPropertyAccessor(propertyValues.toArray());
    }

    private UniquenessVerifier newSimpleUniquenessVerifier() throws IOException {
        PartitionSearcher partitionSearcher = new PartitionSearcher((ReferenceManager)this.searcherManager);
        return new SimpleUniquenessVerifier(partitionSearcher);
    }
}

