/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.impl.schema.LuceneIndexAccessor;
import org.neo4j.kernel.api.impl.schema.LuceneSchemaIndexBuilder;
import org.neo4j.kernel.api.impl.schema.SchemaIndex;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.schema_new.IndexQuery;
import org.neo4j.kernel.api.schema_new.LabelSchemaSupplier;
import org.neo4j.kernel.api.schema_new.index.NewIndexDescriptor;
import org.neo4j.kernel.api.schema_new.index.NewIndexDescriptorFactory;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.IndexSample;
import org.neo4j.storageengine.api.schema.IndexSampler;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

@RunWith(value=Parameterized.class)
public class LuceneSchemaIndexPopulationIT {
    @Rule
    public TestDirectory testDir = TestDirectory.testDirectory();
    @Rule
    public final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    private int affectedNodes;
    private final NewIndexDescriptor descriptor = NewIndexDescriptorFactory.uniqueForLabel((int)0, (int[])new int[]{0});

    @Before
    public void before() throws Exception {
        System.setProperty("luceneSchemaIndex.maxPartitionSize", "10");
    }

    @After
    public void after() throws IOException {
        System.setProperty("luceneSchemaIndex.maxPartitionSize", "");
    }

    @Parameterized.Parameters(name="{0}")
    public static List<Integer> affectedNodes() {
        return Arrays.asList(7, 11, 14, 20, 35, 58);
    }

    public LuceneSchemaIndexPopulationIT(int affectedNodes) {
        this.affectedNodes = affectedNodes;
    }

    @Test
    public void partitionedIndexPopulation() throws Exception {
        try (SchemaIndex uniqueIndex = ((LuceneSchemaIndexBuilder)((LuceneSchemaIndexBuilder)((LuceneSchemaIndexBuilder)LuceneSchemaIndexBuilder.create((NewIndexDescriptor)this.descriptor).withFileSystem(this.fileSystemRule.get())).withIndexRootFolder(this.testDir.directory("partitionIndex" + this.affectedNodes))).withIndexIdentifier("uniqueIndex" + this.affectedNodes)).build();){
            uniqueIndex.open();
            Assert.assertEquals((long)0L, (long)uniqueIndex.allDocumentsReader().maxCount());
            Assert.assertFalse((boolean)uniqueIndex.exists());
            try (LuceneIndexAccessor indexAccessor = new LuceneIndexAccessor(uniqueIndex, this.descriptor);){
                this.generateUpdates(indexAccessor, this.affectedNodes);
                indexAccessor.force();
                Assert.assertTrue((boolean)uniqueIndex.isOnline());
                try (IndexReader indexReader = indexAccessor.newReader();){
                    long[] nodes = PrimitiveLongCollections.asArray((PrimitiveLongIterator)indexReader.query(new IndexQuery[]{IndexQuery.exists((int)1)}));
                    Assert.assertEquals((long)this.affectedNodes, (long)nodes.length);
                    IndexSampler indexSampler = indexReader.createSampler();
                    IndexSample sample = indexSampler.sampleIndex();
                    Assert.assertEquals((long)this.affectedNodes, (long)sample.indexSize());
                    Assert.assertEquals((long)this.affectedNodes, (long)sample.uniqueValues());
                    Assert.assertEquals((long)this.affectedNodes, (long)sample.sampleSize());
                }
            }
        }
    }

    private void generateUpdates(LuceneIndexAccessor indexAccessor, int nodesToUpdate) throws IOException, IndexEntryConflictException {
        try (IndexUpdater updater = indexAccessor.newUpdater(IndexUpdateMode.ONLINE);){
            for (int nodeId = 0; nodeId < nodesToUpdate; ++nodeId) {
                updater.process(this.add(nodeId, nodeId));
            }
        }
    }

    private IndexEntryUpdate add(long nodeId, Object value) {
        return IndexEntryUpdate.add((long)nodeId, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{value});
    }
}

