/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.IndexSearcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.impl.index.LuceneAllDocumentsReader;
import org.neo4j.kernel.api.impl.index.LucenePartitionAllDocumentsReader;
import org.neo4j.kernel.api.impl.index.partition.PartitionSearcher;

public class LuceneAllDocumentsReaderTest {
    private final PartitionSearcher partitionSearcher1 = LuceneAllDocumentsReaderTest.createPartitionSearcher(1, 0, 2);
    private final PartitionSearcher partitionSearcher2 = LuceneAllDocumentsReaderTest.createPartitionSearcher(2, 1, 2);

    @Test
    public void allDocumentsMaxCount() {
        LuceneAllDocumentsReader allDocumentsReader = this.createAllDocumentsReader();
        Assert.assertEquals((long)3L, (long)allDocumentsReader.maxCount());
    }

    @Test
    public void closeCorrespondingSearcherOnClose() throws IOException {
        LuceneAllDocumentsReader allDocumentsReader = this.createAllDocumentsReader();
        allDocumentsReader.close();
        ((PartitionSearcher)Mockito.verify((Object)this.partitionSearcher1)).close();
        ((PartitionSearcher)Mockito.verify((Object)this.partitionSearcher2)).close();
    }

    @Test
    public void readAllDocuments() {
        LuceneAllDocumentsReader allDocumentsReader = this.createAllDocumentsReader();
        List documents = Iterators.asList((Iterator)allDocumentsReader.iterator());
        Assert.assertEquals((String)"Should have 1 document from first partition and 2 from second one.", (long)3L, (long)documents.size());
        Assert.assertEquals((Object)"1", (Object)((Document)documents.get(0)).getField("value").stringValue());
        Assert.assertEquals((Object)"3", (Object)((Document)documents.get(1)).getField("value").stringValue());
        Assert.assertEquals((Object)"4", (Object)((Document)documents.get(2)).getField("value").stringValue());
    }

    private LuceneAllDocumentsReader createAllDocumentsReader() {
        return new LuceneAllDocumentsReader(this.createPartitionReaders());
    }

    private List<LucenePartitionAllDocumentsReader> createPartitionReaders() {
        LucenePartitionAllDocumentsReader reader1 = new LucenePartitionAllDocumentsReader(this.partitionSearcher1);
        LucenePartitionAllDocumentsReader reader2 = new LucenePartitionAllDocumentsReader(this.partitionSearcher2);
        return Arrays.asList(reader1, reader2);
    }

    private static PartitionSearcher createPartitionSearcher(int maxDoc, int partition, int maxSize) throws IOException {
        PartitionSearcher partitionSearcher = (PartitionSearcher)Mockito.mock(PartitionSearcher.class);
        IndexSearcher indexSearcher = (IndexSearcher)Mockito.mock(IndexSearcher.class);
        IndexReader indexReader = (IndexReader)Mockito.mock(IndexReader.class);
        Mockito.when((Object)partitionSearcher.getIndexSearcher()).thenReturn((Object)indexSearcher);
        Mockito.when((Object)indexSearcher.getIndexReader()).thenReturn((Object)indexReader);
        Mockito.when((Object)indexReader.maxDoc()).thenReturn((Object)maxDoc);
        Mockito.when((Object)indexSearcher.doc(0)).thenReturn((Object)LuceneAllDocumentsReaderTest.createDocument(LuceneAllDocumentsReaderTest.uniqueDocValue(1, partition, maxSize)));
        Mockito.when((Object)indexSearcher.doc(1)).thenReturn((Object)LuceneAllDocumentsReaderTest.createDocument(LuceneAllDocumentsReaderTest.uniqueDocValue(2, partition, maxSize)));
        Mockito.when((Object)indexSearcher.doc(2)).thenReturn((Object)LuceneAllDocumentsReaderTest.createDocument(LuceneAllDocumentsReaderTest.uniqueDocValue(3, partition, maxSize)));
        return partitionSearcher;
    }

    private static String uniqueDocValue(int value, int partition, int maxSize) {
        return String.valueOf(value + partition * maxSize);
    }

    private static Document createDocument(String value) {
        Document document = new Document();
        document.add((IndexableField)new StoredField("value", value));
        return document;
    }
}

