/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.util.Bits;

public class IndexReaderStub
extends LeafReader {
    private Fields fields;
    private boolean allDeleted;
    private String[] elements = new String[0];
    private Function<String, NumericDocValues> ndvs = s -> DocValues.emptyNumeric();
    private IOException throwOnFields;
    private static FieldInfo DummyFieldInfo = new FieldInfo("id", 0, false, true, false, IndexOptions.DOCS, DocValuesType.NONE, -1L, Collections.emptyMap());

    public IndexReaderStub(boolean allDeleted, String ... elements) {
        this.allDeleted = allDeleted;
        this.elements = elements;
    }

    public IndexReaderStub(Fields fields) {
        this.fields = fields;
    }

    public IndexReaderStub(NumericDocValues ndv) {
        this.ndvs = s -> ndv;
    }

    public IndexReaderStub(Map<String, NumericDocValues> ndvs) {
        this.ndvs = s -> {
            NumericDocValues dv = (NumericDocValues)ndvs.get(s);
            if (dv == null) {
                return DocValues.emptyNumeric();
            }
            return dv;
        };
    }

    public void setElements(String[] elements) {
        this.elements = elements;
    }

    public void addCoreClosedListener(LeafReader.CoreClosedListener listener) {
    }

    public void removeCoreClosedListener(LeafReader.CoreClosedListener listener) {
    }

    public Fields fields() throws IOException {
        if (this.throwOnFields != null) {
            IOException exception = this.throwOnFields;
            this.throwOnFields = null;
            throw exception;
        }
        return this.fields;
    }

    public NumericDocValues getNumericDocValues(String field) throws IOException {
        return this.ndvs.apply(field);
    }

    public BinaryDocValues getBinaryDocValues(String field) throws IOException {
        return DocValues.emptyBinary();
    }

    public SortedDocValues getSortedDocValues(String field) throws IOException {
        return DocValues.emptySorted();
    }

    public SortedNumericDocValues getSortedNumericDocValues(String field) throws IOException {
        return DocValues.emptySortedNumeric((int)this.elements.length);
    }

    public SortedSetDocValues getSortedSetDocValues(String field) throws IOException {
        return DocValues.emptySortedSet();
    }

    public Bits getDocsWithField(String field) throws IOException {
        throw new RuntimeException("Not yet implemented.");
    }

    public NumericDocValues getNormValues(String field) throws IOException {
        return DocValues.emptyNumeric();
    }

    public FieldInfos getFieldInfos() {
        throw new RuntimeException("Not yet implemented.");
    }

    public Bits getLiveDocs() {
        return new Bits(){

            public boolean get(int index) {
                if (index >= IndexReaderStub.this.elements.length) {
                    throw new IllegalArgumentException("Doc id out of range");
                }
                return !IndexReaderStub.this.allDeleted;
            }

            public int length() {
                return IndexReaderStub.this.elements.length;
            }
        };
    }

    public void checkIntegrity() throws IOException {
    }

    public Fields getTermVectors(int docID) throws IOException {
        throw new RuntimeException("Not yet implemented.");
    }

    public int numDocs() {
        return this.allDeleted ? 0 : this.elements.length;
    }

    public int maxDoc() {
        return Math.max(this.maxValue(), this.elements.length) + 1;
    }

    public void document(int docID, StoredFieldVisitor visitor) throws IOException {
        visitor.stringField(DummyFieldInfo, String.valueOf(docID).getBytes(StandardCharsets.UTF_8));
    }

    protected void doClose() throws IOException {
    }

    private int maxValue() {
        return Arrays.stream(this.elements).mapToInt(value -> NumberUtils.toInt((String)value, (int)0)).max().getAsInt();
    }
}

