/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.timeline;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.RelationshipIndex;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.index.lucene.LuceneTimeline;
import org.neo4j.index.lucene.TimelineIndex;
import org.neo4j.test.TestGraphDatabaseFactory;

public class TestTimeline {
    private GraphDatabaseService db;
    private EntityCreator<PropertyContainer> nodeCreator = new EntityCreator<PropertyContainer>(){

        @Override
        public Node create() {
            return TestTimeline.this.db.createNode();
        }
    };
    private EntityCreator<PropertyContainer> relationshipCreator = new EntityCreator<PropertyContainer>(){
        private final RelationshipType type = RelationshipType.withName((String)"whatever");

        @Override
        public Relationship create() {
            return TestTimeline.this.db.createNode().createRelationshipTo(TestTimeline.this.db.createNode(), this.type);
        }
    };

    @Before
    public void before() throws Exception {
        this.db = new TestGraphDatabaseFactory().newImpermanentDatabaseBuilder().newGraphDatabase();
    }

    @After
    public void after() {
        this.db.shutdown();
    }

    private TimelineIndex<PropertyContainer> nodeTimeline() {
        try (Transaction tx = this.db.beginTx();){
            Index nodeIndex = this.db.index().forNodes("timeline");
            tx.success();
            LuceneTimeline luceneTimeline = new LuceneTimeline(this.db, nodeIndex);
            return luceneTimeline;
        }
    }

    private TimelineIndex<PropertyContainer> relationshipTimeline() {
        try (Transaction tx = this.db.beginTx();){
            RelationshipIndex relationshipIndex = this.db.index().forRelationships("timeline");
            tx.success();
            LuceneTimeline luceneTimeline = new LuceneTimeline(this.db, (Index)relationshipIndex);
            return luceneTimeline;
        }
    }

    private LinkedList<Pair<PropertyContainer, Long>> createTimestamps(EntityCreator<PropertyContainer> creator, TimelineIndex<PropertyContainer> timeline, long ... timestamps) {
        try (Transaction tx = this.db.beginTx();){
            LinkedList<Pair<PropertyContainer, Long>> result = new LinkedList<Pair<PropertyContainer, Long>>();
            for (long timestamp : timestamps) {
                result.add(this.createTimestampedEntity(creator, timeline, timestamp));
            }
            tx.success();
            LinkedList<Pair<PropertyContainer, Long>> linkedList = result;
            return linkedList;
        }
    }

    private Pair<PropertyContainer, Long> createTimestampedEntity(EntityCreator<PropertyContainer> creator, TimelineIndex<PropertyContainer> timeline, long timestamp) {
        PropertyContainer entity = creator.create();
        timeline.add(entity, timestamp);
        return Pair.of((Object)entity, (Object)timestamp);
    }

    private List<PropertyContainer> sortedEntities(LinkedList<Pair<PropertyContainer, Long>> timestamps, final boolean reversed) {
        ArrayList<Pair<PropertyContainer, Long>> sorted = new ArrayList<Pair<PropertyContainer, Long>>(timestamps);
        Collections.sort(sorted, new Comparator<Pair<PropertyContainer, Long>>(){

            @Override
            public int compare(Pair<PropertyContainer, Long> o1, Pair<PropertyContainer, Long> o2) {
                return !reversed ? ((Long)o1.other()).compareTo((Long)o2.other()) : ((Long)o2.other()).compareTo((Long)o1.other());
            }
        });
        ArrayList<PropertyContainer> result = new ArrayList<PropertyContainer>();
        for (Pair pair : sorted) {
            result.add((PropertyContainer)pair.first());
        }
        return result;
    }

    private void makeSureFirstAndLastAreReturnedCorrectly(EntityCreator<PropertyContainer> creator, TimelineIndex<PropertyContainer> timeline) throws Exception {
        LinkedList<Pair<PropertyContainer, Long>> timestamps = this.createTimestamps(creator, timeline, 223456L, 12345L, 432234L);
        try (Transaction tx = this.db.beginTx();){
            Assert.assertEquals((Object)timestamps.get(1).first(), (Object)timeline.getFirst());
            Assert.assertEquals((Object)timestamps.getLast().first(), (Object)timeline.getLast());
            tx.success();
        }
    }

    private void makeSureRangesAreReturnedInCorrectOrder(EntityCreator<PropertyContainer> creator, TimelineIndex<PropertyContainer> timeline) throws Exception {
        LinkedList<Pair<PropertyContainer, Long>> timestamps = this.createTimestamps(creator, timeline, 300000L, 200000L, 400000L, 100000L, 500000L, 600000L, 900000L, 800000L);
        try (Transaction tx = this.db.beginTx();){
            Assert.assertEquals(this.sortedEntities(timestamps, false), (Object)Iterators.asCollection((Iterator)timeline.getBetween(null, null).iterator()));
            tx.success();
        }
    }

    private void makeSureRangesAreReturnedInCorrectReversedOrder(EntityCreator<PropertyContainer> creator, TimelineIndex<PropertyContainer> timeline) throws Exception {
        LinkedList<Pair<PropertyContainer, Long>> timestamps = this.createTimestamps(creator, timeline, 300000L, 200000L, 199999L, 400000L, 100000L, 500000L, 600000L, 900000L, 800000L);
        try (Transaction tx = this.db.beginTx();){
            Assert.assertEquals(this.sortedEntities(timestamps, true), (Object)Iterators.asCollection((Iterator)timeline.getBetween(null, null, true).iterator()));
            tx.success();
        }
    }

    private void makeSureWeCanQueryLowerDefaultThan1970(EntityCreator<PropertyContainer> creator, TimelineIndex<PropertyContainer> timeline) throws Exception {
        LinkedList<Pair<PropertyContainer, Long>> timestamps = this.createTimestamps(creator, timeline, -10000L, 0L, 10000L);
        try (Transaction tx = this.db.beginTx();){
            Assert.assertEquals(this.sortedEntities(timestamps, true), (Object)Iterators.asCollection((Iterator)timeline.getBetween(null, Long.valueOf(10000L), true).iterator()));
            tx.success();
        }
    }

    private void makeSureUncommittedChangesAreSortedCorrectly(EntityCreator<PropertyContainer> creator, TimelineIndex<PropertyContainer> timeline) throws Exception {
        LinkedList<Pair<PropertyContainer, Long>> timestamps = this.createTimestamps(creator, timeline, 300000L, 100000L, 500000L, 900000L, 800000L);
        try (Transaction tx = this.db.beginTx();){
            timestamps.addAll(this.createTimestamps(creator, timeline, 40000L, 70000L, 20000L));
            Assert.assertEquals(this.sortedEntities(timestamps, false), (Object)Iterators.asCollection((Iterator)timeline.getBetween(null, null).iterator()));
            tx.success();
        }
        var5_5 = null;
        try (Transaction ignore = this.db.beginTx();){
            Assert.assertEquals(this.sortedEntities(timestamps, false), (Object)Iterators.asCollection((Iterator)timeline.getBetween(null, null).iterator()));
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
    }

    @Test
    public void makeSureFirstAndLastAreReturnedCorrectlyNode() throws Exception {
        this.makeSureFirstAndLastAreReturnedCorrectly(this.nodeCreator, this.nodeTimeline());
    }

    @Test
    public void makeSureFirstAndLastAreReturnedCorrectlyRelationship() throws Exception {
        this.makeSureFirstAndLastAreReturnedCorrectly(this.relationshipCreator, this.relationshipTimeline());
    }

    @Test
    public void makeSureRangesAreReturnedInCorrectOrderNode() throws Exception {
        this.makeSureRangesAreReturnedInCorrectOrder(this.nodeCreator, this.nodeTimeline());
    }

    @Test
    public void makeSureRangesAreReturnedInCorrectOrderRelationship() throws Exception {
        this.makeSureRangesAreReturnedInCorrectOrder(this.relationshipCreator, this.relationshipTimeline());
    }

    @Test
    public void makeSureRangesAreReturnedInCorrectReversedOrderNode() throws Exception {
        this.makeSureRangesAreReturnedInCorrectReversedOrder(this.nodeCreator, this.nodeTimeline());
    }

    @Test
    public void makeSureRangesAreReturnedInCorrectReversedOrderRelationship() throws Exception {
        this.makeSureRangesAreReturnedInCorrectReversedOrder(this.relationshipCreator, this.relationshipTimeline());
    }

    @Test
    public void makeSureUncommittedChangesAreSortedCorrectlyNode() throws Exception {
        this.makeSureUncommittedChangesAreSortedCorrectly(this.nodeCreator, this.nodeTimeline());
    }

    @Test
    public void makeSureUncommittedChangesAreSortedCorrectlyRelationship() throws Exception {
        this.makeSureUncommittedChangesAreSortedCorrectly(this.relationshipCreator, this.relationshipTimeline());
    }

    @Test
    public void makeSureWeCanQueryLowerDefaultThan1970Node() throws Exception {
        this.makeSureWeCanQueryLowerDefaultThan1970(this.nodeCreator, this.nodeTimeline());
    }

    @Test
    public void makeSureWeCanQueryLowerDefaultThan1970Relationship() throws Exception {
        this.makeSureWeCanQueryLowerDefaultThan1970(this.relationshipCreator, this.relationshipTimeline());
    }

    private static interface EntityCreator<T extends PropertyContainer> {
        public T create();
    }
}

