/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.lucene;

import java.io.File;
import java.io.IOException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.api.exceptions.schema.UnableToValidateConstraintException;
import org.neo4j.kernel.api.impl.index.builder.LuceneIndexStorageBuilder;
import org.neo4j.kernel.api.impl.index.storage.PartitionedIndexStorage;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class ConstraintIndexFailureIT {
    @Rule
    public final TestDirectory storeDir = TestDirectory.testDirectory();
    @Rule
    public final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldFailToValidateConstraintsIfUnderlyingIndexIsFailed() throws Exception {
        this.dbWithConstraint();
        this.storeIndexFailure("Injected failure");
        GraphDatabaseService db = this.startDatabase();
        try {
            try (Transaction tx = db.beginTx();){
                db.createNode(new Label[]{Label.label((String)"Label1")}).setProperty("key1", (Object)"value1");
                Assert.fail((String)"expected exception");
            }
            catch (ConstraintViolationException e) {
                Assert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(UnableToValidateConstraintException.class));
                Assert.assertThat((Object)e.getCause().getCause().getMessage(), (Matcher)IsEqual.equalTo((Object)"The index is in a failed state: 'Injected failure'."));
            }
        }
        finally {
            db.shutdown();
        }
    }

    private GraphDatabaseService startDatabase() {
        return new TestGraphDatabaseFactory().newEmbeddedDatabase(this.storeDir.directory().getAbsoluteFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dbWithConstraint() {
        GraphDatabaseService db = this.startDatabase();
        try (Transaction tx = db.beginTx();){
            db.schema().constraintFor(Label.label((String)"Label1")).assertPropertyIsUnique("key1").create();
            tx.success();
        }
        finally {
            db.shutdown();
        }
    }

    private void storeIndexFailure(String failure) throws IOException {
        File luceneRootDirectory = new File(this.storeDir.directory(), "schema/index/lucene");
        PartitionedIndexStorage indexStorage = LuceneIndexStorageBuilder.create().withFileSystem(this.fileSystemRule.get()).withIndexRootFolder(luceneRootDirectory).withIndexIdentifier("1").build();
        indexStorage.storeIndexFailure(failure);
    }
}

