/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene.legacy;

import java.util.HashMap;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.ReadableRelationshipIndex;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestGraphDatabaseFactory;

public class TestAutoIndexReopen {
    private GraphDatabaseAPI graphDb;
    private long id1 = -1L;
    private long id2 = -1L;
    private long id3 = -1L;

    @Before
    public void startDb() {
        this.graphDb = (GraphDatabaseAPI)new TestGraphDatabaseFactory().newImpermanentDatabaseBuilder().setConfig(new HashMap()).newGraphDatabase();
        try (Transaction tx = this.graphDb.beginTx();){
            this.graphDb.index().getNodeAutoIndexer().setEnabled(true);
            this.graphDb.index().getNodeAutoIndexer().startAutoIndexingProperty("nodeProp");
            this.graphDb.index().getRelationshipAutoIndexer().setEnabled(true);
            this.graphDb.index().getRelationshipAutoIndexer().startAutoIndexingProperty("type");
            tx.success();
        }
        tx = this.graphDb.beginTx();
        var2_2 = null;
        try {
            Node node1 = this.graphDb.createNode();
            Node node2 = this.graphDb.createNode();
            Node node3 = this.graphDb.createNode();
            this.id1 = node1.getId();
            this.id2 = node2.getId();
            this.id3 = node3.getId();
            Relationship rel = node1.createRelationshipTo(node2, RelationshipType.withName((String)"FOO"));
            rel.setProperty("type", (Object)"FOO");
            tx.success();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var2_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @After
    public void stopDb() {
        if (this.graphDb != null) {
            this.graphDb.shutdown();
        }
        this.graphDb = null;
    }

    private ReadableRelationshipIndex relationShipAutoIndex() {
        return this.graphDb.index().getRelationshipAutoIndexer().getAutoIndex();
    }

    @Test
    public void testForceOpenIfChanged() {
        try (Transaction tx = this.graphDb.beginTx();){
            Node node1 = this.graphDb.getNodeById(this.id1);
            Node node2 = this.graphDb.getNodeById(this.id2);
            Node node3 = this.graphDb.getNodeById(this.id3);
            node1.setProperty("np2", (Object)"test property");
            node1.getRelationships(new RelationshipType[]{RelationshipType.withName((String)"FOO")}).forEach(r -> r.delete());
            Assert.assertEquals((long)0L, (long)this.relationShipAutoIndex().get("type", (Object)"FOO", node1, node3).size());
            Relationship rel = node1.createRelationshipTo(node3, RelationshipType.withName((String)"FOO"));
            rel.setProperty("type", (Object)"FOO");
            Assert.assertEquals((long)0L, (long)this.relationShipAutoIndex().get("type", (Object)"FOO", node1, node2).size());
            rel = node1.createRelationshipTo(node2, RelationshipType.withName((String)"FOO"));
            rel.setProperty("type", (Object)"FOO");
            Assert.assertEquals((long)1L, (long)this.relationShipAutoIndex().get("type", (Object)"FOO", node1, node2).size());
            tx.success();
        }
    }
}

