/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene.legacy;

import java.io.File;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.RelationshipIndex;
import org.neo4j.index.impl.lucene.legacy.LuceneDataSource;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.ConfigurationValidator;
import org.neo4j.kernel.impl.index.IndexConfigStore;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.EmbeddedDatabaseRule;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class RecoveryTest {
    @Rule
    public final DatabaseRule db = new EmbeddedDatabaseRule();
    @Rule
    public final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();

    @Test
    public void testRecovery() throws Exception {
        try (Transaction tx = this.db.beginTx();){
            Node node = this.db.createNode();
            Node otherNode = this.db.createNode();
            Relationship rel = node.createRelationshipTo(otherNode, RelationshipType.withName((String)"recovery"));
            this.db.index().forNodes("node-index").add((PropertyContainer)node, "key1", (Object)"string value");
            this.db.index().forNodes("node-index").add((PropertyContainer)node, "key2", (Object)12345);
            this.db.index().forRelationships("rel-index").add((PropertyContainer)rel, "key1", (Object)"string value");
            this.db.index().forRelationships("rel-index").add((PropertyContainer)rel, "key2", (Object)12345);
            tx.success();
        }
        this.forceRecover();
    }

    @Test
    public void shouldNotAcceptValuesWithNullToString() throws Exception {
        try (Transaction tx = this.db.beginTx();){
            Node node = this.db.createNode();
            Node otherNode = this.db.createNode();
            Relationship rel = node.createRelationshipTo(otherNode, (RelationshipType)DynamicRelationshipType.withName((String)"recovery"));
            Index nodeIndex = this.db.index().forNodes("node-index");
            RelationshipIndex relationshipIndex = this.db.index().forRelationships("rel-index");
            this.assertAddFailsWithIllegalArgument(nodeIndex, node, "key1", new ClassWithToStringAlwaysNull());
            this.assertAddFailsWithIllegalArgument((Index)relationshipIndex, (PropertyContainer)rel, "key1", new ClassWithToStringAlwaysNull());
            this.assertRemoveFailsWithIllegalArgument(nodeIndex, node, "key1", new ClassWithToStringAlwaysNull());
            this.assertRemoveFailsWithIllegalArgument((Index)relationshipIndex, (PropertyContainer)rel, "key1", new ClassWithToStringAlwaysNull());
            tx.success();
        }
        this.forceRecover();
    }

    @Test
    public void testAsLittleAsPossibleRecoveryScenario() throws Exception {
        try (Transaction tx = this.db.beginTx();){
            this.db.index().forNodes("my-index").add((PropertyContainer)this.db.createNode(), "key", (Object)"value");
            tx.success();
        }
        this.forceRecover();
    }

    @Test
    public void testIndexDeleteIssue() throws Exception {
        Index index2;
        Index index;
        try (Transaction tx = this.db.beginTx();){
            this.db.index().forNodes("index");
            tx.success();
        }
        this.shutdownDB();
        this.db.ensureStarted();
        try (Transaction tx = this.db.beginTx();){
            index = this.db.index().forNodes("index");
            index2 = this.db.index().forNodes("index2");
            Node node = this.db.createNode();
            index.add((PropertyContainer)node, "key", (Object)"value");
            tx.success();
        }
        tx = this.db.beginTx();
        var4_7 = null;
        try {
            index.delete();
            index2.add((PropertyContainer)this.db.createNode(), "key", (Object)"value");
            tx.success();
        }
        catch (Throwable throwable) {
            var4_7 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_7 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_7.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        this.db.shutdown();
        this.db.ensureStarted();
        this.forceRecover();
    }

    @Test
    public void recoveryForRelationshipCommandsOnly() throws Throwable {
        File storeDir = this.db.getStoreDirFile();
        this.shutdownDB();
        try (Transaction tx = this.db.beginTx();){
            RelationshipIndex index = this.db.index().forRelationships("myIndex");
            Node node = this.db.createNode();
            Relationship relationship = this.db.createNode().createRelationshipTo(node, RelationshipType.withName((String)"KNOWS"));
            index.add((PropertyContainer)relationship, "key", (Object)"value");
            tx.success();
        }
        this.db.shutdown();
        Config config = Config.embeddedDefaults((ConfigurationValidator[])new ConfigurationValidator[0]);
        IndexConfigStore indexStore = new IndexConfigStore(storeDir, this.fileSystemRule.get());
        LuceneDataSource ds = new LuceneDataSource(storeDir, config, indexStore, this.fileSystemRule.get());
        ds.start();
        ds.stop();
    }

    @Test
    public void recoveryOnDeletedIndex() throws Exception {
        Index index2;
        Index index;
        try (Transaction tx = this.db.beginTx();){
            this.db.index().forNodes("index");
            tx.success();
        }
        this.shutdownDB();
        try (Transaction tx = this.db.beginTx();){
            index = this.db.index().forNodes("index");
            index2 = this.db.index().forNodes("index2");
            Node node = this.db.createNode();
            index.add((PropertyContainer)node, "key", (Object)"value");
            tx.success();
        }
        tx = this.db.beginTx();
        var4_7 = null;
        try {
            index.delete();
            index2.add((PropertyContainer)this.db.createNode(), "key", (Object)"value");
            tx.success();
        }
        catch (Throwable throwable) {
            var4_7 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_7 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_7.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        this.db.shutdownAndKeepStore();
        this.db.ensureStarted();
        tx = this.db.beginTx();
        var4_7 = null;
        try {
            Assert.assertFalse((boolean)this.db.index().existsForNodes("index"));
            Assert.assertNotNull((Object)this.db.index().forNodes("index2").get("key", (Object)"value").getSingle());
        }
        catch (Throwable throwable) {
            var4_7 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_7 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_7.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    private void shutdownDB() {
        this.db.shutdownAndKeepStore();
    }

    private void forceRecover() throws IOException {
        this.db.restartDatabase();
    }

    private <ENTITY extends PropertyContainer> void assertAddFailsWithIllegalArgument(Index<ENTITY> index, ENTITY entity, String key, Object value) {
        try {
            index.add(entity, key, value);
            Assert.fail((String)"Should not accept value with null toString");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private <ENTITY extends PropertyContainer> void assertRemoveFailsWithIllegalArgument(Index<ENTITY> index, ENTITY entity, String key, Object value) {
        try {
            index.remove(entity, key, value);
            Assert.fail((String)"Should not accept value with null toString");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    static class ClassWithToStringAlwaysNull {
        ClassWithToStringAlwaysNull() {
        }

        public String toString() {
            return null;
        }
    }
}

