/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene.legacy;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.graphdb.Node;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.index.impl.lucene.legacy.IndexIdentifier;
import org.neo4j.index.impl.lucene.legacy.IndexReference;
import org.neo4j.index.impl.lucene.legacy.IndexTypeCache;
import org.neo4j.index.impl.lucene.legacy.LuceneDataSource;
import org.neo4j.index.impl.lucene.legacy.ReadOnlyIndexReferenceFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.index.IndexConfigStore;
import org.neo4j.kernel.impl.index.IndexEntityType;
import org.neo4j.test.rule.CleanupRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class ReadOnlyIndexReferenceFactoryTest {
    private final TestDirectory testDirectory = TestDirectory.testDirectory();
    private final ExpectedException expectedException = ExpectedException.none();
    private final CleanupRule cleanupRule = new CleanupRule();
    private final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.cleanupRule).around((TestRule)this.expectedException).around((TestRule)this.testDirectory).around((TestRule)this.fileSystemRule);
    private static final String INDEX_NAME = "testIndex";
    private LuceneDataSource.LuceneFilesystemFacade filesystemFacade = LuceneDataSource.LuceneFilesystemFacade.FS;
    private IndexIdentifier indexIdentifier = new IndexIdentifier(IndexEntityType.Node, "testIndex");
    private IndexConfigStore indexStore;

    @Before
    public void setUp() throws IOException {
        this.setupIndexInfrastructure();
    }

    @Test
    public void createReadOnlyIndexReference() throws Exception {
        ReadOnlyIndexReferenceFactory indexReferenceFactory = this.getReadOnlyIndexReferenceFactory();
        IndexReference indexReference = indexReferenceFactory.createIndexReference(this.indexIdentifier);
        this.cleanupRule.add((Object)indexReference);
        this.expectedException.expect(UnsupportedOperationException.class);
        indexReference.getWriter();
    }

    @Test
    public void refreshReadOnlyIndexReference() throws IOException {
        ReadOnlyIndexReferenceFactory indexReferenceFactory = this.getReadOnlyIndexReferenceFactory();
        IndexReference indexReference = indexReferenceFactory.createIndexReference(this.indexIdentifier);
        this.cleanupRule.add((Object)indexReference);
        IndexReference refreshedIndex = indexReferenceFactory.refresh(indexReference);
        Assert.assertSame((String)"Refreshed instance should be the same.", (Object)indexReference, (Object)refreshedIndex);
    }

    private void setupIndexInfrastructure() throws IOException {
        File storeDir = this.getStoreDir();
        this.indexStore = new IndexConfigStore(storeDir, this.fileSystemRule.get());
        this.indexStore.set(Node.class, INDEX_NAME, MapUtil.stringMap((String[])new String[]{"provider", "lucene", "type", "fulltext"}));
        LuceneDataSource luceneDataSource = new LuceneDataSource(storeDir, Config.embeddedDefaults((Map)MapUtil.stringMap((String[])new String[0])), this.indexStore, this.fileSystemRule.get());
        try {
            luceneDataSource.init();
            luceneDataSource.getIndexSearcher(this.indexIdentifier);
        }
        finally {
            luceneDataSource.shutdown();
        }
    }

    private ReadOnlyIndexReferenceFactory getReadOnlyIndexReferenceFactory() {
        return new ReadOnlyIndexReferenceFactory(this.filesystemFacade, new File(this.getStoreDir(), "index"), new IndexTypeCache(this.indexStore));
    }

    private File getStoreDir() {
        return this.testDirectory.directory();
    }
}

