/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene.legacy;

import java.io.File;
import java.util.Map;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.index.impl.lucene.legacy.IndexIdentifier;
import org.neo4j.index.impl.lucene.legacy.LuceneCommandApplier;
import org.neo4j.index.impl.lucene.legacy.LuceneDataSource;
import org.neo4j.index.impl.lucene.legacy.LuceneIndexImplementation;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.index.IndexCommand;
import org.neo4j.kernel.impl.index.IndexConfigStore;
import org.neo4j.kernel.impl.index.IndexDefineCommand;
import org.neo4j.kernel.lifecycle.LifeRule;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class LuceneCommandApplierTest {
    @Rule
    public final EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    @Rule
    public final LifeRule life = new LifeRule(true);
    private final File dir = new File("dir");

    @Test
    public void shouldHandleMultipleIdSpaces() throws Exception {
        ((EphemeralFileSystemAbstraction)this.fs.get()).mkdirs(this.dir);
        String indexName = "name";
        String key = "key";
        IndexConfigStore configStore = new IndexConfigStore(this.dir, this.fs.get());
        configStore.set(Node.class, indexName, LuceneIndexImplementation.EXACT_CONFIG);
        LuceneDataSource dataSource = (LuceneDataSource)this.life.add((Lifecycle)Mockito.spy((Object)new LuceneDataSource(this.dir, Config.embeddedDefaults((Map)MapUtil.stringMap((String[])new String[]{LuceneDataSource.Configuration.ephemeral.name(), "true"})), configStore, this.fs.get())));
        try (LuceneCommandApplier applier = new LuceneCommandApplier(dataSource, false);){
            IndexDefineCommand definitions = LuceneCommandApplierTest.definitions(MapUtil.genericMap((Object[])new Object[]{indexName, 0}), MapUtil.genericMap((Object[])new Object[]{key, 0}));
            applier.visitIndexDefineCommand(definitions);
            applier.visitIndexAddNodeCommand(LuceneCommandApplierTest.addNodeToIndex(definitions, indexName, 0L));
            definitions = LuceneCommandApplierTest.definitions(MapUtil.genericMap((Object[])new Object[]{indexName, 1}), MapUtil.genericMap((Object[])new Object[]{key, 0}));
            applier.visitIndexDefineCommand(definitions);
            applier.visitIndexAddNodeCommand(LuceneCommandApplierTest.addNodeToIndex(definitions, indexName, 1L));
        }
        ((LuceneDataSource)Mockito.verify((Object)dataSource, (VerificationMode)Mockito.times((int)1))).getIndexSearcher((IndexIdentifier)Matchers.any(IndexIdentifier.class));
    }

    private static IndexCommand.AddNodeCommand addNodeToIndex(IndexDefineCommand definitions, String indexName, long nodeId) {
        IndexCommand.AddNodeCommand command = new IndexCommand.AddNodeCommand();
        command.init(definitions.getOrAssignIndexNameId(indexName), nodeId, 0, (Object)"some value");
        return command;
    }

    private static IndexDefineCommand definitions(Map<String, Integer> names, Map<String, Integer> keys) {
        IndexDefineCommand definitions = new IndexDefineCommand();
        definitions.init(names, keys);
        return definitions;
    }
}

