/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene.legacy;

import java.io.File;
import java.io.IOException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.Index;
import org.neo4j.test.TestGraphDatabaseFactory;

public class Inserter {
    public static void main(String[] args) throws IOException {
        File path = new File(args[0]);
        final GraphDatabaseService db = new TestGraphDatabaseFactory().newEmbeddedDatabaseBuilder(path).newGraphDatabase();
        final Index<Node> index = Inserter.getIndex(db);
        final String[] keys = new String[]{"apoc", "zion", "morpheus"};
        final String[] values = new String[]{"hej", "yo", "something", "just a value", "anything"};
        for (int i = 0; i < 5; ++i) {
            new Thread(){

                @Override
                public void run() {
                    while (true) {
                        Transaction tx = db.beginTx();
                        Throwable throwable = null;
                        try {
                            for (int i = 0; i < 100; ++i) {
                                String key = keys[i % keys.length];
                                String value = values[i % values.length] + i;
                                Node node = db.createNode();
                                node.setProperty(key, (Object)value);
                                index.add((PropertyContainer)node, key, (Object)value);
                            }
                            tx.success();
                            continue;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (tx == null) continue;
                            if (throwable != null) {
                                try {
                                    tx.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            tx.close();
                            continue;
                        }
                        break;
                    }
                }
            }.start();
        }
        new File(path, "started").createNewFile();
    }

    private static Index<Node> getIndex(GraphDatabaseService db) {
        try (Transaction transaction = db.beginTx();){
            Index index = db.index().forNodes("myIndex");
            transaction.success();
            Index index2 = index;
            return index2;
        }
    }
}

