/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene.legacy;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.Index;
import org.neo4j.helpers.collection.FilteringIterator;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.impl.index.IndexDefineCommand;
import org.neo4j.kernel.impl.transaction.log.LogEntryCursor;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogVersionRepository;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFile;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommand;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotation;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.TestDirectory;

public class IndexCreationTest {
    @Rule
    public final TestDirectory testDirectory = TestDirectory.testDirectory();
    private GraphDatabaseAPI db;

    @Before
    public void before() throws Exception {
        this.db = (GraphDatabaseAPI)new TestGraphDatabaseFactory().newEmbeddedDatabase(this.testDirectory.graphDbDir());
    }

    @After
    public void after() throws Exception {
        this.db.shutdown();
    }

    @Test
    public void indexCreationConfigRaceCondition() throws Exception {
        for (int run = 0; run < 10; ++run) {
            int r = run;
            CountDownLatch latch = new CountDownLatch(1);
            ExecutorService executor = Executors.newCachedThreadPool();
            for (int thread = 0; thread < 10; ++thread) {
                executor.submit(() -> {
                    try (Transaction tx = this.db.beginTx();){
                        latch.await();
                        Index index = this.db.index().forNodes("index" + r);
                        Node node = this.db.createNode();
                        index.add((PropertyContainer)node, "name", (Object)"Name");
                        tx.success();
                    }
                    catch (InterruptedException e) {
                        Thread.interrupted();
                    }
                });
            }
            latch.countDown();
            executor.shutdown();
            executor.awaitTermination(10L, TimeUnit.SECONDS);
            this.verifyThatIndexCreationTransactionIsTheFirstOne();
        }
    }

    private void verifyThatIndexCreationTransactionIsTheFirstOne() throws Exception {
        PhysicalLogFile pLogFile = (PhysicalLogFile)this.db.getDependencyResolver().resolveDependency(PhysicalLogFile.class);
        long version = ((LogVersionRepository)this.db.getDependencyResolver().resolveDependency(LogVersionRepository.class)).getCurrentLogVersion();
        ((LogRotation)this.db.getDependencyResolver().resolveDependency(LogRotation.class)).rotateLogFile();
        ((CheckPointer)this.db.getDependencyResolver().resolveDependency(CheckPointer.class)).forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("test"));
        ReadableLogChannel logChannel = pLogFile.getReader(LogPosition.start((long)version));
        AtomicBoolean success = new AtomicBoolean(false);
        try (LogEntryCursor cursor = new LogEntryCursor((LogEntryReader)new VersionAwareLogEntryReader(), (ReadableClosablePositionAwareChannel)logChannel);){
            ArrayList<StorageCommand> commandsInFirstEntry = new ArrayList<StorageCommand>();
            boolean startFound = false;
            while (cursor.next()) {
                LogEntry entry = (LogEntry)cursor.get();
                if (entry instanceof LogEntryStart) {
                    if (startFound) {
                        throw new IllegalArgumentException("More than one start entry");
                    }
                    startFound = true;
                }
                if (startFound && entry instanceof LogEntryCommand) {
                    commandsInFirstEntry.add(((LogEntryCommand)entry.as()).getXaCommand());
                }
                if (!(entry instanceof LogEntryCommit)) continue;
                Assert.assertTrue((boolean)startFound);
                Assert.assertFalse((String)"Index creation transaction wasn't the first one", (boolean)commandsInFirstEntry.isEmpty());
                List createCommands = Iterators.asList((Iterator)new FilteringIterator(commandsInFirstEntry.iterator(), item -> item instanceof IndexDefineCommand));
                Assert.assertEquals((long)1L, (long)createCommands.size());
                success.set(true);
                break;
            }
        }
        Assert.assertTrue((String)("Didn't find any commit record in log " + version), (boolean)success.get());
    }
}

