/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Assert;
import org.neo4j.graphdb.LabelScanStoreStartupIT;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.fs.FileUtils;

public class LuceneLabelScanStoreStartupIT
extends LabelScanStoreStartupIT {
    protected void addSpecificConfig(GraphDatabaseBuilder builder) {
        builder.setConfig(GraphDatabaseSettings.label_index, GraphDatabaseSettings.LabelIndex.LUCENE.name());
    }

    private List<File> labelScanStoreIndexDirectories(File storeDirectory) {
        File rootDir = new File(new File(new File(new File(storeDirectory, "schema"), "label"), "lucene"), "labelStore");
        File[] partitionDirs = rootDir.listFiles(File::isDirectory);
        return partitionDirs == null ? Collections.emptyList() : Stream.of(partitionDirs).collect(Collectors.toList());
    }

    protected void corruptLabelScanStoreFiles(File storeDirectory) throws IOException {
        List<File> partitionDirs = this.labelScanStoreIndexDirectories(storeDirectory);
        for (File partitionDir : partitionDirs) {
            for (File file : partitionDir.listFiles()) {
                this.scrambleFile(file);
            }
        }
    }

    protected void deleteLabelScanStoreFiles(File storeDirectory) throws IOException {
        List<File> partitionDirs = this.labelScanStoreIndexDirectories(storeDirectory);
        for (File dir : partitionDirs) {
            Assert.assertTrue((String)"We seem to want to delete the wrong directory here", (boolean)dir.exists());
            Assert.assertTrue((String)"No index files to delete", (dir.listFiles().length > 0 ? 1 : 0) != 0);
            FileUtils.deleteRecursively((File)dir);
        }
    }
}

