/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.neo4j.io.NullOutputStream;
import org.neo4j.io.file.Files;
import org.neo4j.io.fs.FileSystemAbstraction;

public class RotatingFileOutputStreamSupplier
implements Supplier<OutputStream>,
Closeable {
    private static final LongSupplier DEFAULT_CURRENT_TIME_SUPPLIER = System::currentTimeMillis;
    private static final OutputStream nullStream = NullOutputStream.NULL_OUTPUT_STREAM;
    private final LongSupplier currentTimeSupplier;
    private final FileSystemAbstraction fileSystem;
    private final File outputFile;
    private final long rotationThresholdBytes;
    private final long rotationDelay;
    private final int maxArchives;
    private final RotationListener rotationListener;
    private final Executor rotationExecutor;
    private final ReadWriteLock logFileLock = new ReentrantReadWriteLock(true);
    private final OutputStream streamWrapper;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final AtomicBoolean rotating = new AtomicBoolean(false);
    private final AtomicLong earliestRotationTimeRef = new AtomicLong(0L);
    private OutputStream outRef = nullStream;

    public RotatingFileOutputStreamSupplier(FileSystemAbstraction fileSystem, File outputFile, long rotationThresholdBytes, long rotationDelay, int maxArchives, Executor rotationExecutor) throws IOException {
        this(fileSystem, outputFile, rotationThresholdBytes, rotationDelay, maxArchives, rotationExecutor, new RotationListener());
    }

    public RotatingFileOutputStreamSupplier(FileSystemAbstraction fileSystem, File outputFile, long rotationThresholdBytes, long rotationDelay, int maxArchives, Executor rotationExecutor, RotationListener rotationListener) throws IOException {
        this(DEFAULT_CURRENT_TIME_SUPPLIER, fileSystem, outputFile, rotationThresholdBytes, rotationDelay, maxArchives, rotationExecutor, rotationListener);
    }

    RotatingFileOutputStreamSupplier(LongSupplier currentTimeSupplier, FileSystemAbstraction fileSystem, File outputFile, long rotationThresholdBytes, long rotationDelay, int maxArchives, Executor rotationExecutor, RotationListener rotationListener) throws IOException {
        this.currentTimeSupplier = currentTimeSupplier;
        this.fileSystem = fileSystem;
        this.outputFile = outputFile;
        this.rotationThresholdBytes = rotationThresholdBytes;
        this.rotationDelay = rotationDelay;
        this.maxArchives = maxArchives;
        this.rotationListener = rotationListener;
        this.rotationExecutor = rotationExecutor;
        this.outRef = this.openOutputFile();
        this.streamWrapper = new OutputStream(){

            @Override
            public void write(int i) throws IOException {
                RotatingFileOutputStreamSupplier.this.logFileLock.readLock().lock();
                try {
                    RotatingFileOutputStreamSupplier.this.outRef.write(i);
                }
                finally {
                    RotatingFileOutputStreamSupplier.this.logFileLock.readLock().unlock();
                }
            }

            @Override
            public void write(byte[] bytes) throws IOException {
                RotatingFileOutputStreamSupplier.this.logFileLock.readLock().lock();
                try {
                    RotatingFileOutputStreamSupplier.this.outRef.write(bytes);
                }
                finally {
                    RotatingFileOutputStreamSupplier.this.logFileLock.readLock().unlock();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void write(byte[] bytes, int off, int len) throws IOException {
                RotatingFileOutputStreamSupplier.this.logFileLock.readLock().lock();
                try {
                    RotatingFileOutputStreamSupplier.this.outRef.write(bytes, off, len);
                }
                finally {
                    RotatingFileOutputStreamSupplier.this.logFileLock.readLock().unlock();
                }
            }

            @Override
            public void flush() throws IOException {
                RotatingFileOutputStreamSupplier.this.logFileLock.readLock().lock();
                try {
                    RotatingFileOutputStreamSupplier.this.outRef.flush();
                }
                finally {
                    RotatingFileOutputStreamSupplier.this.logFileLock.readLock().unlock();
                }
            }
        };
    }

    @Override
    public OutputStream get() {
        if (!this.closed.get() && !this.rotating.get() && (this.rotationDelayExceeded() && this.rotationThresholdExceeded() || !this.fileSystem.fileExists(this.outputFile))) {
            this.rotate();
        }
        return this.streamWrapper;
    }

    @Override
    public void close() throws IOException {
        this.logFileLock.writeLock().lock();
        try {
            this.closed.set(true);
            this.outRef.close();
        }
        finally {
            this.outRef = nullStream;
            this.logFileLock.writeLock().unlock();
        }
    }

    private boolean rotationThresholdExceeded() {
        return this.fileSystem.fileExists(this.outputFile) && this.rotationThresholdBytes > 0L && this.fileSystem.getFileSize(this.outputFile) >= this.rotationThresholdBytes;
    }

    private boolean rotationDelayExceeded() {
        return this.earliestRotationTimeRef.get() <= this.currentTimeSupplier.getAsLong();
    }

    void rotate() {
        if (this.rotating.getAndSet(true)) {
            return;
        }
        ByteArrayOutputStream bufferingOutputStream = new ByteArrayOutputStream();
        Runnable runnable = () -> {
            this.logFileLock.writeLock().lock();
            try {
                try {
                    try {
                        this.outRef.flush();
                        this.outRef.close();
                        this.outRef = nullStream;
                    }
                    catch (Exception e) {
                        this.rotationListener.rotationError(e, bufferingOutputStream);
                        try {
                            if (!this.closed.get() && this.outRef.equals(nullStream)) {
                                this.outRef = this.openOutputFile();
                                this.rotationListener.outputFileCreated(bufferingOutputStream);
                            }
                        }
                        catch (IOException e2) {
                            System.err.println("Failed to open log file after log rotation: " + e2.getMessage());
                            this.rotationListener.rotationError(e2, bufferingOutputStream);
                        }
                        this.rotating.set(false);
                        try {
                            bufferingOutputStream.writeTo(this.streamWrapper);
                        }
                        catch (IOException e3) {
                            this.rotationListener.rotationError(e3, this.streamWrapper);
                        }
                        this.logFileLock.writeLock().unlock();
                        return;
                    }
                    try {
                        if (this.fileSystem.fileExists(this.outputFile)) {
                            this.shiftArchivedOutputFiles();
                            this.fileSystem.renameFile(this.outputFile, this.archivedOutputFile(1), new CopyOption[0]);
                        }
                    }
                    catch (Exception e) {
                        this.rotationListener.rotationError(e, bufferingOutputStream);
                        try {
                            if (!this.closed.get() && this.outRef.equals(nullStream)) {
                                this.outRef = this.openOutputFile();
                                this.rotationListener.outputFileCreated(bufferingOutputStream);
                            }
                        }
                        catch (IOException e4) {
                            System.err.println("Failed to open log file after log rotation: " + e4.getMessage());
                            this.rotationListener.rotationError(e4, bufferingOutputStream);
                        }
                        this.rotating.set(false);
                        try {
                            bufferingOutputStream.writeTo(this.streamWrapper);
                        }
                        catch (IOException e5) {
                            this.rotationListener.rotationError(e5, this.streamWrapper);
                        }
                        this.logFileLock.writeLock().unlock();
                        return;
                    }
                }
                finally {
                    try {
                        if (!this.closed.get() && this.outRef.equals(nullStream)) {
                            this.outRef = this.openOutputFile();
                            this.rotationListener.outputFileCreated(bufferingOutputStream);
                        }
                    }
                    catch (IOException e) {
                        System.err.println("Failed to open log file after log rotation: " + e.getMessage());
                        this.rotationListener.rotationError(e, bufferingOutputStream);
                    }
                }
                if (this.rotationDelay > 0L) {
                    this.earliestRotationTimeRef.set(this.currentTimeSupplier.getAsLong() + this.rotationDelay);
                }
                this.rotationListener.rotationCompleted(bufferingOutputStream);
            }
            finally {
                this.rotating.set(false);
                try {
                    bufferingOutputStream.writeTo(this.streamWrapper);
                }
                catch (IOException e) {
                    this.rotationListener.rotationError(e, this.streamWrapper);
                }
                this.logFileLock.writeLock().unlock();
            }
        };
        try {
            this.rotationExecutor.execute(runnable);
        }
        catch (Exception e) {
            this.rotationListener.rotationError(e, this.streamWrapper);
            this.rotating.set(false);
        }
    }

    private OutputStream openOutputFile() throws IOException {
        return Files.createOrOpenAsOuputStream((FileSystemAbstraction)this.fileSystem, (File)this.outputFile, (boolean)true);
    }

    private void shiftArchivedOutputFiles() throws IOException {
        for (int i = this.lastArchivedOutputFileNumber(); i > 0; --i) {
            File archive = this.archivedOutputFile(i);
            if (i >= this.maxArchives) {
                this.fileSystem.deleteFile(archive);
                continue;
            }
            this.fileSystem.renameFile(archive, this.archivedOutputFile(i + 1), new CopyOption[0]);
        }
    }

    private int lastArchivedOutputFileNumber() {
        int i = 1;
        while (this.fileSystem.fileExists(this.archivedOutputFile(i))) {
            ++i;
        }
        return i - 1;
    }

    private File archivedOutputFile(int archiveNumber) {
        return new File(String.format("%s.%d", this.outputFile.getPath(), archiveNumber));
    }

    public static class RotationListener {
        public void outputFileCreated(OutputStream out) {
        }

        public void rotationCompleted(OutputStream out) {
        }

        public void rotationError(Exception e, OutputStream out) {
        }
    }
}

