/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.LinkedList;
import java.util.Queue;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.neo4j.logging.AbstractLog;
import org.neo4j.logging.Log;
import org.neo4j.logging.Logger;

public class BufferingLog
extends AbstractLog {
    private final Queue<LogMessage> buffer = new LinkedList<LogMessage>();
    private final Logger debugLogger = new BufferingLogger(){

        @Override
        public LogMessage buildMessage(final @Nonnull String message) {
            return new LogMessage(){

                @Override
                public void replayInto(Log other) {
                    other.debug(message);
                }

                @Override
                public void printTo(PrintWriter pw) {
                    pw.println(message);
                }
            };
        }

        @Override
        public LogMessage buildMessage(final @Nonnull String message, final @Nonnull Throwable throwable) {
            return new LogMessage(){

                @Override
                public void replayInto(Log other) {
                    other.debug(message, throwable);
                }

                @Override
                public void printTo(PrintWriter pw) {
                    pw.println(message);
                    throwable.printStackTrace(pw);
                }
            };
        }

        @Override
        public LogMessage buildMessage(final String format, final Object ... arguments) {
            return new LogMessage(){

                @Override
                public void replayInto(Log other) {
                    other.debug(format, arguments);
                }

                @Override
                public void printTo(PrintWriter pw) {
                    pw.println(String.format(format, arguments));
                }
            };
        }
    };
    private final Logger infoLogger = new BufferingLogger(){

        @Override
        public LogMessage buildMessage(final @Nonnull String message) {
            return new LogMessage(){

                @Override
                public void replayInto(Log other) {
                    other.info(message);
                }

                @Override
                public void printTo(PrintWriter pw) {
                    pw.println(message);
                }
            };
        }

        @Override
        public LogMessage buildMessage(final @Nonnull String message, final @Nonnull Throwable throwable) {
            return new LogMessage(){

                @Override
                public void replayInto(Log other) {
                    other.info(message, throwable);
                }

                @Override
                public void printTo(PrintWriter pw) {
                    pw.println(message);
                    throwable.printStackTrace(pw);
                }
            };
        }

        @Override
        public LogMessage buildMessage(final String format, final Object ... arguments) {
            return new LogMessage(){

                @Override
                public void replayInto(Log other) {
                    other.info(format, arguments);
                }

                @Override
                public void printTo(PrintWriter pw) {
                    pw.println(String.format(format, arguments));
                }
            };
        }
    };
    private final Logger warnLogger = new BufferingLogger(){

        @Override
        public LogMessage buildMessage(final @Nonnull String message) {
            return new LogMessage(){

                @Override
                public void replayInto(Log other) {
                    other.warn(message);
                }

                @Override
                public void printTo(PrintWriter pw) {
                    pw.println(message);
                }
            };
        }

        @Override
        public LogMessage buildMessage(final @Nonnull String message, final @Nonnull Throwable throwable) {
            return new LogMessage(){

                @Override
                public void replayInto(Log other) {
                    other.warn(message, throwable);
                }

                @Override
                public void printTo(PrintWriter pw) {
                    pw.println(message);
                    throwable.printStackTrace(pw);
                }
            };
        }

        @Override
        public LogMessage buildMessage(final String format, final Object ... arguments) {
            return new LogMessage(){

                @Override
                public void replayInto(Log other) {
                    other.warn(format, arguments);
                }

                @Override
                public void printTo(PrintWriter pw) {
                    pw.println(String.format(format, arguments));
                }
            };
        }
    };
    private final Logger errorLogger = new BufferingLogger(){

        @Override
        public LogMessage buildMessage(final @Nonnull String message) {
            return new LogMessage(){

                @Override
                public void replayInto(Log other) {
                    other.error(message);
                }

                @Override
                public void printTo(PrintWriter pw) {
                    pw.println(message);
                }
            };
        }

        @Override
        public LogMessage buildMessage(final @Nonnull String message, final @Nonnull Throwable throwable) {
            return new LogMessage(){

                @Override
                public void replayInto(Log other) {
                    other.error(message, throwable);
                }

                @Override
                public void printTo(PrintWriter pw) {
                    pw.println(message);
                    throwable.printStackTrace(pw);
                }
            };
        }

        @Override
        public LogMessage buildMessage(final String format, final Object ... arguments) {
            return new LogMessage(){

                @Override
                public void replayInto(Log other) {
                    other.error(format, arguments);
                }

                @Override
                public void printTo(PrintWriter pw) {
                    pw.println(String.format(format, arguments));
                }
            };
        }
    };

    @Override
    public boolean isDebugEnabled() {
        return true;
    }

    @Override
    @Nonnull
    public Logger debugLogger() {
        return this.debugLogger;
    }

    @Override
    @Nonnull
    public Logger infoLogger() {
        return this.infoLogger;
    }

    @Override
    @Nonnull
    public Logger warnLogger() {
        return this.warnLogger;
    }

    @Override
    @Nonnull
    public Logger errorLogger() {
        return this.errorLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bulk(@Nonnull Consumer<Log> consumer) {
        Queue<LogMessage> queue = this.buffer;
        synchronized (queue) {
            consumer.accept(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replayInto(Log other) {
        Queue<LogMessage> queue = this.buffer;
        synchronized (queue) {
            LogMessage message = this.buffer.poll();
            while (message != null) {
                message.replayInto(other);
                message = this.buffer.poll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Queue<LogMessage> queue = this.buffer;
        synchronized (queue) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter sb = new PrintWriter(stringWriter);
            for (LogMessage message : this.buffer) {
                message.printTo(sb);
            }
            return stringWriter.toString();
        }
    }

    private abstract class BufferingLogger
    implements Logger {
        private BufferingLogger() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void log(@Nonnull String message) {
            LogMessage logMessage = this.buildMessage(message);
            Queue queue = BufferingLog.this.buffer;
            synchronized (queue) {
                BufferingLog.this.buffer.add(logMessage);
            }
        }

        protected abstract LogMessage buildMessage(@Nonnull String var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void log(@Nonnull String message, @Nonnull Throwable throwable) {
            LogMessage logMessage = this.buildMessage(message, throwable);
            Queue queue = BufferingLog.this.buffer;
            synchronized (queue) {
                BufferingLog.this.buffer.add(logMessage);
            }
        }

        protected abstract LogMessage buildMessage(String var1, Throwable var2);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void log(@Nonnull String format, Object ... arguments) {
            LogMessage logMessage = this.buildMessage(format, arguments);
            Queue queue = BufferingLog.this.buffer;
            synchronized (queue) {
                BufferingLog.this.buffer.add(logMessage);
            }
        }

        protected abstract LogMessage buildMessage(String var1, Object ... var2);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void bulk(@Nonnull Consumer<Logger> consumer) {
            Queue queue = BufferingLog.this.buffer;
            synchronized (queue) {
                consumer.accept(this);
            }
        }
    }

    private static interface LogMessage {
        public void replayInto(Log var1);

        public void printTo(PrintWriter var1);
    }
}

