/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.IllegalFormatException;
import java.util.function.Supplier;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.function.Suppliers;
import org.neo4j.logging.FormattedLog;
import org.neo4j.logging.Level;

public class FormattedLogTest {
    private static final Supplier<ZonedDateTime> DATE_TIME_SUPPLIER = () -> ZonedDateTime.of(1984, 10, 26, 4, 23, 24, 343000000, ZoneOffset.UTC);

    @Test
    public void logShouldWriteMessage() {
        StringWriter writer = new StringWriter();
        FormattedLog log = FormattedLogTest.newFormattedLog(writer);
        log.info("Terminator 2");
        MatcherAssert.assertThat((Object)writer.toString(), (Matcher)CoreMatchers.equalTo((Object)String.format("1984-10-26 04:23:24.343+0000 INFO [test] Terminator 2%n", new Object[0])));
    }

    @Test
    public void logShouldWriteMessageAndThrowable() {
        StringWriter writer = new StringWriter();
        FormattedLog log = FormattedLogTest.newFormattedLog(writer);
        log.info("Hasta la vista, baby", FormattedLogTest.newThrowable("<message>", "<stacktrace>"));
        MatcherAssert.assertThat((Object)writer.toString(), (Matcher)CoreMatchers.equalTo((Object)String.format("1984-10-26 04:23:24.343+0000 INFO [test] Hasta la vista, baby <message>%n<stacktrace>", new Object[0])));
    }

    @Test
    public void logShouldWriteMessageAndThrowableWithNullMessage() {
        StringWriter writer = new StringWriter();
        FormattedLog log = FormattedLogTest.newFormattedLog(writer);
        log.info("Hasta la vista, baby", FormattedLogTest.newThrowable(null, "<stacktrace>"));
        MatcherAssert.assertThat((Object)writer.toString(), (Matcher)CoreMatchers.equalTo((Object)String.format("1984-10-26 04:23:24.343+0000 INFO [test] Hasta la vista, baby%n<stacktrace>", new Object[0])));
    }

    @Test
    public void logShouldWriteMessageWithFormat() {
        StringWriter writer = new StringWriter();
        FormattedLog log = FormattedLogTest.newFormattedLog(writer);
        log.info("I need your %s, your %s and your %s", new Object[]{"clothes", "boots", "motorcycle"});
        MatcherAssert.assertThat((Object)writer.toString(), (Matcher)CoreMatchers.equalTo((Object)String.format("1984-10-26 04:23:24.343+0000 INFO [test] I need your clothes, your boots and your motorcycle%n", new Object[0])));
    }

    @Test
    public void logShouldWriteNotFormattedMessageWhenNoParametersGiven() {
        StringWriter writer = new StringWriter();
        FormattedLog log = FormattedLogTest.newFormattedLog(writer);
        log.info("Come with me if you %s to live!", new Object[0]);
        MatcherAssert.assertThat((Object)writer.toString(), (Matcher)CoreMatchers.equalTo((Object)String.format("1984-10-26 04:23:24.343+0000 INFO [test] Come with me if you %%s to live!%n", new Object[0])));
    }

    @Test
    public void logShouldFailAndWriteNothingForInvalidParametersArray() {
        StringWriter writer = new StringWriter();
        FormattedLog log = FormattedLogTest.newFormattedLog(writer);
        try {
            log.info("%s like me. A T-%d, advanced prototype.", new Object[]{"Not", "1000", 1000});
            Assert.fail((String)("Should have thrown " + IllegalFormatException.class));
        }
        catch (IllegalFormatException ife) {
            MatcherAssert.assertThat((Object)writer.toString(), (Matcher)CoreMatchers.equalTo((Object)""));
        }
    }

    @Test
    public void shouldNotWriteLogIfLevelIsHigherThanWritten() {
        StringWriter writer = new StringWriter();
        FormattedLog log = FormattedLogTest.newFormattedLog(writer, Level.WARN);
        log.info("I know now why you cry. But it's something I can never do.");
        MatcherAssert.assertThat((Object)writer.toString(), (Matcher)CoreMatchers.equalTo((Object)""));
    }

    @Test
    public void shouldAllowLevelToBeChanged() {
        StringWriter writer = new StringWriter();
        FormattedLog log = FormattedLogTest.newFormattedLog(writer, Level.INFO);
        log.info("No, it's when there's nothing wrong with you, but you hurt anyway. You get it?");
        log.setLevel(Level.WARN);
        log.info("I know now why you cry. But it's something I can never do.");
        log.setLevel(Level.DEBUG);
        log.info("There's 215 bones in the human body. That's one.");
        MatcherAssert.assertThat((Object)writer.toString(), (Matcher)CoreMatchers.equalTo((Object)String.format("%s%n%s%n", "1984-10-26 04:23:24.343+0000 INFO [test] No, it's when there's nothing wrong with you, but you hurt anyway. You get it?", "1984-10-26 04:23:24.343+0000 INFO [test] There's 215 bones in the human body. That's one.")));
    }

    private static FormattedLog newFormattedLog(StringWriter writer) {
        return FormattedLogTest.newFormattedLog(writer, Level.DEBUG);
    }

    private static FormattedLog newFormattedLog(StringWriter writer, Level level) {
        return FormattedLog.withUTCTimeZone().withCategory("test").withLogLevel(level).withTimeSupplier(DATE_TIME_SUPPLIER).toPrintWriter(Suppliers.singleton((Object)new PrintWriter(writer)));
    }

    private static Throwable newThrowable(final String message, final String stackTrace) {
        return new Throwable(){

            @Override
            public void printStackTrace(PrintWriter s) {
                s.append(stackTrace);
            }

            @Override
            public String getMessage() {
                return message;
            }
        };
    }
}

