/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.DuplicatingLog;
import org.neo4j.logging.DuplicatingLogProvider;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class DuplicatingLogProviderTest {
    @Test
    public void shouldReturnSameLoggerForSameClass() {
        DuplicatingLogProvider logProvider = new DuplicatingLogProvider(new LogProvider[0]);
        DuplicatingLog log = (DuplicatingLog)logProvider.getLog(this.getClass());
        MatcherAssert.assertThat((Object)logProvider.getLog(DuplicatingLogProviderTest.class), (Matcher)CoreMatchers.sameInstance((Object)log));
    }

    @Test
    public void shouldReturnSameLoggerForSameContext() {
        DuplicatingLogProvider logProvider = new DuplicatingLogProvider(new LogProvider[0]);
        DuplicatingLog log = (DuplicatingLog)logProvider.getLog("test context");
        MatcherAssert.assertThat((Object)logProvider.getLog("test context"), (Matcher)CoreMatchers.sameInstance((Object)log));
    }

    @Test
    public void shouldRemoveLogProviderFromDuplication() {
        AssertableLogProvider logProvider1 = new AssertableLogProvider();
        AssertableLogProvider logProvider2 = new AssertableLogProvider();
        DuplicatingLogProvider logProvider = new DuplicatingLogProvider(new LogProvider[]{logProvider1, logProvider2});
        Log log = logProvider.getLog(this.getClass());
        log.info("When the going gets weird");
        MatcherAssert.assertThat((Object)logProvider.remove((LogProvider)logProvider1), (Matcher)CoreMatchers.is((Object)true));
        log.info("The weird turn pro");
        logProvider1.assertExactly(AssertableLogProvider.inLog(this.getClass()).info("When the going gets weird"));
        logProvider2.assertExactly(AssertableLogProvider.inLog(this.getClass()).info("When the going gets weird"), AssertableLogProvider.inLog(this.getClass()).info("The weird turn pro"));
    }
}

