/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IllegalFormatException;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringEscapeUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.StringDescription;
import org.junit.Assert;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.logging.AbstractLog;
import org.neo4j.logging.AbstractLogProvider;
import org.neo4j.logging.Log;
import org.neo4j.logging.Logger;

public class AssertableLogProvider
extends AbstractLogProvider<Log>
implements TestRule {
    private final boolean debugEnabled;
    private final List<LogCall> logCalls = new CopyOnWriteArrayList<LogCall>();
    private static final Matcher<Level> DEBUG_LEVEL_MATCHER = Matchers.equalTo((Object)((Object)Level.DEBUG));
    private static final Matcher<Level> INFO_LEVEL_MATCHER = Matchers.equalTo((Object)((Object)Level.INFO));
    private static final Matcher<Level> WARN_LEVEL_MATCHER = Matchers.equalTo((Object)((Object)Level.WARN));
    private static final Matcher<Level> ERROR_LEVEL_MATCHER = Matchers.equalTo((Object)((Object)Level.ERROR));
    private static final Matcher<Level> ANY_LEVEL_MATCHER = Matchers.any(Level.class);
    private static final Matcher<String> ANY_MESSAGE_MATCHER = CoreMatchers.anyOf((Matcher)Matchers.any(String.class), (Matcher)Matchers.nullValue());
    private static final Matcher<Object[]> NULL_ARGUMENTS_MATCHER = Matchers.nullValue(Object[].class);
    private static final Matcher<Object[]> ANY_ARGUMENTS_MATCHER = CoreMatchers.anyOf((Matcher)Matchers.any(Object[].class), (Matcher)Matchers.nullValue());
    private static final Matcher<Throwable> NULL_THROWABLE_MATCHER = Matchers.nullValue(Throwable.class);
    private static final Matcher<Throwable> ANY_THROWABLE_MATCHER = CoreMatchers.anyOf((Matcher)Matchers.any(Throwable.class), (Matcher)Matchers.nullValue());

    public AssertableLogProvider() {
        this(false);
    }

    public AssertableLogProvider(boolean debugEnabled) {
        this.debugEnabled = debugEnabled;
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    base.evaluate();
                }
                catch (Throwable failure) {
                    AssertableLogProvider.this.print(System.out);
                    throw failure;
                }
            }
        };
    }

    public void print(PrintStream out) {
        for (LogCall call : this.logCalls) {
            out.println(call.toLogLikeString());
            if (call.throwable == null) continue;
            call.throwable.printStackTrace(out);
        }
    }

    protected Log buildLog(Class loggingClass) {
        return new AssertableLog(loggingClass.getName());
    }

    protected Log buildLog(String context) {
        return new AssertableLog(context);
    }

    public static LogMatcherBuilder inLog(Class logClass) {
        return AssertableLogProvider.inLog((Matcher<String>)Matchers.equalTo((Object)logClass.getName()));
    }

    public static LogMatcherBuilder inLog(String context) {
        return AssertableLogProvider.inLog((Matcher<String>)Matchers.equalTo((Object)context));
    }

    public static LogMatcherBuilder inLog(Matcher<String> contextMatcher) {
        return new LogMatcherBuilder(contextMatcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertExactly(LogMatcher ... expected) {
        Iterator<LogMatcher> expectedIterator = Arrays.asList(expected).iterator();
        List<LogCall> list = this.logCalls;
        synchronized (list) {
            Iterator<LogCall> callsIterator = this.logCalls.iterator();
            while (expectedIterator.hasNext()) {
                if (callsIterator.hasNext()) {
                    LogCall logCall;
                    LogMatcher logMatcher = expectedIterator.next();
                    if (logMatcher.matches(logCall = callsIterator.next())) continue;
                    Assert.fail((String)String.format("Log call did not match expectation\n  Expected: %s\n  Call was: %s", logMatcher, logCall));
                    continue;
                }
                Assert.fail((String)String.format("Got fewer log calls than expected. The missing log calls were:\n%s", this.describe(expectedIterator)));
            }
            if (callsIterator.hasNext()) {
                Assert.fail((String)String.format("Got more log calls than expected. The remaining log calls were:\n%s", this.serialize(callsIterator)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SafeVarargs
    public final void assertContainsLogCallsMatching(int logSkipCount, Matcher<String> ... matchers) {
        List<LogCall> list = this.logCalls;
        synchronized (list) {
            Assert.assertEquals((long)this.logCalls.size(), (long)(logSkipCount + matchers.length));
            for (int i = 0; i < matchers.length; ++i) {
                Matcher<String> matcher = matchers[i];
                LogCall logCall = this.logCalls.get(logSkipCount + i);
                if (matcher.matches((Object)logCall.message)) continue;
                StringDescription description = new StringDescription();
                description.appendDescriptionOf(matcher);
                Assert.fail((String)String.format("Expected log statement with message as %s, but none found. Actual log call was:\n%s", description.toString(), logCall.toString()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertContainsThrowablesMatching(int logSkipCount, Throwable ... throwables) {
        List<LogCall> list = this.logCalls;
        synchronized (list) {
            Assert.assertEquals((long)this.logCalls.size(), (long)(logSkipCount + throwables.length));
            for (int i = 0; i < throwables.length; ++i) {
                LogCall logCall = this.logCalls.get(logSkipCount + i);
                Throwable throwable = throwables[i];
                if ((logCall.throwable != null || throwable == null) && (logCall.throwable == null || logCall.throwable.getClass() == throwable.getClass())) continue;
                Assert.fail((String)String.format("Expected %s, but was:\n%s", throwable, logCall.throwable));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertAtLeastOnce(LogMatcher ... expected) {
        Set expectedMatchers = Iterators.asSet((Object[])expected);
        List<LogCall> list = this.logCalls;
        synchronized (list) {
            expectedMatchers.removeIf(this::containsMatchingLogCall);
            if (expectedMatchers.size() > 0) {
                Assert.fail((String)String.format("These log calls were expected, but never occurred:\n%s\nActual log calls were:\n%s", this.describe(expectedMatchers.iterator()), this.serialize(this.logCalls.iterator())));
            }
        }
    }

    public void assertNone(LogMatcher notExpected) {
        LogCall logCall = this.firstMatchingLogCall(notExpected);
        if (logCall != null) {
            Assert.fail((String)String.format("Log call was not expected, but occurred:\n%s\n", logCall.toString()));
        }
    }

    public void assertNoLogCallContaining(String partOfMessage) {
        if (this.containsLogCallContaining(partOfMessage)) {
            Assert.fail((String)String.format("Expected no log statement containing '%s', but at least one found. Actual log calls were:\n%s", partOfMessage, this.serialize(this.logCalls.iterator())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertLogStringContains(String partOfMessage) {
        List<LogCall> list = this.logCalls;
        synchronized (list) {
            for (LogCall logCall : this.logCalls) {
                if (!logCall.toLogLikeString().contains(partOfMessage)) continue;
                return;
            }
        }
        Assert.fail((String)String.format("Expected at least one log strings containing '%s', but none found. Actual log calls were:\n%s", partOfMessage, this.serialize(this.logCalls.iterator())));
    }

    public void assertContainsLogCallContaining(String partOfMessage) {
        if (!this.containsLogCallContaining(partOfMessage)) {
            Assert.fail((String)String.format("Expected at least one log statement containing '%s', but none found. Actual log calls were:\n%s", partOfMessage, this.serialize(this.logCalls.iterator())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean containsLogCallContaining(String partOfMessage) {
        List<LogCall> list = this.logCalls;
        synchronized (list) {
            for (LogCall logCall : this.logCalls) {
                if (!logCall.toString().contains(partOfMessage)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsMatchingLogCall(LogMatcher logMatcher) {
        return this.firstMatchingLogCall(logMatcher) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LogCall firstMatchingLogCall(LogMatcher logMatcher) {
        List<LogCall> list = this.logCalls;
        synchronized (list) {
            for (LogCall logCall : this.logCalls) {
                if (!logMatcher.matches(logCall)) continue;
                return logCall;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertContainsMessageContaining(String partOfMessage) {
        List<LogCall> list = this.logCalls;
        synchronized (list) {
            if (this.containsMessage(partOfMessage)) {
                return;
            }
            Assert.fail((String)String.format("Expected at least one log statement containing '%s', but none found. Actual log calls were:\n%s", partOfMessage, this.serialize(this.logCalls.iterator())));
        }
    }

    private boolean containsMessage(String partOfMessage) {
        for (LogCall logCall : this.logCalls) {
            if (!logCall.message.contains(partOfMessage)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertNoMessagesContaining(String partOfMessage) {
        List<LogCall> list = this.logCalls;
        synchronized (list) {
            if (this.containsMessage(partOfMessage)) {
                Assert.fail((String)String.format("Expected at least one log statement containing '%s', but none found. Actual log calls were:\n%s", partOfMessage, this.serialize(this.logCalls.iterator())));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertContainsMessageMatching(Matcher<String> messageMatcher) {
        List<LogCall> list = this.logCalls;
        synchronized (list) {
            for (LogCall logCall : this.logCalls) {
                if (!messageMatcher.matches((Object)logCall.message)) continue;
                return;
            }
            StringDescription description = new StringDescription();
            description.appendDescriptionOf(messageMatcher);
            Assert.fail((String)String.format("Expected at least one log statement with message as %s, but none found. Actual log calls were:\n%s", description.toString(), this.serialize(this.logCalls.iterator())));
        }
    }

    public void assertNoLoggingOccurred() {
        if (this.logCalls.size() != 0) {
            Assert.fail((String)String.format("Expected no log messages at all, but got:\n%s", this.serialize(this.logCalls.iterator())));
        }
    }

    public void clear() {
        this.logCalls.clear();
    }

    public String serialize() {
        return this.serialize(this.logCalls.iterator(), LogCall::toLogLikeString);
    }

    private String describe(Iterator<LogMatcher> matchers) {
        StringBuilder sb = new StringBuilder();
        while (matchers.hasNext()) {
            sb.append(matchers.next().toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    private String serialize(Iterator<LogCall> events) {
        return this.serialize(events, LogCall::toString);
    }

    private String serialize(Iterator<LogCall> events, Function<LogCall, String> serializer) {
        StringBuilder sb = new StringBuilder();
        while (events.hasNext()) {
            sb.append(serializer.apply(events.next()));
            sb.append("\n");
        }
        return sb.toString();
    }

    public static final class LogMatcherBuilder {
        private final Matcher<String> contextMatcher;

        private LogMatcherBuilder(Matcher<String> contextMatcher) {
            this.contextMatcher = contextMatcher;
        }

        public LogMatcher debug(String message) {
            return new LogMatcher(this.contextMatcher, (Matcher<Level>)DEBUG_LEVEL_MATCHER, (Matcher<String>)Matchers.equalTo((Object)message), (Matcher<? extends Object[]>)NULL_ARGUMENTS_MATCHER, (Matcher<? extends Throwable>)NULL_THROWABLE_MATCHER);
        }

        public LogMatcher debug(Matcher<String> messageMatcher) {
            return new LogMatcher(this.contextMatcher, (Matcher<Level>)DEBUG_LEVEL_MATCHER, messageMatcher, (Matcher<? extends Object[]>)NULL_ARGUMENTS_MATCHER, (Matcher<? extends Throwable>)NULL_THROWABLE_MATCHER);
        }

        public LogMatcher debug(Matcher<String> messageMatcher, Matcher<Throwable> throwableMatcher) {
            return new LogMatcher(this.contextMatcher, (Matcher<Level>)DEBUG_LEVEL_MATCHER, messageMatcher, (Matcher<? extends Object[]>)NULL_ARGUMENTS_MATCHER, throwableMatcher);
        }

        public LogMatcher debug(String format, Object ... arguments) {
            return this.debug((Matcher<String>)Matchers.equalTo((Object)format), arguments);
        }

        public LogMatcher debug(Matcher<String> format, Object ... arguments) {
            return new LogMatcher(this.contextMatcher, (Matcher<Level>)DEBUG_LEVEL_MATCHER, format, (Matcher<? extends Object[]>)Matchers.arrayContaining(this.ensureMatchers(arguments)), (Matcher<? extends Throwable>)NULL_THROWABLE_MATCHER);
        }

        public LogMatcher info(String message) {
            return new LogMatcher(this.contextMatcher, (Matcher<Level>)INFO_LEVEL_MATCHER, (Matcher<String>)Matchers.equalTo((Object)message), (Matcher<? extends Object[]>)NULL_ARGUMENTS_MATCHER, (Matcher<? extends Throwable>)NULL_THROWABLE_MATCHER);
        }

        public LogMatcher info(Matcher<String> messageMatcher) {
            return new LogMatcher(this.contextMatcher, (Matcher<Level>)INFO_LEVEL_MATCHER, messageMatcher, (Matcher<? extends Object[]>)NULL_ARGUMENTS_MATCHER, (Matcher<? extends Throwable>)NULL_THROWABLE_MATCHER);
        }

        public LogMatcher info(Matcher<String> messageMatcher, Matcher<Throwable> throwableMatcher) {
            return new LogMatcher(this.contextMatcher, (Matcher<Level>)INFO_LEVEL_MATCHER, messageMatcher, (Matcher<? extends Object[]>)NULL_ARGUMENTS_MATCHER, throwableMatcher);
        }

        public LogMatcher info(String format, Object ... arguments) {
            return this.info((Matcher<String>)Matchers.equalTo((Object)format), arguments);
        }

        public LogMatcher info(Matcher<String> format, Object ... arguments) {
            return new LogMatcher(this.contextMatcher, (Matcher<Level>)INFO_LEVEL_MATCHER, format, (Matcher<? extends Object[]>)Matchers.arrayContaining(this.ensureMatchers(arguments)), (Matcher<? extends Throwable>)NULL_THROWABLE_MATCHER);
        }

        public LogMatcher warn(String message) {
            return new LogMatcher(this.contextMatcher, (Matcher<Level>)WARN_LEVEL_MATCHER, (Matcher<String>)Matchers.equalTo((Object)message), (Matcher<? extends Object[]>)NULL_ARGUMENTS_MATCHER, (Matcher<? extends Throwable>)NULL_THROWABLE_MATCHER);
        }

        public LogMatcher warn(Matcher<String> messageMatcher) {
            return new LogMatcher(this.contextMatcher, (Matcher<Level>)WARN_LEVEL_MATCHER, messageMatcher, (Matcher<? extends Object[]>)NULL_ARGUMENTS_MATCHER, (Matcher<? extends Throwable>)NULL_THROWABLE_MATCHER);
        }

        public LogMatcher warn(Matcher<String> messageMatcher, Matcher<Throwable> throwableMatcher) {
            return new LogMatcher(this.contextMatcher, (Matcher<Level>)WARN_LEVEL_MATCHER, messageMatcher, (Matcher<? extends Object[]>)NULL_ARGUMENTS_MATCHER, throwableMatcher);
        }

        public LogMatcher warn(String format, Object ... arguments) {
            return this.warn((Matcher<String>)Matchers.equalTo((Object)format), arguments);
        }

        public LogMatcher warn(Matcher<String> format, Object ... arguments) {
            return new LogMatcher(this.contextMatcher, (Matcher<Level>)WARN_LEVEL_MATCHER, format, (Matcher<? extends Object[]>)Matchers.arrayContaining(this.ensureMatchers(arguments)), (Matcher<? extends Throwable>)NULL_THROWABLE_MATCHER);
        }

        public LogMatcher anyError() {
            return new LogMatcher(this.contextMatcher, (Matcher<Level>)ERROR_LEVEL_MATCHER, (Matcher<String>)Matchers.any(String.class), (Matcher<? extends Object[]>)ANY_ARGUMENTS_MATCHER, (Matcher<? extends Throwable>)ANY_THROWABLE_MATCHER);
        }

        public LogMatcher error(String message) {
            return new LogMatcher(this.contextMatcher, (Matcher<Level>)ERROR_LEVEL_MATCHER, (Matcher<String>)Matchers.equalTo((Object)message), (Matcher<? extends Object[]>)NULL_ARGUMENTS_MATCHER, (Matcher<? extends Throwable>)NULL_THROWABLE_MATCHER);
        }

        public LogMatcher error(Matcher<String> messageMatcher) {
            return new LogMatcher(this.contextMatcher, (Matcher<Level>)ERROR_LEVEL_MATCHER, messageMatcher, (Matcher<? extends Object[]>)NULL_ARGUMENTS_MATCHER, (Matcher<? extends Throwable>)NULL_THROWABLE_MATCHER);
        }

        public LogMatcher error(Matcher<String> messageMatcher, Matcher<? extends Throwable> throwableMatcher) {
            return new LogMatcher(this.contextMatcher, (Matcher<Level>)ERROR_LEVEL_MATCHER, messageMatcher, (Matcher<? extends Object[]>)NULL_ARGUMENTS_MATCHER, throwableMatcher);
        }

        public LogMatcher error(String format, Object ... arguments) {
            return this.error((Matcher<String>)Matchers.equalTo((Object)format), arguments);
        }

        public LogMatcher error(Matcher<String> format, Object ... arguments) {
            return new LogMatcher(this.contextMatcher, (Matcher<Level>)ERROR_LEVEL_MATCHER, format, (Matcher<? extends Object[]>)Matchers.arrayContaining(this.ensureMatchers(arguments)), (Matcher<? extends Throwable>)NULL_THROWABLE_MATCHER);
        }

        public LogMatcher any() {
            return new LogMatcher(this.contextMatcher, (Matcher<Level>)ANY_LEVEL_MATCHER, (Matcher<String>)ANY_MESSAGE_MATCHER, (Matcher<? extends Object[]>)CoreMatchers.anyOf((Matcher)NULL_ARGUMENTS_MATCHER, (Matcher)ANY_ARGUMENTS_MATCHER), (Matcher<? extends Throwable>)CoreMatchers.anyOf((Matcher)NULL_THROWABLE_MATCHER, (Matcher)ANY_THROWABLE_MATCHER));
        }

        private Matcher<Object>[] ensureMatchers(Object ... arguments) {
            ArrayList<Matcher> matchers = new ArrayList<Matcher>();
            for (Object arg : arguments) {
                if (arg instanceof Matcher) {
                    matchers.add((Matcher)arg);
                    continue;
                }
                matchers.add(Matchers.equalTo((Object)arg));
            }
            return matchers.toArray(new Matcher[arguments.length]);
        }
    }

    public static final class LogMatcher {
        private final Matcher<String> contextMatcher;
        private final Matcher<Level> levelMatcher;
        private final Matcher<String> messageMatcher;
        private final Matcher<? extends Object[]> argumentsMatcher;
        private final Matcher<? extends Throwable> throwableMatcher;

        public LogMatcher(Matcher<String> contextMatcher, Matcher<Level> levelMatcher, Matcher<String> messageMatcher, Matcher<? extends Object[]> argumentsMatcher, Matcher<? extends Throwable> throwableMatcher) {
            this.contextMatcher = contextMatcher;
            this.levelMatcher = levelMatcher;
            this.messageMatcher = messageMatcher;
            this.argumentsMatcher = argumentsMatcher;
            this.throwableMatcher = throwableMatcher;
        }

        protected boolean matches(LogCall logCall) {
            return logCall != null && this.contextMatcher.matches((Object)logCall.context) && this.levelMatcher.matches((Object)logCall.level) && this.messageMatcher.matches((Object)logCall.message) && this.argumentsMatcher.matches((Object)logCall.arguments) && this.throwableMatcher.matches((Object)logCall.throwable);
        }

        public String toString() {
            StringDescription description = new StringDescription();
            description.appendText("LogMatcher{");
            description.appendDescriptionOf(this.contextMatcher);
            description.appendText(", ");
            description.appendDescriptionOf(this.levelMatcher);
            description.appendText(", message=");
            description.appendDescriptionOf(this.messageMatcher);
            description.appendText(", arguments=");
            description.appendDescriptionOf(this.argumentsMatcher);
            description.appendText(", throwable=");
            description.appendDescriptionOf(this.throwableMatcher);
            description.appendText("}");
            return description.toString();
        }
    }

    private class AssertableLog
    extends AbstractLog {
        private final Logger debugLogger;
        private final Logger infoLogger;
        private final Logger warnLogger;
        private final Logger errorLogger;

        AssertableLog(String context) {
            this.debugLogger = new LogCallRecorder(context, Level.DEBUG);
            this.infoLogger = new LogCallRecorder(context, Level.INFO);
            this.warnLogger = new LogCallRecorder(context, Level.WARN);
            this.errorLogger = new LogCallRecorder(context, Level.ERROR);
        }

        public boolean isDebugEnabled() {
            return AssertableLogProvider.this.debugEnabled;
        }

        @Nonnull
        public Logger debugLogger() {
            return this.debugLogger;
        }

        @Nonnull
        public Logger infoLogger() {
            return this.infoLogger;
        }

        @Nonnull
        public Logger warnLogger() {
            return this.warnLogger;
        }

        @Nonnull
        public Logger errorLogger() {
            return this.errorLogger;
        }

        public void bulk(@Nonnull Consumer<Log> consumer) {
            consumer.accept((Log)this);
        }
    }

    private class LogCallRecorder
    implements Logger {
        private final String context;
        private final Level level;

        LogCallRecorder(String context, Level level) {
            this.context = context;
            this.level = level;
        }

        public void log(@Nonnull String message) {
            AssertableLogProvider.this.logCalls.add(new LogCall(this.context, this.level, message, null, null));
        }

        public void log(@Nonnull String message, @Nonnull Throwable throwable) {
            AssertableLogProvider.this.logCalls.add(new LogCall(this.context, this.level, message, null, throwable));
        }

        public void log(@Nonnull String format, Object ... arguments) {
            AssertableLogProvider.this.logCalls.add(new LogCall(this.context, this.level, format, arguments, null));
        }

        public void bulk(@Nonnull Consumer<Logger> consumer) {
            consumer.accept(this);
        }
    }

    private static final class LogCall {
        private final String context;
        private final Level level;
        private final String message;
        private final Object[] arguments;
        private final Throwable throwable;

        private LogCall(String context, Level level, String message, Object[] arguments, Throwable throwable) {
            this.level = level;
            this.context = context;
            this.message = message;
            this.arguments = arguments;
            this.throwable = throwable;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("LogCall{");
            builder.append(this.context);
            builder.append(" ");
            builder.append((Object)this.level);
            builder.append(", message=");
            if (this.message != null) {
                builder.append('\'').append(StringEscapeUtils.escapeJava((String)this.message)).append('\'');
            } else {
                builder.append("null");
            }
            builder.append(", arguments=");
            if (this.arguments != null) {
                builder.append("[");
                boolean first = true;
                for (Object arg : this.arguments) {
                    if (!first) {
                        builder.append(',');
                    }
                    first = false;
                    builder.append(StringEscapeUtils.escapeJava((String)("" + arg)));
                }
                builder.append("]");
            } else {
                builder.append("null");
            }
            builder.append(", throwable=");
            if (this.throwable != null) {
                builder.append('\'').append(StringEscapeUtils.escapeJava((String)this.throwable.toString())).append('\'');
            } else {
                builder.append("null");
            }
            builder.append("}");
            return builder.toString();
        }

        public String toLogLikeString() {
            String msg;
            if (this.arguments != null) {
                try {
                    msg = String.format(this.message, this.arguments);
                }
                catch (IllegalFormatException e) {
                    msg = String.format("IllegalFormat{message: \"%s\", arguments: %s}", this.message, Arrays.toString(this.arguments));
                }
            } else {
                msg = this.message;
            }
            return String.format("%s @ %s: %s", new Object[]{this.level, this.context, msg});
        }
    }

    public static enum Level {
        DEBUG,
        INFO,
        WARN,
        ERROR;

    }
}

