/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging.async;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.concurrent.AsyncEventSender;
import org.neo4j.logging.AbstractLog;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.Log;
import org.neo4j.logging.Logger;
import org.neo4j.logging.async.AsyncLog;
import org.neo4j.logging.async.AsyncLogEvent;

@RunWith(value=Parameterized.class)
public class AsyncLogTest {
    private final Throwable exception = new Exception();
    private final Invocation invocation;
    private final Level level;
    private final Style style;

    @Parameterized.Parameters(name="{0} {1}.log({2})")
    public static Iterable<Object[]> parameters() {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        for (Invocation invocation : Invocation.values()) {
            for (Level level : Level.values()) {
                for (Style style : Style.values()) {
                    parameters.add(new Object[]{invocation, level, style});
                }
            }
        }
        return parameters;
    }

    public AsyncLogTest(Invocation invocation, Level level, Style style) {
        this.invocation = invocation;
        this.level = level;
        this.style = style;
    }

    @Test
    public void shouldLogAsynchronously() throws Exception {
        AssertableLogProvider logging = new AssertableLogProvider();
        Log log = logging.getLog(this.getClass());
        DeferredSender events = new DeferredSender();
        AsyncLog asyncLog = new AsyncLog((AsyncEventSender)events, log);
        this.log(this.invocation.decorate((Log)asyncLog));
        logging.assertNoLoggingOccurred();
        events.process();
        MatcherBuilder matcherBuilder = new MatcherBuilder(AssertableLogProvider.inLog(this.getClass()));
        this.log((Log)matcherBuilder);
        logging.assertExactly(matcherBuilder.matcher());
    }

    private void log(Log log) {
        this.style.invoke(this, this.level.logger(log));
    }

    static class MatcherBuilder
    extends AbstractLog {
        private final AssertableLogProvider.LogMatcherBuilder builder;
        private AssertableLogProvider.LogMatcher matcher;

        MatcherBuilder(AssertableLogProvider.LogMatcherBuilder builder) {
            this.builder = builder;
        }

        public AssertableLogProvider.LogMatcher matcher() {
            return Objects.requireNonNull(this.matcher, "invalid use, no matcher built");
        }

        public boolean isDebugEnabled() {
            return true;
        }

        public void bulk(@Nonnull Consumer<Log> consumer) {
            throw new UnsupportedOperationException();
        }

        @Nonnull
        public Logger debugLogger() {
            return new Logger(){

                public void log(@Nonnull String message) {
                    matcher = builder.debug((Matcher<String>)this.messageMatcher(message));
                }

                public void log(@Nonnull String message, @Nonnull Throwable throwable) {
                    matcher = builder.debug((Matcher<String>)this.messageMatcher(message), (Matcher<Throwable>)CoreMatchers.sameInstance((Object)throwable));
                }

                public void log(@Nonnull String format, Object ... arguments) {
                    matcher = builder.debug((Matcher<String>)this.messageMatcher(format), arguments);
                }

                public void bulk(@Nonnull Consumer<Logger> consumer) {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Nonnull
        public Logger infoLogger() {
            return new Logger(){

                public void log(@Nonnull String message) {
                    matcher = builder.info((Matcher<String>)this.messageMatcher(message));
                }

                public void log(@Nonnull String message, @Nonnull Throwable throwable) {
                    matcher = builder.info((Matcher<String>)this.messageMatcher(message), (Matcher<Throwable>)CoreMatchers.sameInstance((Object)throwable));
                }

                public void log(@Nonnull String format, Object ... arguments) {
                    matcher = builder.info((Matcher<String>)this.messageMatcher(format), arguments);
                }

                public void bulk(@Nonnull Consumer<Logger> consumer) {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Nonnull
        public Logger warnLogger() {
            return new Logger(){

                public void log(@Nonnull String message) {
                    matcher = builder.warn((Matcher<String>)this.messageMatcher(message));
                }

                public void log(@Nonnull String message, @Nonnull Throwable throwable) {
                    matcher = builder.warn((Matcher<String>)this.messageMatcher(message), (Matcher<Throwable>)CoreMatchers.sameInstance((Object)throwable));
                }

                public void log(@Nonnull String format, Object ... arguments) {
                    matcher = builder.warn((Matcher<String>)this.messageMatcher(format), arguments);
                }

                public void bulk(@Nonnull Consumer<Logger> consumer) {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Nonnull
        public Logger errorLogger() {
            return new Logger(){

                public void log(@Nonnull String message) {
                    matcher = builder.error((Matcher<String>)this.messageMatcher(message));
                }

                public void log(@Nonnull String message, @Nonnull Throwable throwable) {
                    matcher = builder.error((Matcher<String>)this.messageMatcher(message), (Matcher<? extends Throwable>)CoreMatchers.sameInstance((Object)throwable));
                }

                public void log(@Nonnull String format, Object ... arguments) {
                    matcher = builder.error((Matcher<String>)this.messageMatcher(format), arguments);
                }

                public void bulk(@Nonnull Consumer<Logger> consumer) {
                    throw new UnsupportedOperationException();
                }
            };
        }

        private Matcher<String> messageMatcher(@Nonnull String message) {
            return CoreMatchers.allOf((Matcher)CoreMatchers.startsWith((String)"[AsyncLog @ "), (Matcher)CoreMatchers.endsWith((String)("]  " + message)));
        }
    }

    static class DirectLog
    extends AbstractLog {
        final Log log;

        DirectLog(Log log) {
            this.log = log;
        }

        public boolean isDebugEnabled() {
            throw new UnsupportedOperationException();
        }

        public void bulk(@Nonnull Consumer<Log> consumer) {
            throw new UnsupportedOperationException();
        }

        @Nonnull
        public Logger debugLogger() {
            return new Logger(){

                public void log(@Nonnull String message) {
                    log.debug(message);
                }

                public void log(@Nonnull String message, @Nonnull Throwable throwable) {
                    log.debug(message, throwable);
                }

                public void log(@Nonnull String format, Object ... arguments) {
                    log.debug(format, arguments);
                }

                public void bulk(@Nonnull Consumer<Logger> consumer) {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Nonnull
        public Logger infoLogger() {
            return new Logger(){

                public void log(@Nonnull String message) {
                    log.info(message);
                }

                public void log(@Nonnull String message, @Nonnull Throwable throwable) {
                    log.info(message, throwable);
                }

                public void log(@Nonnull String format, Object ... arguments) {
                    log.info(format, arguments);
                }

                public void bulk(@Nonnull Consumer<Logger> consumer) {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Nonnull
        public Logger warnLogger() {
            return new Logger(){

                public void log(@Nonnull String message) {
                    log.warn(message);
                }

                public void log(@Nonnull String message, @Nonnull Throwable throwable) {
                    log.warn(message, throwable);
                }

                public void log(@Nonnull String format, Object ... arguments) {
                    log.warn(format, arguments);
                }

                public void bulk(@Nonnull Consumer<Logger> consumer) {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Nonnull
        public Logger errorLogger() {
            return new Logger(){

                public void log(@Nonnull String message) {
                    log.error(message);
                }

                public void log(@Nonnull String message, @Nonnull Throwable throwable) {
                    log.error(message, throwable);
                }

                public void log(@Nonnull String format, Object ... arguments) {
                    log.error(format, arguments);
                }

                public void bulk(@Nonnull Consumer<Logger> consumer) {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    static class DeferredSender
    implements AsyncEventSender<AsyncLogEvent> {
        private final List<AsyncLogEvent> events = new ArrayList<AsyncLogEvent>();

        DeferredSender() {
        }

        public void send(AsyncLogEvent event) {
            this.events.add(event);
        }

        public void process() {
            for (AsyncLogEvent event : this.events) {
                event.process();
            }
            this.events.clear();
        }
    }

    static enum Style {
        MESSAGE{

            @Override
            void invoke(AsyncLogTest state, Logger logger) {
                logger.log("a message");
            }

            public String toString() {
                return " <message> ";
            }
        }
        ,
        THROWABLE{

            @Override
            void invoke(AsyncLogTest state, Logger logger) {
                logger.log("an exception", state.exception);
            }

            public String toString() {
                return " <message>, <exception> ";
            }
        }
        ,
        FORMAT{

            @Override
            void invoke(AsyncLogTest state, Logger logger) {
                logger.log("a %s message", new Object[]{"formatted"});
            }

            public String toString() {
                return " <format>, <parameters...> ";
            }
        };


        abstract void invoke(AsyncLogTest var1, Logger var2);
    }

    static enum Level {
        DEBUG{

            @Override
            Logger logger(Log log) {
                return log.debugLogger();
            }
        }
        ,
        INFO{

            @Override
            Logger logger(Log log) {
                return log.infoLogger();
            }
        }
        ,
        WARN{

            @Override
            Logger logger(Log log) {
                return log.warnLogger();
            }
        }
        ,
        ERROR{

            @Override
            Logger logger(Log log) {
                return log.errorLogger();
            }
        };


        abstract Logger logger(Log var1);
    }

    static enum Invocation {
        DIRECT{

            @Override
            Log decorate(Log log) {
                return new DirectLog(log);
            }
        }
        ,
        INDIRECT{

            @Override
            Log decorate(Log log) {
                return log;
            }
        };


        abstract Log decorate(Log var1);
    }
}

